@extends('layout.main')
@section('content')
    @if(session()->has('message'))
        <div class="alert alert-success alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>{!! session()->get('message') !!}</div>
    @endif
    @if(session()->has('not_permitted'))
        <div class="alert alert-danger alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>{{ session()->get('not_permitted') }}</div>
    @endif
    <section>
        <div class="container-fluid">
            <button class="btn btn-info" data-toggle="modal" data-target="#createModal"><i class="dripicons-plus"></i> {{trans('file.Add Discount')}} </button>
        </div>
        <div class="table-responsive">
            <table id="discount-table" class="table">
                <thead>
                <tr>
                    <th class="not-exported"></th>
                    <th>{{trans('file.name')}}</th>
                    <th>{{trans('file.value')}}</th>
                    <th>{{trans('file.Type')}}</th>
                    <th>{{trans('file.Date')}}</th>
                    <th class="not-exported">{{trans('file.action')}}</th>
                </tr>
                </thead>
                <tbody>
                @foreach($discounts as $key =>  $discount )
                    <?php
                    ?>
                    <tr>
                        <td>{{$key}}</td>
                        <td>{{ $discount->title }}</td>
                        <td>{{ $discount->value }}</td>
                        <td>{{ $discount->type == 'val' ? '$' : '%' }}</td>
                        <td>{{ $discount->created_at->format('Y-m-d H:i:s') ?? 'No date' }}</td>
                        <td>
                            <div class="btn-group">
                                <button type="button" class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">{{trans('file.action')}}
                                    <span class="caret"></span>
                                    <span class="sr-only">Toggle Dropdown</span>
                                </button>
                                <ul class="dropdown-menu edit-options dropdown-menu-right dropdown-default" user="menu">
                                    <li>
                                        <button type="button" data-id="{{$discount->id}}" class="open-EditrewardsDialog btn btn-link" data-toggle="modal" data-target="#editModal"><i class="dripicons-document-edit"></i> {{trans('file.edit')}}
                                        </button>
                                    </li>
                                    <li class="divider"></li>
                                    {{ Form::open(['route' => ['discounts.destroy', $discount->id], 'method' => 'DELETE'] ) }}
                                    <li>
                                        <button type="submit" class="btn btn-link" onclick="return confirmDelete()"><i class="dripicons-trash"></i> {{trans('file.delete')}}</button>
                                    </li>
                                    {{ Form::close() }}
                                </ul>
                            </div>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </section>

    <div id="createModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" class="modal fade text-left">
        <div role="document" class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 id="exampleModalLabel" class="modal-title">{{trans('file.Add Discount')}}</h5>
                    <button type="button" data-dismiss="modal" aria-label="Close" class="close"><span aria-hidden="true"><i class="dripicons-cross"></i></span></button>
                </div>
                <div class="modal-body">
                    <p class="italic"><small>{{trans('file.The field labels marked with * are required input fields')}}.</small></p>
                    {!! Form::open(['route' => 'discounts.store', 'method' => 'post','enctype' => 'multipart/form-data']) !!}
                    <div class="row">
                        <div class="col-md-12 form-group">
                            <label>{{trans('file.name')}} *</label>
                            <input type="text" name="title" class="form-control"  required>
                        </div>

                        <div class="col-md-6 form-group">
                            <label>{{trans('file.value')}} *</label>
                            <input type="number" name="value" id="value" class="form-control" required>
                        </div>
                        <div class="col-md-6 form-group">
                            <label>{{trans('file.Type')}} *</label>
                            <select type="text" name="type" id="type" class="form-control" required>
                                <option value="" selected disabled>{{ trans('file.Type') }}</option>
                                <option value="per">Percent</option>
                                <option value="val">Value</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <button type="submit" class="btn btn-primary">{{trans('file.submit')}}</button>
                    </div>
                    {{ Form::close() }}
                </div>
            </div>
        </div>
    </div>

    <div id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" class="modal fade text-left">
        <div role="document" class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 id="exampleModalLabel" class="modal-title">{{trans('file.Update Holiday')}}</h5>
                    <button type="button" data-dismiss="modal" aria-label="Close" class="close"><span aria-hidden="true"><i class="dripicons-cross"></i></span></button>
                </div>
                <div class="modal-body">
                    <p class="italic"><small>{{trans('file.The field labels marked with * are required input fields')}}.</small></p>
                    {!! Form::open(['route' => ['discounts.update', 1], 'method' => 'put','enctype' => 'multipart/form-data']) !!}
                    <div class="row">
                        <input type="text" name="id" id="id" hidden>
                        <div class="col-md-12 form-group">
                            <label>{{trans('file.name')}} *</label>
                            <input type="text" name="title" class="form-control"  required>
                        </div>

                        <div class="col-md-6 form-group">
                            <label>{{trans('file.value')}} *</label>
                            <input type="number" name="value" id="value" class="form-control" required>
                        </div>
                        <div class="col-md-6 form-group">
                            <label>{{trans('file.Type')}} *</label>
                            <select type="text" name="type" id="type" class="form-control" required>
                                <option value="per">Percent</option>
                                <option value="val">Value</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <button type="submit" class="btn btn-primary">{{trans('file.submit')}}</button>
                    </div>
                    {{ Form::close() }}
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">

        $("ul#setting").siblings('a').attr('aria-expanded','true');
        $("ul#setting").addClass("show");
        $("ul#setting #table-setting-menu").addClass("active");

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        function confirmDelete() {
            if (confirm("Are you sure want to delete?")) {
                return true;
            }
            return false;
        }

        var holiday_id = [];
        var user_verified = <?php echo json_encode(env('USER_VERIFIED')) ?>;

        var date = $('.date');
        date.datepicker({
            format: "dd-mm-yyyy",
            startDate: "<?php echo date('d-m-Y'); ?>",
            autoclose: true,
            todayHighlight: true
        });

        $(document).on('click', '.btn-approve', function() {
            var id = $(this).data('id');
            $.get('approve-holiday/'+id, function(data) {
                $('.btn-approve').addClass('d-none');
            });
        });



        $('#discount-table').DataTable( {
            "order": [],
            'language': {
                'lengthMenu': '_MENU_ {{trans("file.records per page")}}',
                "info":      '<small>{{trans("file.Showing")}} _START_ - _END_ (_TOTAL_)</small>',
                "search":  '{{trans("file.Search")}}',
                'paginate': {
                    'previous': '<i class="dripicons-chevron-left"></i>',
                    'next': '<i class="dripicons-chevron-right"></i>'
                }
            },
            'columnDefs': [
                {
                    "orderable": false,
                    'targets': [0, 4]
                },
                {
                    'render': function(data, type, row, meta){
                        if(type === 'display'){
                            data = '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>';
                        }

                        return data;
                    },
                    'checkboxes': {
                        'selectRow': true,
                        'selectAllRender': '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>'
                    },
                    'targets': [0]
                }
            ],
            'select': { style: 'multi',  selector: 'td:first-child'},
            'lengthMenu': [[10, 25, 50, -1], [10, 25, 50, "All"]],
            dom: '<"row"lfB>rtip',
            buttons: [
                {
                    extend: 'pdf',
                    text: '{{trans("file.PDF")}}',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible',
                    }
                },
                {
                    extend: 'csv',
                    text: '{{trans("file.CSV")}}',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible',
                    },
                },
                {
                    extend: 'print',
                    text: '{{trans("file.Print")}}',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible',
                    },
                },
                {
                    extend: 'colvis',
                    text: '{{trans("file.Column visibility")}}',
                    columns: ':gt(0)'
                },
            ],
        } );
    </script>
    <script>

        $(document).ready(function() {
            $(document).on('click', '.open-EditrewardsDialog', function() {
                var url = "discounts/"
                var id = $(this).data('id').toString();
                url = url.concat(id).concat("/edit");

                $.get(url, function(data) {
                    console.log(data)
                    $("#editModal input[name='title']").val(data['title']);
                    $("#editModal select[name='type']").val(data['type']);
                    $("#editModal input[name='id']").val(data['id']);
                    $("#editModal input[name='value']").val(data['value']);
                });
            });
        });
    </script>
@endsection
