-- phpMyAdmin SQL Dump
-- version 5.2.0
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1:3306
-- Generation Time: Jun 01, 2023 at 07:48 AM
-- Server version: 8.0.31
-- PHP Version: 8.0.26

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `skyparkpos`
--

-- --------------------------------------------------------

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
CREATE TABLE IF NOT EXISTS `accounts` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `account_no` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `initial_balance` double DEFAULT NULL,
  `total_balance` double NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `is_default` tinyint(1) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `accounts`
--

INSERT INTO `accounts` (`id`, `account_no`, `name`, `initial_balance`, `total_balance`, `note`, `is_default`, `is_active`, `created_at`, `updated_at`) VALUES
(1, '11111', 'Sales Account', 1000, 1000, 'this is first account', 1, 1, '2018-12-18 02:58:02', '2019-01-20 09:59:06'),
(3, '21211', 'Sa', NULL, 0, NULL, 0, 1, '2018-12-18 02:58:56', '2019-01-20 09:59:06');

-- --------------------------------------------------------

--
-- Table structure for table `adjustments`
--

DROP TABLE IF EXISTS `adjustments`;
CREATE TABLE IF NOT EXISTS `adjustments` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `warehouse_id` int NOT NULL,
  `document` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_qty` double NOT NULL,
  `item` int NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `adjustments`
--

INSERT INTO `adjustments` (`id`, `reference_no`, `warehouse_id`, `document`, `total_qty`, `item`, `note`, `created_at`, `updated_at`) VALUES
(8, 'adr-20230314-115231', 3, NULL, 1300, 38, NULL, '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(9, 'adr-20230315-102036', 3, NULL, 395, 42, NULL, '2023-03-15 08:20:36', '2023-03-15 08:20:36'),
(10, 'adr-20230409-123427', 3, NULL, 364, 28, NULL, '2023-04-09 10:34:27', '2023-04-09 10:34:27');

-- --------------------------------------------------------

--
-- Table structure for table `attendances`
--

DROP TABLE IF EXISTS `attendances`;
CREATE TABLE IF NOT EXISTS `attendances` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `employee_id` int NOT NULL,
  `user_id` int NOT NULL,
  `checkin` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `checkout` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `billers`
--

DROP TABLE IF EXISTS `billers`;
CREATE TABLE IF NOT EXISTS `billers` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `vat_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone_number` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postal_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `billers`
--

INSERT INTO `billers` (`id`, `name`, `image`, `company_name`, `vat_number`, `email`, `phone_number`, `address`, `city`, `state`, `postal_code`, `country`, `is_active`, `created_at`, `updated_at`) VALUES
(10, 'AbouGabal', NULL, 'SkyPark', '311416936900003', 'mohamed.ibrahim@skypark.fun', '⁦+20 112 141 1940⁩', '6th of October', '6th of October', '6th of October', NULL, 'Giza', 1, '2022-08-07 16:51:56', '2022-08-07 16:51:56');

-- --------------------------------------------------------

--
-- Table structure for table `brands`
--

DROP TABLE IF EXISTS `brands`;
CREATE TABLE IF NOT EXISTS `brands` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `brands`
--

INSERT INTO `brands` (`id`, `title`, `image`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'Chipsy', '20220808012132.jpg', 1, '2022-04-26 14:28:56', '2022-08-08 13:21:32'),
(2, 'Nestle', '20220808012247.jpg', 1, '2022-08-08 13:22:47', '2022-08-08 13:22:47'),
(3, 'Juhayna', '20220808014332.png', 1, '2022-08-08 13:43:32', '2022-08-08 13:43:32');

-- --------------------------------------------------------

--
-- Table structure for table `cash_registers`
--

DROP TABLE IF EXISTS `cash_registers`;
CREATE TABLE IF NOT EXISTS `cash_registers` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `cash_in_hand` double NOT NULL,
  `user_id` int NOT NULL,
  `warehouse_id` int NOT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cash_registers`
--

INSERT INTO `cash_registers` (`id`, `cash_in_hand`, `user_id`, `warehouse_id`, `status`, `created_at`, `updated_at`) VALUES
(8, 0, 1, 3, 0, '2022-09-05 13:46:11', '2022-12-08 13:18:08'),
(9, 10, 30, 3, 0, '2022-09-16 16:19:00', '2022-09-18 12:08:22'),
(10, 0, 30, 3, 0, '2022-09-22 23:15:11', '2022-09-24 17:20:14'),
(11, 10, 30, 3, 0, '2022-09-24 17:20:31', '2023-01-20 13:33:10'),
(12, 1, 30, 3, 0, '2023-01-20 13:33:24', '2023-01-20 21:29:17'),
(13, 0, 30, 3, 0, '2023-01-20 21:29:30', '2023-01-22 14:35:05'),
(14, 0, 30, 3, 0, '2023-01-22 14:35:09', '2023-05-30 05:35:03'),
(15, 0, 1, 3, 0, '2023-03-14 09:36:33', '2023-05-30 05:35:55'),
(16, 100, 1, 3, 0, '2023-05-30 05:36:31', '2023-05-30 06:46:33'),
(17, 100, 1, 3, 0, '2023-05-30 06:46:41', '2023-05-31 07:36:44'),
(18, 100, 1, 3, 1, '2023-05-31 07:47:48', '2023-05-31 07:47:48');

-- --------------------------------------------------------

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
CREATE TABLE IF NOT EXISTS `categories` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` int DEFAULT NULL,
  `make` enum('make','no','both') COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'both يتم تصنيعة ويدخل فى التصنيع',
  `is_active` tinyint(1) DEFAULT NULL,
  `is_sale` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `make_place` enum('in','out') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `categories`
--

INSERT INTO `categories` (`id`, `name`, `image`, `parent_id`, `make`, `is_active`, `is_sale`, `make_place`, `created_at`, `updated_at`) VALUES
(1, 'Snacks', '20220521095106.jpg', NULL, 'no', 1, 'yes', 'in', '2022-04-26 14:20:13', '2023-05-30 08:06:08'),
(2, 'Beverage', '20220521095047.jpg', NULL, 'no', 1, 'yes', 'in', '2022-05-17 14:04:06', '2023-05-14 10:50:44'),
(3, 'Meals', '20220521094849.jpg', NULL, 'make', 1, 'yes', 'in', '2022-05-21 09:48:49', '2022-06-13 11:31:50'),
(4, 'KIT', NULL, NULL, 'no', 1, 'yes', 'out', '2022-05-21 10:09:05', '2023-05-02 07:06:42'),
(5, 'Raw Materials', NULL, NULL, 'no', 1, 'yes', 'in', '2022-06-13 11:38:35', '2023-05-30 08:30:55'),
(6, 'F&B', NULL, NULL, NULL, 1, 'no', NULL, '2023-03-15 08:36:35', '2023-03-15 08:36:35');

-- --------------------------------------------------------

--
-- Table structure for table `coupons`
--

DROP TABLE IF EXISTS `coupons`;
CREATE TABLE IF NOT EXISTS `coupons` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double NOT NULL,
  `minimum_amount` double DEFAULT NULL,
  `quantity` int NOT NULL,
  `used` int NOT NULL,
  `expired_date` date NOT NULL,
  `user_id` int NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `currencies`
--

DROP TABLE IF EXISTS `currencies`;
CREATE TABLE IF NOT EXISTS `currencies` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `exchange_rate` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `currencies`
--

INSERT INTO `currencies` (`id`, `name`, `code`, `exchange_rate`, `created_at`, `updated_at`) VALUES
(1, 'جنية', 'LE', 1, '2020-11-01 00:22:58', '2021-12-25 15:09:21');

-- --------------------------------------------------------

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
CREATE TABLE IF NOT EXISTS `customers` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `customer_group_id` int NOT NULL,
  `user_id` int DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `membership_number` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone_number` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tax_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postal_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `points` double DEFAULT NULL,
  `deposit` double DEFAULT NULL,
  `expense` double DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `customers`
--

INSERT INTO `customers` (`id`, `customer_group_id`, `user_id`, `name`, `membership_number`, `company_name`, `email`, `phone_number`, `tax_no`, `address`, `city`, `state`, `postal_code`, `country`, `points`, `deposit`, `expense`, `is_active`, `created_at`, `updated_at`) VALUES
(2, 1, NULL, 'Cash', '1001001', NULL, 'cash@cash.com', '01234567891', NULL, '123', 'Cairo', NULL, NULL, NULL, 137, NULL, NULL, 1, '2022-05-25 14:26:25', '2023-01-21 20:39:28'),
(4, 4, NULL, 'Corporate', '2', 'SkyPark', NULL, '01156668599', NULL, 'Cairo', 'NasrCity', NULL, NULL, NULL, NULL, NULL, NULL, 1, '2022-12-11 20:22:21', '2022-12-11 20:22:21'),
(5, 3, NULL, 'Birthday', '4', 'SkyPark', NULL, '0123456789', NULL, 'cairo', 'NasrCity', NULL, NULL, NULL, NULL, NULL, NULL, 1, '2022-12-11 20:24:42', '2022-12-11 20:24:42'),
(6, 2, NULL, 'School', '5', 'SkyPark', NULL, '012345678', NULL, 'cairo', 'NasrCity', NULL, NULL, NULL, NULL, NULL, NULL, 1, '2022-12-11 20:25:38', '2022-12-11 20:25:38'),
(7, 1, NULL, 'abdallah', '423423424', NULL, 'abdallahmahmoud1422003@gmail.com', '01098604983', NULL, 'dddddddd', 'aaa', NULL, NULL, NULL, NULL, NULL, NULL, 1, '2023-05-31 07:54:45', '2023-05-31 07:54:45'),
(8, 1, NULL, 'abdallah', NULL, NULL, NULL, '010986049833', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2023-06-01 05:53:31', '2023-06-01 05:53:31');

-- --------------------------------------------------------

--
-- Table structure for table `customer_groups`
--

DROP TABLE IF EXISTS `customer_groups`;
CREATE TABLE IF NOT EXISTS `customer_groups` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `percentage` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `customer_groups`
--

INSERT INTO `customer_groups` (`id`, `name`, `percentage`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'Family', '0', 1, '2022-04-26 14:32:28', '2022-05-31 16:20:46'),
(2, 'School', '0', 1, '2022-12-11 20:19:57', '2022-12-11 20:20:06'),
(3, 'Birthday', '0', 1, '2022-12-11 20:20:43', '2022-12-11 20:20:43'),
(4, 'Corporate', '0', 1, '2022-12-11 20:21:17', '2022-12-11 20:21:17');

-- --------------------------------------------------------

--
-- Table structure for table `deliveries`
--

DROP TABLE IF EXISTS `deliveries`;
CREATE TABLE IF NOT EXISTS `deliveries` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sale_id` int NOT NULL,
  `user_id` int DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `delivered_by` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `recieved_by` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `departments`
--

DROP TABLE IF EXISTS `departments`;
CREATE TABLE IF NOT EXISTS `departments` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `deposits`
--

DROP TABLE IF EXISTS `deposits`;
CREATE TABLE IF NOT EXISTS `deposits` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `amount` double NOT NULL,
  `customer_id` int NOT NULL,
  `user_id` int NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `discounts`
--

DROP TABLE IF EXISTS `discounts`;
CREATE TABLE IF NOT EXISTS `discounts` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` int NOT NULL,
  `type` enum('val','per') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `discounts`
--

INSERT INTO `discounts` (`id`, `title`, `value`, `type`, `created_at`, `updated_at`) VALUES
(3, 'خصم 10 فالمية للعاملين', 10, 'per', '2023-05-09 07:42:53', '2023-05-09 07:42:53'),
(4, 'خصم 10 ج للعاملين', 10, 'val', '2023-05-09 08:43:48', '2023-05-09 08:43:48');

-- --------------------------------------------------------

--
-- Table structure for table `employees`
--

DROP TABLE IF EXISTS `employees`;
CREATE TABLE IF NOT EXISTS `employees` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone_number` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `department_id` int NOT NULL,
  `user_id` int DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `expenses`
--

DROP TABLE IF EXISTS `expenses`;
CREATE TABLE IF NOT EXISTS `expenses` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expense_category_id` int NOT NULL,
  `warehouse_id` int NOT NULL,
  `account_id` int NOT NULL,
  `user_id` int NOT NULL,
  `cash_register_id` int DEFAULT NULL,
  `amount` double NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `expense_categories`
--

DROP TABLE IF EXISTS `expense_categories`;
CREATE TABLE IF NOT EXISTS `expense_categories` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `expense_categories`
--

INSERT INTO `expense_categories` (`id`, `code`, `name`, `is_active`, `created_at`, `updated_at`) VALUES
(1, '24076016', 'مصاريف نثريه', 0, '2022-01-05 11:37:23', '2022-01-05 11:39:01');

-- --------------------------------------------------------

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
CREATE TABLE IF NOT EXISTS `failed_jobs` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `floors`
--

DROP TABLE IF EXISTS `floors`;
CREATE TABLE IF NOT EXISTS `floors` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `floors`
--

INSERT INTO `floors` (`id`, `name`, `created_at`, `updated_at`) VALUES
(1, 'dev', '2022-12-07 14:07:05', '2022-12-07 14:07:05');

-- --------------------------------------------------------

--
-- Table structure for table `general_settings`
--

DROP TABLE IF EXISTS `general_settings`;
CREATE TABLE IF NOT EXISTS `general_settings` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `site_title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `site_logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_rtl` tinyint(1) DEFAULT NULL,
  `currency` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `staff_access` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_format` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `developed_by` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_format` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` int DEFAULT NULL,
  `theme` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `currency_position` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `general_settings`
--

INSERT INTO `general_settings` (`id`, `site_title`, `site_logo`, `is_rtl`, `currency`, `staff_access`, `date_format`, `developed_by`, `invoice_format`, `state`, `theme`, `created_at`, `updated_at`, `currency_position`) VALUES
(1, 'kids station', '20230530014320.png', 0, '1', 'own', 'd/m/Y', 'SKYPARK', 'standard', 1, 'default.css', '2018-07-06 06:13:11', '2023-05-30 10:43:20', 'prefix');

-- --------------------------------------------------------

--
-- Table structure for table `gift_cards`
--

DROP TABLE IF EXISTS `gift_cards`;
CREATE TABLE IF NOT EXISTS `gift_cards` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `card_no` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double NOT NULL,
  `expense` double NOT NULL,
  `customer_id` int DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `expired_date` date DEFAULT NULL,
  `created_by` int NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gift_card_recharges`
--

DROP TABLE IF EXISTS `gift_card_recharges`;
CREATE TABLE IF NOT EXISTS `gift_card_recharges` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `gift_card_id` int NOT NULL,
  `amount` double NOT NULL,
  `user_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `holidays`
--

DROP TABLE IF EXISTS `holidays`;
CREATE TABLE IF NOT EXISTS `holidays` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `from_date` date NOT NULL,
  `to_date` date NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `is_approved` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hrm_settings`
--

DROP TABLE IF EXISTS `hrm_settings`;
CREATE TABLE IF NOT EXISTS `hrm_settings` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `checkin` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `checkout` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `hrm_settings`
--

INSERT INTO `hrm_settings` (`id`, `checkin`, `checkout`, `created_at`, `updated_at`) VALUES
(1, '9:00am', '11:45pm', '2019-01-02 02:20:08', '2022-08-07 16:49:01');

-- --------------------------------------------------------

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
CREATE TABLE IF NOT EXISTS `languages` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `languages`
--

INSERT INTO `languages` (`id`, `code`, `created_at`, `updated_at`) VALUES
(1, 'en', '2018-07-07 22:59:17', '2019-12-24 17:34:20');

-- --------------------------------------------------------

--
-- Table structure for table `make_products`
--

DROP TABLE IF EXISTS `make_products`;
CREATE TABLE IF NOT EXISTS `make_products` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `product_id` bigint UNSIGNED NOT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `is_active` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `make_products`
--

INSERT INTO `make_products` (`id`, `product_id`, `notes`, `is_active`, `created_at`, `updated_at`) VALUES
(11, 112, NULL, '1', '2023-05-04 11:07:19', '2023-05-10 09:14:58'),
(12, 109, NULL, 'no', '2023-05-30 08:24:54', '2023-05-30 08:29:48'),
(13, 117, NULL, '1', '2023-05-30 08:32:28', '2023-05-30 10:31:21');

-- --------------------------------------------------------

--
-- Table structure for table `make_product_units`
--

DROP TABLE IF EXISTS `make_product_units`;
CREATE TABLE IF NOT EXISTS `make_product_units` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `unit_id` bigint UNSIGNED DEFAULT '0',
  `product_unit_id` bigint UNSIGNED NOT NULL,
  `product_id` bigint UNSIGNED NOT NULL,
  `amount` double DEFAULT '0',
  `notes` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=232 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `make_product_units`
--

INSERT INTO `make_product_units` (`id`, `unit_id`, `product_unit_id`, `product_id`, `amount`, `notes`, `created_at`, `updated_at`) VALUES
(5, 4, 2, 76, 1, NULL, '2023-03-14 13:52:58', '2023-03-14 13:52:58'),
(6, 4, 2, 77, 1, NULL, '2023-03-14 13:52:58', '2023-03-14 13:52:58'),
(7, 6, 3, 81, 1, NULL, '2023-03-14 13:59:24', '2023-03-14 13:59:24'),
(8, 4, 3, 80, 1, NULL, '2023-03-14 13:59:24', '2023-03-14 13:59:24'),
(9, 3, 4, 107, 2, NULL, '2023-04-09 10:05:40', '2023-04-09 10:05:40'),
(10, 3, 4, 108, 1, NULL, '2023-04-09 10:05:40', '2023-04-09 10:05:40'),
(17, 4, 6, 114, 1, NULL, '2023-04-09 11:42:54', '2023-04-09 11:42:54'),
(18, 4, 6, 113, 0.5, NULL, '2023-04-09 11:42:54', '2023-04-09 11:42:54'),
(170, 4, 7, 116, 1, NULL, '2023-05-02 11:41:50', '2023-05-02 11:41:50'),
(171, 3, 7, 115, 0.5, NULL, '2023-05-02 11:41:50', '2023-05-02 11:41:50'),
(182, 4, 5, 108, 0.25, NULL, '2023-05-02 11:47:23', '2023-05-02 11:47:23'),
(183, 3, 5, 110, 1, NULL, '2023-05-02 11:47:23', '2023-05-02 11:47:23'),
(184, 1, 10, 116, 11, '111', '2023-05-04 11:00:42', '2023-05-04 11:00:42'),
(186, 0, 9, 115, 221, NULL, '2023-05-04 11:06:44', '2023-05-04 11:06:44'),
(224, 4, 11, 115, 0.5, NULL, '2023-05-10 09:14:58', '2023-05-10 09:14:58'),
(225, 4, 11, 116, 0.25, NULL, '2023-05-10 09:14:58', '2023-05-10 09:14:58'),
(226, 6, 12, 27, 1, NULL, '2023-05-30 08:24:54', '2023-05-30 08:24:54'),
(227, 6, 12, 105, 1, NULL, '2023-05-30 08:24:54', '2023-05-30 08:24:54'),
(230, 6, 13, 115, 1, NULL, '2023-05-30 10:31:21', '2023-05-30 10:31:21'),
(231, 6, 13, 116, 1, NULL, '2023-05-30 10:31:21', '2023-05-30 10:31:21');

-- --------------------------------------------------------

--
-- Table structure for table `manufacturing_orders`
--

DROP TABLE IF EXISTS `manufacturing_orders`;
CREATE TABLE IF NOT EXISTS `manufacturing_orders` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `make_product_id` bigint UNSIGNED DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `warehouse_id` bigint UNSIGNED DEFAULT NULL,
  `is_active` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT '1',
  `is_end` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `manufacturing_orders`
--

INSERT INTO `manufacturing_orders` (`id`, `make_product_id`, `amount`, `notes`, `warehouse_id`, `is_active`, `is_end`, `created_at`, `updated_at`) VALUES
(2, 2, 10, NULL, 3, '1', '0', '2023-03-14 10:22:21', '2023-03-14 10:22:21'),
(3, 3, 3, NULL, 3, '1', '1', '2023-03-19 14:02:44', '2023-03-19 14:02:44'),
(4, 6, 1, NULL, 3, '1', '1', '2023-04-09 11:44:01', '2023-04-09 11:44:01'),
(5, 6, 5, NULL, 3, '1', '1', '2023-04-09 11:50:17', '2023-04-09 11:50:17'),
(6, 5, 3, NULL, 3, '1', '1', '2023-04-10 12:19:45', '2023-04-10 12:19:46'),
(7, 7, 2, NULL, 3, '1', '1', '2023-05-02 07:15:44', '2023-05-02 07:15:44'),
(8, 11, 1, NULL, 3, '1', '1', '2023-05-04 11:34:39', '2023-05-04 11:34:39'),
(9, 11, 1, NULL, 3, '1', '1', '2023-05-04 11:35:08', '2023-05-04 11:35:08'),
(14, 11, 1, NULL, 3, '1', '1', '2023-05-04 11:44:09', '2023-05-04 11:44:09'),
(16, 11, 1, NULL, 3, '1', '1', '2023-05-04 11:51:30', '2023-05-04 11:51:30'),
(52, 11, 3, NULL, 3, '1', '1', '2023-05-07 08:24:32', '2023-05-07 08:24:32'),
(53, 11, 3, NULL, 3, '1', '1', '2023-05-07 08:26:32', '2023-05-07 08:26:32'),
(56, 11, 1, NULL, 3, '1', '1', '2023-05-10 07:52:57', '2023-05-10 07:52:57'),
(57, 11, 1, NULL, 3, '1', '1', '2023-05-10 07:53:43', '2023-05-10 07:53:43'),
(58, 11, 2, NULL, 3, '1', '1', '2023-05-29 07:08:33', '2023-05-29 07:08:33'),
(59, 11, 1, NULL, 3, '1', '1', '2023-05-29 08:19:57', '2023-05-29 08:19:57'),
(60, 11, 1, NULL, 3, '1', '1', '2023-05-29 08:34:15', '2023-05-29 08:34:15'),
(61, 13, 2, NULL, 3, '1', '1', '2023-05-30 08:38:49', '2023-05-30 08:38:49'),
(62, 13, 1, NULL, 3, '1', '1', '2023-05-30 10:32:40', '2023-05-30 10:32:41'),
(63, 13, 1, NULL, 3, '1', '1', '2023-05-31 08:05:43', '2023-05-31 08:05:44');

-- --------------------------------------------------------

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
CREATE TABLE IF NOT EXISTS `migrations` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=147 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `migrations`
--

INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
(1, '2014_10_12_000000_create_users_table', 1),
(2, '2014_10_12_100000_create_password_resets_table', 1),
(3, '2018_02_17_060412_create_categories_table', 1),
(4, '2018_02_20_035727_create_brands_table', 1),
(5, '2018_02_25_100635_create_suppliers_table', 1),
(6, '2018_02_27_101619_create_warehouse_table', 1),
(7, '2018_03_03_040448_create_units_table', 1),
(8, '2018_03_04_041317_create_taxes_table', 1),
(9, '2018_03_10_061915_create_customer_groups_table', 1),
(10, '2018_03_10_090534_create_customers_table', 1),
(11, '2018_03_11_095547_create_billers_table', 1),
(12, '2018_04_05_054401_create_products_table', 1),
(13, '2018_04_06_133606_create_purchases_table', 1),
(14, '2018_04_06_154600_create_product_purchases_table', 1),
(15, '2018_04_06_154915_create_product_warhouse_table', 1),
(16, '2018_04_10_085927_create_sales_table', 1),
(17, '2018_04_10_090133_create_product_sales_table', 1),
(18, '2018_04_10_090254_create_payments_table', 1),
(19, '2018_04_10_090341_create_payment_with_cheque_table', 1),
(20, '2018_04_10_090509_create_payment_with_credit_card_table', 1),
(21, '2018_04_13_121436_create_quotation_table', 1),
(22, '2018_04_13_122324_create_product_quotation_table', 1),
(23, '2018_04_14_121802_create_transfers_table', 1),
(24, '2018_04_14_121913_create_product_transfer_table', 1),
(25, '2018_05_13_082847_add_payment_id_and_change_sale_id_to_payments_table', 2),
(26, '2018_05_13_090906_change_customer_id_to_payment_with_credit_card_table', 3),
(27, '2018_05_20_054532_create_adjustments_table', 4),
(28, '2018_05_20_054859_create_product_adjustments_table', 4),
(29, '2018_05_21_163419_create_returns_table', 5),
(30, '2018_05_21_163443_create_product_returns_table', 5),
(31, '2018_06_02_050905_create_roles_table', 6),
(32, '2018_06_02_073430_add_columns_to_users_table', 7),
(33, '2018_06_03_053738_create_permission_tables', 8),
(36, '2018_06_21_063736_create_pos_setting_table', 9),
(37, '2018_06_21_094155_add_user_id_to_sales_table', 10),
(38, '2018_06_21_101529_add_user_id_to_purchases_table', 11),
(39, '2018_06_21_103512_add_user_id_to_transfers_table', 12),
(40, '2018_06_23_061058_add_user_id_to_quotations_table', 13),
(41, '2018_06_23_082427_add_is_deleted_to_users_table', 14),
(42, '2018_06_25_043308_change_email_to_users_table', 15),
(43, '2018_07_06_115449_create_general_settings_table', 16),
(44, '2018_07_08_043944_create_languages_table', 17),
(45, '2018_07_11_102144_add_user_id_to_returns_table', 18),
(46, '2018_07_11_102334_add_user_id_to_payments_table', 18),
(47, '2018_07_22_130541_add_digital_to_products_table', 19),
(49, '2018_07_24_154250_create_deliveries_table', 20),
(50, '2018_08_16_053336_create_expense_categories_table', 21),
(51, '2018_08_17_115415_create_expenses_table', 22),
(55, '2018_08_18_050418_create_gift_cards_table', 23),
(56, '2018_08_19_063119_create_payment_with_gift_card_table', 24),
(57, '2018_08_25_042333_create_gift_card_recharges_table', 25),
(58, '2018_08_25_101354_add_deposit_expense_to_customers_table', 26),
(59, '2018_08_26_043801_create_deposits_table', 27),
(60, '2018_09_02_044042_add_keybord_active_to_pos_setting_table', 28),
(61, '2018_09_09_092713_create_payment_with_paypal_table', 29),
(62, '2018_09_10_051254_add_currency_to_general_settings_table', 30),
(63, '2018_10_22_084118_add_biller_and_store_id_to_users_table', 31),
(65, '2018_10_26_034927_create_coupons_table', 32),
(66, '2018_10_27_090857_add_coupon_to_sales_table', 33),
(67, '2018_11_07_070155_add_currency_position_to_general_settings_table', 34),
(68, '2018_11_19_094650_add_combo_to_products_table', 35),
(69, '2018_12_09_043712_create_accounts_table', 36),
(70, '2018_12_17_112253_add_is_default_to_accounts_table', 37),
(71, '2018_12_19_103941_add_account_id_to_payments_table', 38),
(72, '2018_12_20_065900_add_account_id_to_expenses_table', 39),
(73, '2018_12_20_082753_add_account_id_to_returns_table', 40),
(74, '2018_12_26_064330_create_return_purchases_table', 41),
(75, '2018_12_26_144210_create_purchase_product_return_table', 42),
(76, '2018_12_26_144708_create_purchase_product_return_table', 43),
(77, '2018_12_27_110018_create_departments_table', 44),
(78, '2018_12_30_054844_create_employees_table', 45),
(79, '2018_12_31_125210_create_payrolls_table', 46),
(80, '2018_12_31_150446_add_department_id_to_employees_table', 47),
(81, '2019_01_01_062708_add_user_id_to_expenses_table', 48),
(82, '2019_01_02_075644_create_hrm_settings_table', 49),
(83, '2019_01_02_090334_create_attendances_table', 50),
(84, '2019_01_27_160956_add_three_columns_to_general_settings_table', 51),
(85, '2019_02_15_183303_create_stock_counts_table', 52),
(86, '2019_02_17_101604_add_is_adjusted_to_stock_counts_table', 53),
(87, '2019_04_13_101707_add_tax_no_to_customers_table', 54),
(89, '2019_10_14_111455_create_holidays_table', 55),
(90, '2019_11_13_145619_add_is_variant_to_products_table', 56),
(91, '2019_11_13_150206_create_product_variants_table', 57),
(92, '2019_11_13_153828_create_variants_table', 57),
(93, '2019_11_25_134041_add_qty_to_product_variants_table', 58),
(94, '2019_11_25_134922_add_variant_id_to_product_purchases_table', 58),
(95, '2019_11_25_145341_add_variant_id_to_product_warehouse_table', 58),
(96, '2019_11_29_182201_add_variant_id_to_product_sales_table', 59),
(97, '2019_12_04_121311_add_variant_id_to_product_quotation_table', 60),
(98, '2019_12_05_123802_add_variant_id_to_product_transfer_table', 61),
(100, '2019_12_08_114954_add_variant_id_to_product_returns_table', 62),
(101, '2019_12_08_203146_add_variant_id_to_purchase_product_return_table', 63),
(102, '2020_02_28_103340_create_money_transfers_table', 64),
(103, '2020_07_01_193151_add_image_to_categories_table', 65),
(105, '2020_09_26_130426_add_user_id_to_deliveries_table', 66),
(107, '2020_10_11_125457_create_cash_registers_table', 67),
(108, '2020_10_13_155019_add_cash_register_id_to_sales_table', 68),
(109, '2020_10_13_172624_add_cash_register_id_to_returns_table', 69),
(110, '2020_10_17_212338_add_cash_register_id_to_payments_table', 70),
(111, '2020_10_18_124200_add_cash_register_id_to_expenses_table', 71),
(112, '2020_10_21_121632_add_developed_by_to_general_settings_table', 72),
(113, '2019_08_19_000000_create_failed_jobs_table', 73),
(114, '2020_10_30_135557_create_notifications_table', 73),
(115, '2020_11_01_044954_create_currencies_table', 74),
(116, '2020_11_01_140736_add_price_to_product_warehouse_table', 75),
(117, '2020_11_02_050633_add_is_diff_price_to_products_table', 76),
(118, '2020_11_09_055222_add_user_id_to_customers_table', 77),
(119, '2020_11_17_054806_add_invoice_format_to_general_settings_table', 78),
(120, '2021_02_10_074859_add_variant_id_to_product_adjustments_table', 79),
(121, '2021_03_07_093606_create_product_batches_table', 80),
(122, '2021_03_07_093759_add_product_batch_id_to_product_warehouse_table', 80),
(123, '2021_03_07_093900_add_product_batch_id_to_product_purchases_table', 80),
(124, '2021_03_11_132603_add_product_batch_id_to_product_sales_table', 81),
(127, '2021_03_25_125421_add_is_batch_to_products_table', 82),
(128, '2021_05_19_120127_add_product_batch_id_to_product_returns_table', 82),
(130, '2021_05_22_105611_add_product_batch_id_to_purchase_product_return_table', 83),
(131, '2021_05_23_124848_add_product_batch_id_to_product_transfer_table', 84),
(132, '2021_05_26_153106_add_product_batch_id_to_product_quotation_table', 85),
(133, '2021_06_08_213007_create_reward_point_settings_table', 86),
(134, '2021_06_16_104155_add_points_to_customers_table', 87),
(135, '2021_06_17_101057_add_used_points_to_payments_table', 88),
(136, '2021_07_06_132716_add_variant_list_to_products_table', 89),
(137, '2021_09_27_161141_add_is_imei_to_products_table', 90),
(138, '2021_09_28_170052_add_imei_number_to_product_warehouse_table', 91),
(139, '2021_09_28_170126_add_imei_number_to_product_purchases_table', 91),
(140, '2021_10_03_170652_add_imei_number_to_product_sales_table', 92),
(141, '2021_10_10_145214_add_imei_number_to_product_returns_table', 93),
(142, '2021_10_11_104504_add_imei_number_to_product_transfer_table', 94),
(143, '2021_10_12_160107_add_imei_number_to_purchase_product_return_table', 95),
(144, '2021_10_12_205146_add_is_rtl_to_general_settings_table', 96),
(145, '2021_10_23_142451_add_is_approve_to_payments_table', 97),
(146, '2023_05_09_084509_create_discounts_table', 98);

-- --------------------------------------------------------

--
-- Table structure for table `money_transfers`
--

DROP TABLE IF EXISTS `money_transfers`;
CREATE TABLE IF NOT EXISTS `money_transfers` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `from_account_id` int NOT NULL,
  `to_account_id` int NOT NULL,
  `amount` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `notifications`
--

DROP TABLE IF EXISTS `notifications`;
CREATE TABLE IF NOT EXISTS `notifications` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_id` bigint UNSIGNED NOT NULL,
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `notifications`
--

INSERT INTO `notifications` (`id`, `type`, `notifiable_type`, `notifiable_id`, `data`, `read_at`, `created_at`, `updated_at`) VALUES
('180ce6d6-a0ee-435b-8b13-3cfd15674466', 'App\\Notifications\\SendNotification', 'App\\User', 27, '{\"message\":\"Test\"}', NULL, '2022-12-11 20:55:38', '2022-12-11 20:55:38'),
('5ced1c15-fcf4-4d66-816b-5cbbba0062c8', 'App\\Notifications\\SendNotification', 'App\\User', 30, '{\"message\":\"test\"}', '2023-01-20 13:41:27', '2022-12-11 20:57:11', '2023-01-20 13:41:27');

-- --------------------------------------------------------

--
-- Table structure for table `password_resets`
--

DROP TABLE IF EXISTS `password_resets`;
CREATE TABLE IF NOT EXISTS `password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
CREATE TABLE IF NOT EXISTS `payments` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `payment_reference` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int NOT NULL,
  `purchase_id` int DEFAULT NULL,
  `sale_id` int DEFAULT NULL,
  `cash_register_id` int DEFAULT NULL,
  `account_id` int NOT NULL,
  `amount` double NOT NULL,
  `used_points` double DEFAULT NULL,
  `change` double NOT NULL,
  `paying_method` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payment_note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=498 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `payments`
--

INSERT INTO `payments` (`id`, `payment_reference`, `user_id`, `purchase_id`, `sale_id`, `cash_register_id`, `account_id`, `amount`, `used_points`, `change`, `paying_method`, `payment_note`, `created_at`, `updated_at`) VALUES
(30, 'ppr-20220916-113848', 1, 11, NULL, NULL, 1, 5570.08, NULL, 0, 'Cash', NULL, '2022-09-16 11:38:48', '2022-09-16 11:38:48'),
(31, 'spr-20220917-045351', 30, NULL, 2, 9, 1, 210, NULL, 0, 'Cash', NULL, '2022-09-17 16:53:51', '2022-09-17 16:53:51'),
(32, 'spr-20220917-045726', 30, NULL, 3, 9, 1, 225, NULL, 0, 'Cash', NULL, '2022-09-17 16:57:26', '2022-09-17 16:57:26'),
(33, 'spr-20220917-105456', 30, NULL, 4, 9, 1, 230, NULL, 0, 'Cash', NULL, '2022-09-17 22:54:56', '2022-09-17 22:54:56'),
(34, 'spr-20220917-105500', 30, NULL, 5, 9, 1, 230, NULL, 0, 'Cash', NULL, '2022-09-17 22:55:00', '2022-09-17 22:55:00'),
(35, 'spr-20220919-035702', 30, NULL, 6, NULL, 1, 350, NULL, 0, 'Cash', NULL, '2022-09-19 15:57:02', '2022-09-19 15:57:02'),
(36, 'spr-20220920-041948', 30, NULL, 7, NULL, 1, 133, NULL, 0, 'Credit Card', NULL, '2022-09-20 16:19:48', '2022-09-20 16:19:48'),
(37, 'spr-20220920-041953', 30, NULL, 8, NULL, 1, 133, NULL, 0, 'Cash', NULL, '2022-09-20 16:19:53', '2022-09-20 16:19:53'),
(38, 'spr-20220920-042245', 30, NULL, 9, NULL, 1, 790, NULL, 0, 'Cash', NULL, '2022-09-20 16:22:45', '2022-09-20 16:22:45'),
(39, 'ppr-20220921-121807', 1, 12, NULL, NULL, 1, 413.25, NULL, 0, 'Cash', NULL, '2022-09-21 12:18:07', '2022-09-21 12:18:07'),
(40, 'spr-20220921-034614', 30, NULL, 10, NULL, 1, 21, NULL, 0, 'Cash', NULL, '2022-09-21 15:46:14', '2022-09-21 15:46:14'),
(41, 'spr-20220921-034615', 30, NULL, 11, NULL, 1, 21, NULL, 0, 'Cash', NULL, '2022-09-21 15:46:15', '2022-09-21 15:46:15'),
(42, 'spr-20220921-105323', 30, NULL, 12, NULL, 1, 55, NULL, 0, 'Cash', NULL, '2022-09-21 22:53:23', '2022-09-21 22:53:23'),
(43, 'spr-20220921-105347', 30, NULL, 13, NULL, 1, 3, NULL, 0, 'Cash', NULL, '2022-09-21 22:53:47', '2022-09-21 22:53:47'),
(44, 'spr-20220922-111800', 30, NULL, 14, 10, 1, 170, NULL, 0, 'Cash', NULL, '2022-09-22 23:18:00', '2022-09-22 23:18:00'),
(45, 'spr-20220923-063944', 30, NULL, 15, 10, 1, 12, NULL, 0, 'Cash', NULL, '2022-09-23 18:39:44', '2022-09-23 18:39:44'),
(46, 'spr-20220923-072221', 30, NULL, 16, 10, 1, 200, NULL, 0, 'Cash', NULL, '2022-09-23 19:22:21', '2022-09-23 19:22:21'),
(47, 'spr-20220923-103236', 30, NULL, 17, 10, 1, 370, NULL, 0, 'Cash', NULL, '2022-09-23 22:32:36', '2022-09-23 22:32:36'),
(48, 'spr-20220923-103327', 30, NULL, 18, 10, 1, 3, NULL, 0, 'Cash', NULL, '2022-09-23 22:33:27', '2022-09-23 22:33:27'),
(49, 'ppr-20220924-104913', 1, 13, NULL, NULL, 1, 158.72, NULL, 0, 'Cash', NULL, '2022-09-24 22:49:13', '2022-09-24 22:49:13'),
(50, 'spr-20220924-105243', 30, NULL, 19, 11, 1, 730, NULL, 0, 'Cash', NULL, '2022-09-24 22:52:43', '2022-09-24 22:52:43'),
(51, 'spr-20220924-105245', 30, NULL, 20, 11, 1, 730, NULL, 0, 'Cash', NULL, '2022-09-24 22:52:45', '2022-09-24 22:52:45'),
(52, 'ppr-20220924-105657', 1, 14, NULL, NULL, 1, 96, NULL, 0, 'Cash', NULL, '2022-09-24 22:56:57', '2022-09-24 22:56:57'),
(53, 'spr-20220925-034920', 30, NULL, 21, 11, 1, 15, NULL, 0, 'Cash', NULL, '2022-09-25 15:49:20', '2022-09-25 15:49:20'),
(54, 'ppr-20220927-103040', 1, 15, NULL, NULL, 1, 3020, NULL, 0, 'Cash', NULL, '2022-09-27 10:30:40', '2022-09-27 10:30:40'),
(55, 'spr-20220927-030452', 30, NULL, 22, 11, 1, 40, NULL, 0, 'Cash', NULL, '2022-09-27 15:04:52', '2022-09-27 15:04:52'),
(56, 'spr-20220927-030532', 30, NULL, 23, 11, 1, 20, NULL, 0, 'Cash', NULL, '2022-09-27 15:05:32', '2022-09-27 15:05:32'),
(57, 'ppr-20220928-051150', 29, 16, NULL, NULL, 1, 798, NULL, 0, 'Cash', NULL, '2022-09-28 17:11:50', '2022-09-28 17:11:50'),
(58, 'ppr-20220928-051420', 29, 17, NULL, NULL, 1, 456.75, NULL, 0, 'Cash', NULL, '2022-09-28 17:14:20', '2022-09-28 17:14:20'),
(59, 'ppr-20220928-051538', 29, 18, NULL, NULL, 1, 283.72, NULL, 0, 'Cash', NULL, '2022-09-28 17:15:38', '2022-09-28 17:15:38'),
(60, 'ppr-20220928-051644', 29, 19, NULL, NULL, 1, 1383.84, NULL, 0, 'Cash', NULL, '2022-09-28 17:16:44', '2022-09-28 17:16:44'),
(61, 'spr-20220928-052428', 30, NULL, 25, 11, 1, 35, NULL, 0, 'Cash', NULL, '2022-09-28 17:24:28', '2022-09-28 17:24:28'),
(62, 'spr-20220928-052428', 30, NULL, 24, 11, 1, 35, NULL, 0, 'Cash', NULL, '2022-09-28 17:24:28', '2022-09-28 17:24:28'),
(63, 'spr-20220928-052428', 30, NULL, 27, 11, 1, 35, NULL, 0, 'Cash', NULL, '2022-09-28 17:24:28', '2022-09-28 17:24:28'),
(64, 'spr-20220928-110645', 30, NULL, 28, 11, 1, 13, NULL, 0, 'Cash', NULL, '2022-09-28 23:06:45', '2022-09-28 23:06:45'),
(65, 'spr-20220929-112759', 30, NULL, 29, 11, 1, 1905, NULL, 0, 'Cash', '1905', '2022-09-29 23:27:59', '2022-09-29 23:27:59'),
(66, 'spr-20220929-112830', 30, NULL, 30, 11, 1, 50, NULL, 0, 'Credit Card', '50', '2022-09-29 23:28:30', '2022-09-29 23:28:30'),
(67, 'spr-20220929-112840', 30, NULL, 31, 11, 1, 50, NULL, 0, 'Credit Card', '50', '2022-09-29 23:28:40', '2022-09-29 23:28:40'),
(68, 'spr-20220929-113043', 30, NULL, 32, 11, 1, 50, NULL, 0, 'Cash', '50', '2022-09-29 23:30:43', '2022-09-29 23:30:43'),
(69, 'spr-20220929-113332', 30, NULL, 33, 11, 1, 44, NULL, 0, 'Cash', '44', '2022-09-29 23:33:32', '2022-09-29 23:33:32'),
(70, 'spr-20220930-113552', 30, NULL, 34, 11, 1, 2080, NULL, 0, 'Cash', '2080', '2022-09-30 23:35:52', '2022-09-30 23:35:52'),
(71, 'spr-20220930-113912', 30, NULL, 35, 11, 1, 53, NULL, 0, 'Cash', NULL, '2022-09-30 23:39:12', '2022-09-30 23:39:12'),
(72, 'spr-20221001-103553', 30, NULL, 36, 11, 1, 25, NULL, 0, 'Cash', '25', '2022-10-01 22:35:53', '2022-10-01 22:35:53'),
(73, 'spr-20221001-103649', 30, NULL, 37, 11, 1, 18, NULL, 0, 'Cash', '18', '2022-10-01 22:36:49', '2022-10-01 22:36:49'),
(74, 'spr-20221001-103713', 30, NULL, 38, 11, 1, 30, NULL, 0, 'Cash', '30', '2022-10-01 22:37:13', '2022-10-01 22:37:13'),
(75, 'spr-20221001-104005', 30, NULL, 39, 11, 1, 305, NULL, 0, 'Cash', '305', '2022-10-01 22:40:05', '2022-10-01 22:40:05'),
(76, 'spr-20221001-104538', 30, NULL, 40, 11, 1, 20, NULL, 0, 'Cash', '20', '2022-10-01 22:45:38', '2022-10-01 22:45:38'),
(77, 'spr-20221002-101037', 30, NULL, 41, 11, 1, 1020, NULL, 0, 'Cash', NULL, '2022-10-02 22:10:37', '2022-10-02 22:10:37'),
(78, 'spr-20221002-101110', 30, NULL, 42, 11, 1, 6, NULL, 0, 'Cash', '6', '2022-10-02 22:11:10', '2022-10-02 22:11:10'),
(79, 'spr-20221004-053938', 30, NULL, 43, 11, 1, 40, NULL, 0, 'Cash', '40', '2022-10-04 17:39:38', '2022-10-04 17:39:38'),
(80, 'spr-20221004-054315', 30, NULL, 44, 11, 1, 152, NULL, 0, 'Cash', '152', '2022-10-04 17:43:15', '2022-10-04 17:43:15'),
(81, 'spr-20221004-110517', 30, NULL, 45, 11, 1, 89, NULL, 0, 'Cash', '89', '2022-10-04 23:05:17', '2022-10-04 23:05:17'),
(82, 'spr-20221005-105715', 30, NULL, 46, 11, 1, 180, NULL, 0, 'Cash', NULL, '2022-10-05 22:57:15', '2022-10-05 22:57:15'),
(83, 'spr-20221005-105758', 30, NULL, 47, 11, 1, 11, NULL, 0, 'Cash', NULL, '2022-10-05 22:57:58', '2022-10-05 22:57:58'),
(84, 'spr-20221007-030106', 30, NULL, 48, 11, 1, 376, NULL, 0, 'Cash', NULL, '2022-10-07 15:01:06', '2022-10-07 15:01:06'),
(85, 'spr-20221007-030135', 30, NULL, 49, 11, 1, 90, NULL, 0, 'Cash', NULL, '2022-10-07 15:01:35', '2022-10-07 15:01:35'),
(86, 'spr-20221007-104805', 30, NULL, 50, 11, 1, 615, NULL, 0, 'Cash', NULL, '2022-10-07 22:48:05', '2022-10-07 22:48:05'),
(87, 'spr-20221007-104907', 30, NULL, 51, 11, 1, 9, NULL, 0, 'Cash', NULL, '2022-10-07 22:49:07', '2022-10-07 22:49:07'),
(88, 'ppr-20221008-062358', 29, 20, NULL, NULL, 1, 27.1, NULL, 0, 'Cash', NULL, '2022-10-08 18:23:58', '2022-10-08 18:23:58'),
(89, 'spr-20221008-062523', 30, NULL, 52, 11, 1, 30, NULL, 0, 'Cash', NULL, '2022-10-08 18:25:23', '2022-10-08 18:25:23'),
(90, 'ppr-20221008-062649', 29, 21, NULL, NULL, 1, 108.4, NULL, 0, 'Cash', NULL, '2022-10-08 18:26:49', '2022-10-08 18:26:49'),
(91, 'spr-20221008-101508', 30, NULL, 53, 11, 1, 158, NULL, 0, 'Cash', NULL, '2022-10-08 22:15:08', '2022-10-08 22:15:08'),
(92, 'spr-20221008-101727', 30, NULL, 54, 11, 1, 145, NULL, 0, 'Cash', NULL, '2022-10-08 22:17:27', '2022-10-08 22:17:27'),
(93, 'spr-20221009-104023', 30, NULL, 55, 11, 1, 211, NULL, 0, 'Cash', NULL, '2022-10-09 22:40:23', '2022-10-09 22:40:23'),
(94, 'spr-20221010-104041', 30, NULL, 57, 11, 1, 33, NULL, 0, 'Cash', NULL, '2022-10-10 22:40:41', '2022-10-10 22:40:41'),
(95, 'spr-20221010-104041', 30, NULL, 58, 11, 1, 33, NULL, 0, 'Cash', NULL, '2022-10-10 22:40:41', '2022-10-10 22:40:41'),
(96, 'spr-20221010-104041', 30, NULL, 56, 11, 1, 33, NULL, 0, 'Cash', NULL, '2022-10-10 22:40:41', '2022-10-10 22:40:41'),
(97, 'spr-20221011-104641', 30, NULL, 59, 11, 1, 535, NULL, 0, 'Cash', NULL, '2022-10-11 22:46:41', '2022-10-11 22:46:41'),
(98, 'ppr-20221011-104912', 29, 22, NULL, NULL, 1, 11.89, NULL, 0, 'Cash', NULL, '2022-10-11 22:49:12', '2022-10-11 22:49:12'),
(99, 'spr-20221011-104932', 30, NULL, 60, 11, 1, 30, NULL, 0, 'Cash', NULL, '2022-10-11 22:49:32', '2022-10-11 22:49:32'),
(100, 'spr-20221012-100544', 30, NULL, 61, 11, 1, 3, NULL, 0, 'Cash', '3', '2022-10-12 22:05:44', '2022-10-12 22:05:44'),
(101, 'spr-20221012-100546', 30, NULL, 62, 11, 1, 3, NULL, 0, 'Cash', '3', '2022-10-12 22:05:46', '2022-10-12 22:05:46'),
(102, 'spr-20221012-100623', 30, NULL, 63, 11, 1, 35, NULL, 0, 'Cash', '35', '2022-10-12 22:06:23', '2022-10-12 22:06:23'),
(103, 'spr-20221013-110755', 30, NULL, 64, 11, 1, 180, NULL, 0, 'Cash', '180', '2022-10-13 23:07:55', '2022-10-13 23:07:55'),
(104, 'spr-20221013-110911', 30, NULL, 65, 11, 1, 29, NULL, 0, 'Cash', '29', '2022-10-13 23:09:11', '2022-10-13 23:09:11'),
(105, 'ppr-20221014-111249', 29, 23, NULL, NULL, 1, 191, NULL, 0, 'Cash', NULL, '2022-10-14 23:12:49', '2022-10-14 23:12:49'),
(106, 'ppr-20221014-111338', 29, 24, NULL, NULL, 1, 355.74, NULL, 0, 'Cash', NULL, '2022-10-14 23:13:38', '2022-10-14 23:13:38'),
(107, 'ppr-20221014-111447', 29, 25, NULL, NULL, 1, 228, NULL, 0, 'Cash', NULL, '2022-10-14 23:14:47', '2022-10-14 23:14:47'),
(108, 'spr-20221014-111530', 30, NULL, 66, 11, 1, 110, NULL, 0, 'Cash', NULL, '2022-10-14 23:15:30', '2022-10-14 23:15:30'),
(109, 'spr-20221014-111721', 30, NULL, 67, 11, 1, 33, NULL, 0, 'Cash', NULL, '2022-10-14 23:17:21', '2022-10-14 23:17:21'),
(110, 'spr-20221014-111826', 30, NULL, 68, 11, 1, 880, NULL, 0, 'Cash', NULL, '2022-10-14 23:18:26', '2022-10-14 23:18:26'),
(111, 'spr-20221015-105553', 30, NULL, 69, 11, 1, 350, NULL, 0, 'Cash', NULL, '2022-10-15 22:55:53', '2022-10-15 22:55:53'),
(112, 'spr-20221015-105724', 30, NULL, 70, 11, 1, 1320, NULL, 0, 'Cash', NULL, '2022-10-15 22:57:24', '2022-10-15 22:57:24'),
(113, 'spr-20221015-105858', 30, NULL, 71, 11, 1, 22, NULL, 0, 'Cash', NULL, '2022-10-15 22:58:58', '2022-10-15 22:58:58'),
(114, 'spr-20221016-102305', 30, NULL, 72, 11, 1, 78, NULL, 0, 'Cash', NULL, '2022-10-16 22:23:05', '2022-10-16 22:23:05'),
(115, 'spr-20221017-102727', 30, NULL, 73, 11, 1, 24, NULL, 0, 'Cash', NULL, '2022-10-17 22:27:27', '2022-10-17 22:27:27'),
(116, 'spr-20221018-104111', 30, NULL, 74, 11, 1, 37, NULL, 0, 'Cash', NULL, '2022-10-18 22:41:11', '2022-10-18 22:41:11'),
(117, 'spr-20221019-102850', 30, NULL, 75, 11, 1, 20, NULL, 0, 'Cash', '20', '2022-10-19 22:28:50', '2022-10-19 22:28:50'),
(118, 'spr-20221020-103551', 30, NULL, 76, 11, 1, 11, NULL, 0, 'Cash', '11', '2022-10-20 22:35:51', '2022-10-20 22:35:51'),
(119, 'spr-20221020-103657', 30, NULL, 77, 11, 1, 240, NULL, 0, 'Cash', '240', '2022-10-20 22:36:57', '2022-10-20 22:36:57'),
(120, 'spr-20221020-104000', 30, NULL, 78, 11, 1, 765, NULL, 0, 'Cash', '765', '2022-10-20 22:40:00', '2022-10-20 22:40:00'),
(121, 'spr-20221021-104254', 30, NULL, 79, 11, 1, 80, NULL, 0, 'Cash', NULL, '2022-10-21 22:42:54', '2022-10-21 22:42:54'),
(122, 'spr-20221021-104356', 30, NULL, 80, 11, 1, 20, NULL, 0, 'Cash', NULL, '2022-10-21 22:43:56', '2022-10-21 22:43:56'),
(123, 'spr-20221021-104444', 30, NULL, 81, 11, 1, 250, NULL, 0, 'Credit Card', NULL, '2022-10-21 22:44:44', '2022-10-21 22:44:44'),
(124, 'spr-20221022-103416', 30, NULL, 82, 11, 1, 250, NULL, 0, 'Cash', NULL, '2022-10-22 22:34:16', '2022-10-22 22:34:16'),
(125, 'spr-20221022-103437', 30, NULL, 83, 11, 1, 6, NULL, 0, 'Cash', NULL, '2022-10-22 22:34:37', '2022-10-22 22:34:37'),
(126, 'spr-20221022-103525', 30, NULL, 84, 11, 1, 550, NULL, 0, 'Cash', NULL, '2022-10-22 22:35:25', '2022-10-22 22:35:25'),
(127, 'spr-20221024-032324', 30, NULL, 85, 11, 1, 15, NULL, 0, 'Cash', NULL, '2022-10-24 15:23:24', '2022-10-24 15:23:24'),
(128, 'spr-20221024-103418', 30, NULL, 86, 11, 1, 46, NULL, 0, 'Cash', NULL, '2022-10-24 22:34:18', '2022-10-24 22:34:18'),
(129, 'spr-20221025-100035', 30, NULL, 87, 11, 1, 15, NULL, 0, 'Cash', NULL, '2022-10-25 22:00:35', '2022-10-25 22:00:35'),
(130, 'spr-20221026-102246', 30, NULL, 88, 11, 1, 325, NULL, 0, 'Cash', '325', '2022-10-26 22:22:46', '2022-10-26 22:22:46'),
(131, 'spr-20221026-102345', 30, NULL, 89, 11, 1, 14, NULL, 0, 'Cash', '14', '2022-10-26 22:23:45', '2022-10-26 22:23:45'),
(132, 'ppr-20221027-110412', 29, 26, NULL, NULL, 1, 505.8, NULL, 0, 'Cash', NULL, '2022-10-27 23:04:12', '2022-10-27 23:04:12'),
(133, 'ppr-20221027-110446', 29, 27, NULL, NULL, 1, 516, NULL, 0, 'Cash', NULL, '2022-10-27 23:04:46', '2022-10-27 23:04:46'),
(134, 'ppr-20221027-110529', 29, 28, NULL, NULL, 1, 360.45, NULL, 0, 'Cash', NULL, '2022-10-27 23:05:29', '2022-10-27 23:05:29'),
(135, 'ppr-20221027-110629', 29, 29, NULL, NULL, 1, 402, NULL, 0, 'Cash', NULL, '2022-10-27 23:06:29', '2022-10-27 23:06:29'),
(136, 'spr-20221027-111107', 30, NULL, 90, 11, 1, 575, NULL, 0, 'Cash', NULL, '2022-10-27 23:11:07', '2022-10-27 23:11:07'),
(137, 'spr-20221027-111133', 30, NULL, 91, 11, 1, 80, NULL, 0, 'Cash', NULL, '2022-10-27 23:11:33', '2022-10-27 23:11:33'),
(138, 'spr-20221027-111207', 30, NULL, 92, 11, 1, 18, NULL, 0, 'Cash', NULL, '2022-10-27 23:12:07', '2022-10-27 23:12:07'),
(139, 'spr-20221029-094212', 30, NULL, 93, 11, 1, 490, NULL, 0, 'Cash', NULL, '2022-10-29 21:42:12', '2022-10-29 21:42:12'),
(140, 'spr-20221029-094253', 30, NULL, 94, 11, 1, 70, NULL, 0, 'Cash', NULL, '2022-10-29 21:42:53', '2022-10-29 21:42:53'),
(141, 'spr-20221029-094357', 30, NULL, 95, 11, 1, 20, NULL, 0, 'Cash', NULL, '2022-10-29 21:43:57', '2022-10-29 21:43:57'),
(142, 'spr-20221029-094557', 30, NULL, 96, 11, 1, 120, NULL, 0, 'Cash', NULL, '2022-10-29 21:45:57', '2022-10-29 21:45:57'),
(143, 'spr-20221030-095852', 30, NULL, 97, 11, 1, 8, NULL, 0, 'Cash', NULL, '2022-10-30 21:58:52', '2022-10-30 21:58:52'),
(144, 'spr-20221030-100210', 30, NULL, 98, 11, 1, 913, NULL, 0, 'Cash', NULL, '2022-10-30 22:02:10', '2022-10-30 22:02:10'),
(145, 'spr-20221031-101914', 30, NULL, 99, 11, 1, 189, NULL, 0, 'Cash', NULL, '2022-10-31 22:19:14', '2022-10-31 22:19:14'),
(146, 'spr-20221031-102032', 30, NULL, 100, 11, 1, 1235, NULL, 0, 'Cash', NULL, '2022-10-31 22:20:32', '2022-10-31 22:20:32'),
(147, 'spr-20221031-102202', 30, NULL, 101, 11, 1, 69, NULL, 0, 'Cash', NULL, '2022-10-31 22:22:02', '2022-10-31 22:22:02'),
(148, 'spr-20221101-101943', 30, NULL, 102, 11, 1, 19, NULL, 0, 'Cash', NULL, '2022-11-01 22:19:43', '2022-11-01 22:19:43'),
(149, 'spr-20221101-102048', 30, NULL, 103, 11, 1, 270, NULL, 0, 'Cash', NULL, '2022-11-01 22:20:48', '2022-11-01 22:20:48'),
(150, 'spr-20221102-101829', 30, NULL, 104, 11, 1, 290, NULL, 0, 'Cash', '290', '2022-11-02 22:18:29', '2022-11-02 22:18:29'),
(151, 'spr-20221102-101854', 30, NULL, 105, 11, 1, 8, NULL, 0, 'Cash', '8', '2022-11-02 22:18:54', '2022-11-02 22:18:54'),
(152, 'ppr-20221103-094532', 29, 30, NULL, NULL, 1, 158.2, NULL, 0, 'Cash', NULL, '2022-11-03 21:45:32', '2022-11-03 21:45:32'),
(153, 'ppr-20221103-094633', 29, 31, NULL, NULL, 1, 443.36, NULL, 0, 'Cash', NULL, '2022-11-03 21:46:33', '2022-11-03 21:46:33'),
(154, 'ppr-20221103-094736', 29, 32, NULL, NULL, 1, 126.36, NULL, 0, 'Cash', NULL, '2022-11-03 21:47:36', '2022-11-03 21:47:36'),
(155, 'spr-20221103-102845', 30, NULL, 106, 11, 1, 1681, NULL, 0, 'Cash', NULL, '2022-11-03 22:28:45', '2022-11-03 22:28:45'),
(156, 'spr-20221105-103028', 30, NULL, 107, 11, 1, 1010, NULL, 0, 'Cash', NULL, '2022-11-05 22:30:28', '2022-11-05 22:30:28'),
(157, 'spr-20221105-103126', 30, NULL, 108, 11, 1, 945, NULL, 0, 'Cash', NULL, '2022-11-05 22:31:26', '2022-11-05 22:31:26'),
(158, 'ppr-20221108-100234', 29, 33, NULL, NULL, 1, 1140, NULL, 0, 'Cash', NULL, '2022-11-08 10:02:34', '2022-11-08 10:02:34'),
(159, 'spr-20221108-100358', 30, NULL, 109, 11, 1, 10, NULL, 0, 'Cash', NULL, '2022-11-08 10:03:58', '2022-11-08 10:03:58'),
(160, 'spr-20221112-121256', 30, NULL, 110, 11, 1, 4655, NULL, 0, 'Cash', NULL, '2022-11-12 12:12:56', '2022-11-12 12:12:56'),
(161, 'spr-20221113-090441', 30, NULL, 111, 11, 1, 12, NULL, 0, 'Cash', NULL, '2022-11-13 21:04:41', '2022-11-13 21:04:41'),
(162, 'spr-20221115-063856', 30, NULL, 112, 11, 1, 2060, NULL, 0, 'Cash', NULL, '2022-11-15 18:38:56', '2022-11-15 18:38:56'),
(163, 'spr-20221116-081642', 30, NULL, 113, 11, 1, 30, NULL, 0, 'Cash', '30', '2022-11-16 20:16:42', '2022-11-16 20:16:42'),
(164, 'ppr-20221118-013124', 29, 34, NULL, NULL, 1, 396, NULL, 0, 'Cash', NULL, '2022-11-18 13:31:24', '2022-11-18 13:31:24'),
(165, 'ppr-20221118-013158', 29, 35, NULL, NULL, 1, 371.52, NULL, 0, 'Cash', NULL, '2022-11-18 13:31:58', '2022-11-18 13:31:58'),
(166, 'ppr-20221118-013231', 29, 36, NULL, NULL, 1, 442.8, NULL, 0, 'Cash', NULL, '2022-11-18 13:32:31', '2022-11-18 13:32:31'),
(167, 'ppr-20221118-013439', 29, 37, NULL, NULL, 1, 2272, NULL, 0, 'Cash', NULL, '2022-11-18 13:34:39', '2022-11-18 13:34:39'),
(168, 'spr-20221118-013655', 30, NULL, 114, 11, 1, 30, NULL, 0, 'Cash', NULL, '2022-11-18 13:36:55', '2022-11-18 13:36:55'),
(169, 'spr-20221118-014103', 30, NULL, 115, 11, 1, 2380, NULL, 0, 'Cash', NULL, '2022-11-18 13:41:03', '2022-11-18 13:41:03'),
(170, 'spr-20221118-014209', 30, NULL, 116, 11, 1, 31, NULL, 0, 'Cash', NULL, '2022-11-18 13:42:09', '2022-11-18 13:42:09'),
(171, 'spr-20221118-014358', 30, NULL, 117, 11, 1, 1360, NULL, 0, 'Cash', NULL, '2022-11-18 13:43:58', '2022-11-18 13:43:58'),
(172, 'spr-20221119-125951', 30, NULL, 118, 11, 1, 1540, NULL, 0, 'Cash', NULL, '2022-11-19 12:59:51', '2022-11-19 12:59:51'),
(173, 'spr-20221119-125951', 30, NULL, 121, 11, 1, 1540, NULL, 0, 'Cash', NULL, '2022-11-19 12:59:51', '2022-11-19 12:59:51'),
(174, 'spr-20221119-010217', 30, NULL, 122, 11, 1, 570, NULL, 0, 'Cash', NULL, '2022-11-19 13:02:17', '2022-11-19 13:02:17'),
(175, 'spr-20221119-010324', 30, NULL, 123, 11, 1, 205, NULL, 0, 'Cash', NULL, '2022-11-19 13:03:24', '2022-11-19 13:03:24'),
(176, 'spr-20221119-011032', 30, NULL, 124, 11, 1, 1125, NULL, 0, 'Cash', NULL, '2022-11-19 13:10:32', '2022-11-19 13:10:32'),
(177, 'spr-20221119-011518', 30, NULL, 125, 11, 1, 515, NULL, 0, 'Cash', NULL, '2022-11-19 13:15:18', '2022-11-19 13:15:18'),
(178, 'spr-20221119-011608', 30, NULL, 126, 11, 1, 25, NULL, 0, 'Cash', NULL, '2022-11-19 13:16:08', '2022-11-19 13:16:08'),
(179, 'ppr-20221119-013617', 29, 38, NULL, NULL, 1, 135.5, NULL, 0, 'Cash', NULL, '2022-11-19 13:36:17', '2022-11-19 13:36:17'),
(180, 'spr-20221119-013719', 30, NULL, 127, 11, 1, 420, NULL, 0, 'Cash', NULL, '2022-11-19 13:37:19', '2022-11-19 13:37:19'),
(181, 'ppr-20221119-013840', 29, 39, NULL, NULL, 1, 71.34, NULL, 0, 'Cash', NULL, '2022-11-19 13:38:40', '2022-11-19 13:38:40'),
(182, 'spr-20221119-014509', 30, NULL, 128, 11, 1, 180, NULL, 0, 'Cash', NULL, '2022-11-19 13:45:09', '2022-11-19 13:45:09'),
(183, 'ppr-20221119-014659', 29, 40, NULL, NULL, 1, 37.8, NULL, 0, 'Cash', NULL, '2022-11-19 13:46:59', '2022-11-19 13:46:59'),
(184, 'spr-20221119-050808', 30, NULL, 129, 11, 1, 300, NULL, 0, 'Cash', NULL, '2022-11-19 17:08:08', '2022-11-19 17:08:08'),
(185, 'spr-20221119-051209', 30, NULL, 130, 11, 1, 18, NULL, 0, 'Cash', NULL, '2022-11-19 17:12:09', '2022-11-19 17:12:09'),
(186, 'spr-20221123-012927', 30, NULL, 131, 11, 1, 1015, NULL, 0, 'Cash', '1015', '2022-11-23 13:29:27', '2022-11-23 13:29:27'),
(187, 'spr-20221123-013000', 30, NULL, 132, 11, 1, 3, NULL, 0, 'Cash', '3', '2022-11-23 13:30:00', '2022-11-23 13:30:00'),
(188, 'spr-20221124-101449', 30, NULL, 133, 11, 1, 2285, NULL, 0, 'Cash', '2285', '2022-11-24 10:14:49', '2022-11-24 10:14:49'),
(189, 'spr-20221124-101554', 30, NULL, 134, 11, 1, 17, NULL, 0, 'Cash', '17', '2022-11-24 10:15:54', '2022-11-24 10:15:54'),
(190, 'ppr-20221125-101811', 29, 41, NULL, NULL, 1, 174, NULL, 0, 'Cash', NULL, '2022-11-25 22:18:11', '2022-11-25 22:18:11'),
(191, 'ppr-20221125-101843', 29, 42, NULL, NULL, 1, 325.44, NULL, 0, 'Cash', NULL, '2022-11-25 22:18:43', '2022-11-25 22:18:43'),
(192, 'ppr-20221125-101921', 29, 43, NULL, NULL, 1, 145.8, NULL, 0, 'Cash', NULL, '2022-11-25 22:19:21', '2022-11-25 22:19:21'),
(193, 'spr-20221127-110352', 30, NULL, 135, 11, 1, 1095, NULL, 0, 'Cash', NULL, '2022-11-27 11:03:52', '2022-11-27 11:03:52'),
(194, 'spr-20221127-110606', 30, NULL, 136, 11, 1, 40, NULL, 0, 'Cash', NULL, '2022-11-27 11:06:06', '2022-11-27 11:06:06'),
(195, 'spr-20221127-110709', 30, NULL, 137, 11, 1, 200, NULL, 0, 'Cash', NULL, '2022-11-27 11:07:09', '2022-11-27 11:07:09'),
(196, 'spr-20221127-110929', 30, NULL, 138, 11, 1, 545, NULL, 0, 'Cash', NULL, '2022-11-27 11:09:29', '2022-11-27 11:09:29'),
(197, 'ppr-20221127-112729', 29, 44, NULL, NULL, 1, 11.05, NULL, 0, 'Cash', NULL, '2022-11-27 11:27:29', '2022-11-27 11:27:29'),
(198, 'ppr-20221127-112803', 29, 45, NULL, NULL, 1, 996, NULL, 0, 'Cash', NULL, '2022-11-27 11:28:03', '2022-11-27 11:28:03'),
(199, 'ppr-20221127-113012', 29, 46, NULL, NULL, 1, 874, NULL, 0, 'Cash', NULL, '2022-11-27 11:30:12', '2022-11-27 11:30:12'),
(200, 'spr-20221127-113324', 30, NULL, 139, 11, 1, 1220, NULL, 0, 'Cash', NULL, '2022-11-27 11:33:24', '2022-11-27 11:33:24'),
(201, 'spr-20221127-113444', 30, NULL, 140, 11, 1, 133, NULL, 0, 'Cash', NULL, '2022-11-27 11:34:44', '2022-11-27 11:34:44'),
(202, 'spr-20221128-092938', 30, NULL, 141, 11, 1, 21, NULL, 0, 'Cash', NULL, '2022-11-28 09:29:38', '2022-11-28 09:29:38'),
(203, 'spr-20221129-083239', 30, NULL, 142, 11, 1, 9, NULL, 0, 'Cash', NULL, '2022-11-29 20:32:39', '2022-11-29 20:32:39'),
(204, 'spr-20221129-083439', 30, NULL, 143, 11, 1, 1275, NULL, 0, 'Cash', NULL, '2022-11-29 20:34:39', '2022-11-29 20:34:39'),
(205, 'ppr-20221130-083025', 29, 47, NULL, NULL, 1, 1000, NULL, 0, 'Cash', NULL, '2022-11-30 20:30:25', '2022-11-30 20:30:25'),
(206, 'spr-20221130-083312', 30, NULL, 144, 11, 1, 930, NULL, 0, 'Cash', '930', '2022-11-30 20:33:12', '2022-11-30 20:33:12'),
(207, 'spr-20221130-084205', 30, NULL, 145, 11, 1, 27, NULL, 0, 'Cash', '27', '2022-11-30 20:42:05', '2022-11-30 20:42:05'),
(208, 'spr-20221202-103603', 30, NULL, 146, 11, 1, 12, NULL, 0, 'Cash', NULL, '2022-12-02 22:36:03', '2022-12-02 22:36:03'),
(209, 'spr-20221202-103623', 30, NULL, 147, 11, 1, 120, NULL, 0, 'Cash', NULL, '2022-12-02 22:36:23', '2022-12-02 22:36:23'),
(210, 'spr-20221202-103734', 30, NULL, 148, 11, 1, 4020, NULL, 0, 'Cash', NULL, '2022-12-02 22:37:34', '2022-12-02 22:37:34'),
(211, 'spr-20221203-095858', 30, NULL, 149, 11, 1, 33, NULL, 0, 'Cash', NULL, '2022-12-03 21:58:58', '2022-12-03 21:58:58'),
(212, 'spr-20221208-010920', 1, NULL, 155, 8, 1, 50, NULL, 0, 'Birthday', NULL, '2022-12-08 13:09:20', '2022-12-08 13:09:20'),
(213, 'ppr-20221208-092806', 29, 48, NULL, NULL, 1, 882.88, NULL, 0, 'Cash', NULL, '2022-12-08 21:28:06', '2022-12-08 21:28:06'),
(214, 'spr-20221208-102510', 30, NULL, 156, 11, 1, 215, NULL, 0, 'Cash', '215', '2022-12-08 22:25:10', '2022-12-08 22:25:10'),
(215, 'spr-20221209-102939', 30, NULL, 157, 11, 1, 32, NULL, 0, 'Cash', '32', '2022-12-09 22:29:39', '2022-12-09 22:29:39'),
(216, 'spr-20221209-103042', 30, NULL, 158, 11, 1, 175, NULL, 0, 'Cash', '175', '2022-12-09 22:30:42', '2022-12-09 22:30:42'),
(217, 'spr-20221209-103318', 30, NULL, 159, 11, 1, 845, NULL, 0, 'Cash', '845', '2022-12-09 22:33:18', '2022-12-09 22:33:18'),
(218, 'spr-20221211-113926', 30, NULL, 160, 11, 1, 300, NULL, 0, 'Cash', '300', '2022-12-11 11:39:26', '2022-12-11 11:39:26'),
(219, 'spr-20221211-114013', 30, NULL, 161, 11, 1, 12, NULL, 0, 'Cash', NULL, '2022-12-11 11:40:13', '2022-12-11 11:40:13'),
(220, 'spr-20221211-114032', 30, NULL, 162, 11, 1, 100, NULL, 0, 'Cash', NULL, '2022-12-11 11:40:32', '2022-12-11 11:40:32'),
(221, 'spr-20221211-114340', 30, NULL, 163, 8, 1, 1350, NULL, 0, 'Cash', NULL, '2022-12-11 11:43:40', '2022-12-11 11:43:40'),
(222, 'ppr-20221212-021116', 29, 49, NULL, NULL, 1, 125.28, NULL, 0, 'Cash', NULL, '2022-12-12 14:11:16', '2022-12-12 14:11:16'),
(223, 'spr-20221212-022228', 30, NULL, 164, 11, 1, 370, NULL, 0, 'Cash', '370', '2022-12-12 14:22:28', '2022-12-12 14:22:28'),
(224, 'spr-20221212-022249', 30, NULL, 165, 11, 1, 3, NULL, 0, 'Cash', NULL, '2022-12-12 14:22:49', '2022-12-12 14:22:49'),
(225, 'spr-20221212-081456', 30, NULL, 166, 11, 1, 3, NULL, 0, 'Cash', NULL, '2022-12-12 20:14:56', '2022-12-12 20:14:56'),
(226, 'spr-20221213-084524', 30, NULL, 167, 11, 1, 9, NULL, 0, 'Cash', NULL, '2022-12-13 20:45:24', '2022-12-13 20:45:24'),
(227, 'spr-20221213-100555', 30, NULL, 168, 11, 1, 270, NULL, 0, 'Cash', NULL, '2022-12-13 22:05:55', '2022-12-13 22:05:55'),
(228, 'spr-20221213-100651', 30, NULL, 169, 11, 1, 50, 1, 0, 'Points', NULL, '2022-12-13 22:06:51', '2022-12-13 22:06:51'),
(230, 'ppr-20221214-082456', 29, 50, NULL, NULL, 1, 360, NULL, 0, 'Cash', NULL, '2022-12-14 20:24:56', '2022-12-14 20:24:56'),
(231, 'spr-20221215-095113', 30, NULL, 171, 11, 1, 70, NULL, 0, 'Cash', NULL, '2022-12-15 09:51:13', '2022-12-15 09:51:13'),
(232, 'spr-20221215-095113', 30, NULL, 172, 11, 1, 70, NULL, 0, 'Cash', NULL, '2022-12-15 09:51:13', '2022-12-15 09:51:13'),
(233, 'spr-20221215-094901', 30, NULL, 173, 11, 1, 50, NULL, 0, 'Cash', NULL, '2022-12-15 21:49:01', '2022-12-15 21:49:01'),
(234, 'spr-20221215-095112', 30, NULL, 174, 11, 1, 990, NULL, 0, 'Cash', NULL, '2022-12-15 21:51:12', '2022-12-15 21:51:12'),
(235, 'spr-20221215-095319', 30, NULL, 175, 11, 1, 32, NULL, 0, 'Cash', NULL, '2022-12-15 21:53:19', '2022-12-15 21:53:19'),
(236, 'spr-20221215-095554', 30, NULL, 176, 11, 1, 1400, NULL, 0, 'Birthday', NULL, '2022-12-15 21:55:54', '2022-12-15 21:55:54'),
(237, 'ppr-20221217-095739', 29, 51, NULL, NULL, 1, 443.4, NULL, 0, 'Cash', NULL, '2022-12-17 21:57:39', '2022-12-17 21:57:39'),
(238, 'ppr-20221217-095813', 29, 52, NULL, NULL, 1, 134, NULL, 0, 'Cash', NULL, '2022-12-17 21:58:13', '2022-12-17 21:58:13'),
(239, 'ppr-20221217-095856', 29, 53, NULL, NULL, 1, 187.65, NULL, 0, 'Cash', NULL, '2022-12-17 21:58:56', '2022-12-17 21:58:56'),
(240, 'ppr-20221217-095935', 29, 54, NULL, NULL, 1, 183.6, NULL, 0, 'Cash', NULL, '2022-12-17 21:59:35', '2022-12-17 21:59:35'),
(241, 'spr-20221217-100109', 30, NULL, 179, 11, 1, 480, NULL, 0, 'Cash', NULL, '2022-12-17 22:01:09', '2022-12-17 22:01:09'),
(242, 'spr-20221217-100109', 30, NULL, 177, 11, 1, 480, NULL, 0, 'Cash', NULL, '2022-12-17 22:01:09', '2022-12-17 22:01:09'),
(243, 'spr-20221217-100312', 30, NULL, 180, 11, 1, 90, NULL, 0, 'Cash', NULL, '2022-12-17 22:03:12', '2022-12-17 22:03:12'),
(244, 'ppr-20221217-100712', 29, 55, NULL, NULL, 1, 31.56, NULL, 0, 'Cash', NULL, '2022-12-17 22:07:12', '2022-12-17 22:07:12'),
(245, 'ppr-20221217-100819', 29, 56, NULL, NULL, 1, 31.56, NULL, 0, 'Cash', NULL, '2022-12-17 22:08:19', '2022-12-17 22:08:19'),
(246, 'ppr-20221217-101046', 29, 57, NULL, NULL, 1, 26.3, NULL, 0, 'Cash', NULL, '2022-12-17 22:10:46', '2022-12-17 22:10:46'),
(247, 'spr-20221217-101203', 30, NULL, 181, 11, 1, 100, NULL, 0, 'Cash', NULL, '2022-12-17 22:12:03', '2022-12-17 22:12:03'),
(248, 'spr-20221217-103406', 30, NULL, 182, 11, 1, 320, NULL, 0, 'Birthday', NULL, '2022-12-17 22:34:06', '2022-12-17 22:34:06'),
(249, 'spr-20221219-082920', 30, NULL, 183, 11, 1, 210, NULL, 0, 'Cash', NULL, '2022-12-19 20:29:20', '2022-12-19 20:29:20'),
(250, 'spr-20221219-083056', 30, NULL, 184, 11, 1, 23, NULL, 0, 'Cash', NULL, '2022-12-19 20:30:56', '2022-12-19 20:30:56'),
(251, 'spr-20221219-083119', 30, NULL, 185, 11, 1, 100, NULL, 0, 'Cash', NULL, '2022-12-19 20:31:19', '2022-12-19 20:31:19'),
(252, 'spr-20221219-083456', 30, NULL, 186, 11, 1, 950, NULL, 0, 'Birthday', NULL, '2022-12-19 20:34:56', '2022-12-19 20:34:56'),
(253, 'spr-20221220-084033', 30, NULL, 187, 11, 1, 20, NULL, 0, 'Cash', NULL, '2022-12-20 20:40:33', '2022-12-20 20:40:33'),
(254, 'spr-20221220-084641', 30, NULL, 188, 11, 1, 8, NULL, 0, 'Cash', NULL, '2022-12-20 20:46:41', '2022-12-20 20:46:41'),
(255, 'spr-20221220-090746', 30, NULL, 189, 11, 1, 10, NULL, 0, 'Cash', NULL, '2022-12-20 21:07:46', '2022-12-20 21:07:46'),
(256, 'spr-20221221-080425', 30, NULL, 190, 11, 1, 115, NULL, 0, 'Cash', NULL, '2022-12-21 20:04:25', '2022-12-21 20:04:25'),
(257, 'spr-20221221-080502', 30, NULL, 191, 11, 1, 9, NULL, 0, 'Cash', NULL, '2022-12-21 20:05:02', '2022-12-21 20:05:02'),
(258, 'spr-20221222-094213', 30, NULL, 192, 11, 1, 20, NULL, 0, 'Cash', NULL, '2022-12-22 21:42:13', '2022-12-22 21:42:13'),
(259, 'spr-20221222-094213', 30, NULL, 193, 11, 1, 20, NULL, 0, 'Cash', NULL, '2022-12-22 21:42:13', '2022-12-22 21:42:13'),
(260, 'spr-20221222-094240', 30, NULL, 194, 11, 1, 100, NULL, 0, 'Cash', NULL, '2022-12-22 21:42:40', '2022-12-22 21:42:40'),
(261, 'spr-20221223-095547', 30, NULL, 195, 11, 1, 8, NULL, 0, 'Cash', NULL, '2022-12-23 21:55:47', '2022-12-23 21:55:47'),
(262, 'spr-20221223-095645', 30, NULL, 196, 11, 1, 225, NULL, 0, 'Cash', NULL, '2022-12-23 21:56:45', '2022-12-23 21:56:45'),
(263, 'spr-20221224-101047', 30, NULL, 197, 11, 1, 220, NULL, 0, 'Cash', NULL, '2022-12-24 22:10:47', '2022-12-24 22:10:47'),
(264, 'spr-20221224-101142', 30, NULL, 198, 11, 1, 18, NULL, 0, 'Cash', NULL, '2022-12-24 22:11:42', '2022-12-24 22:11:42'),
(265, 'spr-20221224-101246', 30, NULL, 199, 11, 1, 300, NULL, 0, 'Cash', NULL, '2022-12-24 22:12:46', '2022-12-24 22:12:46'),
(266, 'spr-20221224-101322', 30, NULL, 200, 11, 1, 1100, NULL, 0, 'Birthday', NULL, '2022-12-24 22:13:22', '2022-12-24 22:13:22'),
(267, 'spr-20221225-095714', 30, NULL, 201, 11, 1, 153, NULL, 0, 'Cash', NULL, '2022-12-25 21:57:14', '2022-12-25 21:57:14'),
(268, 'spr-20221225-095746', 30, NULL, 202, 11, 1, 480, NULL, 0, 'Birthday', NULL, '2022-12-25 21:57:46', '2022-12-25 21:57:46'),
(269, 'ppr-20221226-072931', 29, 58, NULL, NULL, 1, 263.5, NULL, 0, 'Cash', NULL, '2022-12-26 19:29:31', '2022-12-26 19:29:31'),
(270, 'spr-20221226-083405', 30, NULL, 203, 11, 1, 15, NULL, 0, 'Cash', NULL, '2022-12-26 20:34:05', '2022-12-26 20:34:05'),
(271, 'spr-20221226-083436', 30, NULL, 204, 11, 1, 150, NULL, 0, 'Cash', NULL, '2022-12-26 20:34:36', '2022-12-26 20:34:36'),
(272, 'spr-20221226-083543', 30, NULL, 205, 11, 1, 115, NULL, 0, 'Cash', NULL, '2022-12-26 20:35:43', '2022-12-26 20:35:43'),
(273, 'spr-20221226-083747', 30, NULL, 206, 11, 1, 405, NULL, 0, 'Birthday', NULL, '2022-12-26 20:37:47', '2022-12-26 20:37:47'),
(274, 'spr-20221226-084448', 30, NULL, 207, 11, 1, 310, NULL, 0, 'Birthday', NULL, '2022-12-26 20:44:48', '2022-12-26 20:44:48'),
(275, 'spr-20221227-082435', 30, NULL, 208, 11, 1, 345, NULL, 0, 'Cash', NULL, '2022-12-27 20:24:35', '2022-12-27 20:24:35'),
(276, 'spr-20221227-082541', 30, NULL, 209, 11, 1, 265, NULL, 0, 'Cash', NULL, '2022-12-27 20:25:41', '2022-12-27 20:25:41'),
(277, 'spr-20221227-082603', 30, NULL, 210, 11, 1, 15, NULL, 0, 'Cash', NULL, '2022-12-27 20:26:03', '2022-12-27 20:26:03'),
(278, 'spr-20221228-083017', 30, NULL, 211, 11, 1, 35, NULL, 0, 'Cash', NULL, '2022-12-28 20:30:17', '2022-12-28 20:30:17'),
(279, 'spr-20221228-083108', 30, NULL, 212, 11, 1, 170, NULL, 0, 'Cash', NULL, '2022-12-28 20:31:08', '2022-12-28 20:31:08'),
(280, 'ppr-20221229-060304', 29, 59, NULL, NULL, 1, 421.12, NULL, 0, 'Cash', NULL, '2022-12-29 18:03:04', '2022-12-29 18:03:04'),
(281, 'ppr-20221229-090022', 1, 60, NULL, NULL, 1, 375, NULL, 0, 'Cash', NULL, '2022-12-29 21:00:22', '2022-12-29 21:00:22'),
(282, 'spr-20221229-093839', 30, NULL, 213, 11, 1, 51, NULL, 0, 'Cash', NULL, '2022-12-29 21:38:39', '2022-12-29 21:38:39'),
(283, 'spr-20221229-093904', 30, NULL, 214, 11, 1, 290, NULL, 0, 'Cash', NULL, '2022-12-29 21:39:04', '2022-12-29 21:39:04'),
(284, 'spr-20221229-093939', 30, NULL, 215, 11, 1, 650, NULL, 0, 'Cash', NULL, '2022-12-29 21:39:39', '2022-12-29 21:39:39'),
(285, 'spr-20221229-094045', 30, NULL, 216, 11, 1, 1150, NULL, 0, 'Birthday', NULL, '2022-12-29 21:40:45', '2022-12-29 21:40:45'),
(286, 'spr-20221230-043450', 30, NULL, 217, 11, 1, 250, NULL, 0, 'Cash', NULL, '2022-12-30 16:34:50', '2022-12-30 16:34:50'),
(287, 'spr-20221230-043527', 30, NULL, 218, 11, 1, 21, NULL, 0, 'Cash', NULL, '2022-12-30 16:35:27', '2022-12-30 16:35:27'),
(288, 'spr-20221230-043609', 30, NULL, 219, 11, 1, 140, NULL, 0, 'Cash', NULL, '2022-12-30 16:36:09', '2022-12-30 16:36:09'),
(289, 'spr-20221230-092944', 30, NULL, 220, 11, 1, 20, NULL, 0, 'Cash', NULL, '2022-12-30 21:29:44', '2022-12-30 21:29:44'),
(290, 'spr-20221230-093019', 30, NULL, 221, 11, 1, 6, NULL, 0, 'Cash', NULL, '2022-12-30 21:30:19', '2022-12-30 21:30:19'),
(291, 'ppr-20221230-093607', 29, 61, NULL, NULL, 1, 234, NULL, 0, 'Cash', NULL, '2022-12-30 21:36:07', '2022-12-30 21:36:07'),
(292, 'spr-20221230-093632', 30, NULL, 222, 11, 1, 280, NULL, 0, 'Cash', NULL, '2022-12-30 21:36:32', '2022-12-30 21:36:32'),
(293, 'spr-20221231-080938', 30, NULL, 223, 11, 1, 9, NULL, 0, 'Cash', NULL, '2022-12-31 20:09:38', '2022-12-31 20:09:38'),
(294, 'spr-20221231-081033', 30, NULL, 224, 11, 1, 40, NULL, 0, 'Cash', NULL, '2022-12-31 20:10:33', '2022-12-31 20:10:33'),
(295, 'spr-20230101-084635', 30, NULL, 225, 11, 1, 30, NULL, 0, 'Cash', NULL, '2023-01-01 20:46:35', '2023-01-01 20:46:35'),
(296, 'spr-20230101-084656', 30, NULL, 226, 11, 1, 6, NULL, 0, 'Cash', NULL, '2023-01-01 20:46:56', '2023-01-01 20:46:56'),
(297, 'spr-20230101-084725', 30, NULL, 227, 11, 1, 255, NULL, 0, 'Cash', NULL, '2023-01-01 20:47:25', '2023-01-01 20:47:25'),
(298, 'spr-20230102-080904', 30, NULL, 228, 11, 1, 10, NULL, 0, 'Cash', NULL, '2023-01-02 20:09:04', '2023-01-02 20:09:04'),
(299, 'spr-20230102-080927', 30, NULL, 229, 11, 1, 9, NULL, 0, 'Cash', NULL, '2023-01-02 20:09:27', '2023-01-02 20:09:27'),
(300, 'spr-20230103-085028', 30, NULL, 230, 11, 1, 59, NULL, 0, 'Cash', NULL, '2023-01-03 20:50:28', '2023-01-03 20:50:28'),
(301, 'spr-20230103-085115', 30, NULL, 231, 11, 1, 190, NULL, 0, 'Gift Card', NULL, '2023-01-03 20:51:15', '2023-01-03 20:51:15'),
(302, 'spr-20230103-085139', 30, NULL, 232, 11, 1, 190, 1, 0, 'Points', NULL, '2023-01-03 20:51:39', '2023-01-03 20:51:39'),
(303, 'spr-20230103-085255', 30, NULL, 234, 11, 1, 190, 1, 0, 'Points', NULL, '2023-01-03 20:52:55', '2023-01-03 20:52:55'),
(304, 'spr-20230103-085408', 30, NULL, 235, 11, 1, 280, NULL, 0, 'Cash', NULL, '2023-01-03 20:54:08', '2023-01-03 20:54:08'),
(305, 'spr-20230103-085558', 30, NULL, 236, 11, 1, 350, 2, 0, 'Points', NULL, '2023-01-03 20:55:58', '2023-01-03 20:55:58'),
(306, 'spr-20230103-085809', 30, NULL, 237, 11, 1, 325, NULL, 0, 'Cash', NULL, '2023-01-03 20:58:09', '2023-01-03 20:58:09'),
(307, 'spr-20230103-085841', 30, NULL, 238, 11, 1, 425, 2, 0, 'Points', NULL, '2023-01-03 20:58:41', '2023-01-03 20:58:41'),
(308, 'spr-20230103-085921', 30, NULL, 239, 11, 1, 75, 1, 0, 'Points', NULL, '2023-01-03 20:59:21', '2023-01-03 20:59:21'),
(309, 'spr-20230103-085952', 30, NULL, 240, 11, 1, 20, 1, 0, 'Points', NULL, '2023-01-03 20:59:52', '2023-01-03 20:59:52'),
(310, 'spr-20230103-090022', 30, NULL, 241, 11, 1, 50, 1, 0, 'Points', NULL, '2023-01-03 21:00:22', '2023-01-03 21:00:22'),
(311, 'spr-20230103-090052', 30, NULL, 242, 11, 1, 125, 1, 0, 'Points', NULL, '2023-01-03 21:00:52', '2023-01-03 21:00:52'),
(312, 'spr-20230103-090116', 30, NULL, 243, 11, 1, 35, 1, 0, 'Points', NULL, '2023-01-03 21:01:16', '2023-01-03 21:01:16'),
(313, 'spr-20230103-090316', 30, NULL, 244, 11, 1, 340, NULL, 0, 'Cash', NULL, '2023-01-03 21:03:16', '2023-01-03 21:03:16'),
(314, 'ppr-20230103-090520', 29, 62, NULL, NULL, 1, 95.8, NULL, 0, 'Cash', NULL, '2023-01-03 21:05:20', '2023-01-03 21:05:20'),
(315, 'ppr-20230103-090550', 29, 63, NULL, NULL, 1, 107.25, NULL, 0, 'Cash', NULL, '2023-01-03 21:05:50', '2023-01-03 21:05:50'),
(316, 'spr-20230104-074842', 30, NULL, 245, 11, 1, 440, NULL, 0, 'Cash', NULL, '2023-01-04 19:48:42', '2023-01-04 19:48:42'),
(317, 'spr-20230104-074918', 30, NULL, 246, 11, 1, 45, NULL, 0, 'Cash', NULL, '2023-01-04 19:49:18', '2023-01-04 19:49:18'),
(318, 'spr-20230104-074938', 30, NULL, 247, 11, 1, 6, NULL, 0, 'Cash', NULL, '2023-01-04 19:49:38', '2023-01-04 19:49:38'),
(319, 'spr-20230105-091438', 30, NULL, 248, 11, 1, 60, NULL, 0, 'Cash', NULL, '2023-01-05 21:14:38', '2023-01-05 21:14:38'),
(320, 'spr-20230105-091510', 30, NULL, 249, 11, 1, 330, NULL, 0, 'Cash', NULL, '2023-01-05 21:15:10', '2023-01-05 21:15:10'),
(321, 'spr-20230105-091540', 30, NULL, 250, 11, 1, 12, NULL, 0, 'Cash', NULL, '2023-01-05 21:15:40', '2023-01-05 21:15:40'),
(322, 'ppr-20230106-060634', 29, 64, NULL, NULL, 1, 3906.15, NULL, 0, 'Cash', NULL, '2023-01-06 18:06:34', '2023-01-06 18:06:34'),
(323, 'spr-20230106-092437', 30, NULL, 251, 11, 1, 160, NULL, 0, 'Cash', NULL, '2023-01-06 21:24:37', '2023-01-06 21:24:37'),
(324, 'spr-20230106-092519', 30, NULL, 252, 11, 1, 15, NULL, 0, 'Cash', NULL, '2023-01-06 21:25:19', '2023-01-06 21:25:19'),
(325, 'spr-20230106-092551', 30, NULL, 253, 11, 1, 260, NULL, 0, 'Cash', NULL, '2023-01-06 21:25:51', '2023-01-06 21:25:51'),
(326, 'spr-20230107-081621', 30, NULL, 254, 11, 1, 18, NULL, 0, 'Cash', NULL, '2023-01-07 20:16:21', '2023-01-07 20:16:21'),
(327, 'spr-20230107-081652', 30, NULL, 255, 11, 1, 75, NULL, 0, 'Cash', NULL, '2023-01-07 20:16:52', '2023-01-07 20:16:52'),
(328, 'spr-20230108-081818', 30, NULL, 256, 11, 1, 3, NULL, 0, 'Cash', NULL, '2023-01-08 20:18:18', '2023-01-08 20:18:18'),
(329, 'spr-20230108-081836', 30, NULL, 257, 11, 1, 30, NULL, 0, 'Cash', NULL, '2023-01-08 20:18:36', '2023-01-08 20:18:36'),
(330, 'spr-20230108-081852', 30, NULL, 258, 11, 1, 100, NULL, 0, 'Cash', NULL, '2023-01-08 20:18:52', '2023-01-08 20:18:52'),
(331, 'spr-20230109-082531', 30, NULL, 259, 11, 1, 6, NULL, 0, 'Cash', NULL, '2023-01-09 20:25:31', '2023-01-09 20:25:31'),
(332, 'spr-20230111-034127', 30, NULL, 260, 11, 1, 6, NULL, 0, 'Cash', NULL, '2023-01-11 15:41:27', '2023-01-11 15:41:27'),
(333, 'spr-20230112-083847', 30, NULL, 261, 11, 1, 12, NULL, 0, 'Cash', NULL, '2023-01-12 20:38:47', '2023-01-12 20:38:47'),
(334, 'spr-20230112-084855', 30, NULL, 262, 11, 1, 860, NULL, 0, 'Birthday', NULL, '2023-01-12 20:48:55', '2023-01-12 20:48:55'),
(335, 'spr-20230113-093132', 30, NULL, 263, 11, 1, 60, NULL, 0, 'Cash', NULL, '2023-01-13 21:31:32', '2023-01-13 21:31:32'),
(336, 'spr-20230113-093216', 30, NULL, 264, 11, 1, 3, NULL, 0, 'Cash', NULL, '2023-01-13 21:32:16', '2023-01-13 21:32:16'),
(337, 'spr-20230113-093237', 30, NULL, 265, 11, 1, 150, NULL, 0, 'Cash', NULL, '2023-01-13 21:32:37', '2023-01-13 21:32:37'),
(338, 'spr-20230113-093329', 30, NULL, 266, 11, 1, 600, NULL, 0, 'Birthday', NULL, '2023-01-13 21:33:29', '2023-01-13 21:33:29'),
(339, 'spr-20230114-081449', 30, NULL, 267, 11, 1, 20, NULL, 0, 'Cash', NULL, '2023-01-14 20:14:49', '2023-01-14 20:14:49'),
(340, 'spr-20230114-081551', 30, NULL, 268, 11, 1, 28, NULL, 0, 'Cash', NULL, '2023-01-14 20:15:51', '2023-01-14 20:15:51'),
(341, 'spr-20230115-081924', 30, NULL, 269, 11, 1, 100, NULL, 0, 'Cash', NULL, '2023-01-15 20:19:24', '2023-01-15 20:19:24'),
(342, 'spr-20230118-084408', 30, NULL, 270, 11, 1, 355, NULL, 0, 'Cash', NULL, '2023-01-18 20:44:08', '2023-01-18 20:44:08'),
(343, 'spr-20230118-084456', 30, NULL, 271, 11, 1, 6, NULL, 0, 'Cash', NULL, '2023-01-18 20:44:56', '2023-01-18 20:44:56'),
(344, 'spr-20230118-084551', 30, NULL, 272, 11, 1, 150, NULL, 0, 'Cash', NULL, '2023-01-18 20:45:51', '2023-01-18 20:45:51'),
(345, 'spr-20230119-093838', 30, NULL, 273, 11, 1, 250, NULL, 0, 'Cash', NULL, '2023-01-19 21:38:38', '2023-01-19 21:38:38'),
(346, 'spr-20230119-093910', 30, NULL, 274, 11, 1, 3, NULL, 0, 'Cash', NULL, '2023-01-19 21:39:10', '2023-01-19 21:39:10'),
(347, 'spr-20230119-093955', 30, NULL, 275, 11, 1, 300, NULL, 0, 'Cash', NULL, '2023-01-19 21:39:55', '2023-01-19 21:39:55'),
(348, 'ppr-20230120-041958', 29, 65, NULL, NULL, 1, 2865.84, NULL, 0, 'Cash', NULL, '2023-01-20 16:19:58', '2023-01-20 16:19:58'),
(349, 'spr-20230120-092308', 30, NULL, 276, 12, 1, 750, NULL, 0, 'Cash', NULL, '2023-01-20 21:23:08', '2023-01-20 21:23:08'),
(350, 'spr-20230120-092424', 30, NULL, 277, 12, 1, 610, NULL, 0, 'Cash', NULL, '2023-01-20 21:24:24', '2023-01-20 21:24:24'),
(351, 'spr-20230120-092504', 30, NULL, 278, 12, 1, 15, NULL, 0, 'Cash', NULL, '2023-01-20 21:25:04', '2023-01-20 21:25:04'),
(352, 'spr-20230120-092714', 30, NULL, 279, 12, 1, 2812, NULL, 0, 'Birthday', NULL, '2023-01-20 21:27:14', '2023-01-20 21:27:14'),
(353, 'spr-20230121-083942', 30, NULL, 281, 13, 1, 1060, NULL, 0, 'Birthday', NULL, '2023-01-21 20:39:42', '2023-01-21 20:39:42'),
(354, 'spr-20230121-083942', 30, NULL, 280, 13, 1, 1060, NULL, 0, 'Birthday', NULL, '2023-01-21 20:39:42', '2023-01-21 20:39:42'),
(355, 'spr-20230122-023233', 30, NULL, 282, 13, 1, 170, NULL, 0, 'Cash', NULL, '2023-01-22 14:32:33', '2023-01-22 14:32:33'),
(356, 'spr-20230122-023352', 30, NULL, 283, 13, 1, 390, NULL, 0, 'Cash', NULL, '2023-01-22 14:33:52', '2023-01-22 14:33:52'),
(357, 'spr-20230122-023440', 30, NULL, 284, 13, 1, 21, NULL, 0, 'Cash', NULL, '2023-01-22 14:34:40', '2023-01-22 14:34:40'),
(358, 'ppr-20230314-113601', 1, 66, NULL, NULL, 1, 950, NULL, 0, 'Cash', NULL, '2023-03-14 09:36:01', '2023-03-14 09:36:01'),
(359, 'ppr-20230314-035834', 1, 67, NULL, NULL, 1, 220, NULL, 0, 'Cash', NULL, '2023-03-14 13:58:34', '2023-03-14 13:58:34'),
(360, 'spr-20230319-040247', 1, NULL, 285, 15, 1, 95, NULL, 0, 'Credit Card', NULL, '2023-03-19 14:02:47', '2023-03-19 14:02:47'),
(361, 'spr-20230319-050214', 1, NULL, 286, 15, 1, 35, NULL, 0, 'Credit Card', NULL, '2023-03-19 15:02:14', '2023-03-19 15:02:14'),
(362, 'ppr-20230409-013236', 1, 69, NULL, NULL, 1, 1150, NULL, 0, 'Cash', NULL, '2023-04-09 11:32:36', '2023-04-09 11:32:36'),
(363, 'ppr-20230409-014102', 1, 70, NULL, NULL, 1, 540, NULL, 0, 'Cash', NULL, '2023-04-09 11:41:02', '2023-04-09 11:41:02'),
(364, 'spr-20230409-014404', 1, NULL, 287, 15, 1, 20, NULL, 0, 'Cash', NULL, '2023-04-09 11:44:04', '2023-04-09 11:44:04'),
(365, 'spr-20230409-015019', 1, NULL, 288, 15, 1, 100, NULL, 0, 'Cash', NULL, '2023-04-09 11:50:19', '2023-04-09 11:50:19'),
(366, 'spr-20230410-021955', 1, NULL, 289, 15, 1, 60, NULL, 0, 'Credit Card', NULL, '2023-04-10 12:19:55', '2023-04-10 12:19:55'),
(367, 'spr-20230410-022010', 1, NULL, 290, 15, 1, 35, NULL, 0, 'Credit Card', NULL, '2023-04-10 12:20:10', '2023-04-10 12:20:10'),
(368, 'spr-20230410-023751', 1, NULL, 291, 15, 1, 35, NULL, 0, 'Credit Card', NULL, '2023-04-10 12:37:51', '2023-04-10 12:37:51'),
(369, 'spr-20230410-030610', 1, NULL, 292, 15, 1, 25, NULL, 0, 'Credit Card', NULL, '2023-04-10 13:06:10', '2023-04-10 13:06:10'),
(370, 'spr-20230410-035202', 1, NULL, 293, 15, 1, 25, NULL, 0, 'Credit Card', NULL, '2023-04-10 13:52:02', '2023-04-10 13:52:02'),
(371, 'spr-20230412-030229', 1, NULL, 294, 15, 1, 35, NULL, 0, 'Credit Card', NULL, '2023-04-12 13:02:29', '2023-04-12 13:02:29'),
(372, 'spr-20230412-030417', 1, NULL, 295, 15, 1, 35, NULL, 0, 'Credit Card', NULL, '2023-04-12 13:04:17', '2023-04-12 13:04:17'),
(373, 'spr-20230412-030444', 1, NULL, 296, 15, 1, 35, NULL, 0, 'Credit Card', NULL, '2023-04-12 13:04:44', '2023-04-12 13:04:44'),
(374, 'spr-20230426-114758', 1, NULL, 297, 15, 1, 70, NULL, 0, 'Cash', NULL, '2023-04-26 09:47:58', '2023-04-26 09:47:58'),
(375, 'spr-20230426-115043', 1, NULL, 298, 15, 1, 25, NULL, 0, 'Cash', NULL, '2023-04-26 09:50:43', '2023-04-26 09:50:43'),
(376, 'spr-20230502-091547', 1, NULL, 299, 15, 1, 100, NULL, 0, 'Cash', NULL, '2023-05-02 07:15:47', '2023-05-02 07:15:47'),
(377, 'spr-20230502-092040', 1, NULL, 300, 15, 1, 105, NULL, 0, 'Cash', NULL, '2023-05-02 07:20:40', '2023-05-02 07:20:40'),
(378, 'spr-20230502-092414', 1, NULL, 301, 15, 1, 70, NULL, 0, 'Credit Card', NULL, '2023-05-02 07:24:14', '2023-05-02 07:24:14'),
(379, 'spr-20230502-092636', 1, NULL, 302, 15, 1, 50, NULL, 20, 'Credit Card', NULL, '2023-05-02 07:26:36', '2023-05-02 07:26:36'),
(380, 'spr-20230502-021845', 1, NULL, 303, 15, 1, 35, NULL, 0, 'Credit Card', NULL, '2023-05-02 11:18:45', '2023-05-02 11:18:45'),
(381, 'spr-20230502-021904', 1, NULL, 304, 15, 1, 105, NULL, 0, 'Cash', NULL, '2023-05-02 11:19:04', '2023-05-02 11:19:04'),
(382, 'spr-20230502-022054', 1, NULL, 305, 15, 1, 35, NULL, 0, 'Cash', NULL, '2023-05-02 11:20:54', '2023-05-02 11:20:54'),
(383, 'spr-20230502-022241', 1, NULL, 306, 15, 1, 35, NULL, 0, 'Cash', NULL, '2023-05-02 11:22:41', '2023-05-02 11:22:41'),
(384, 'spr-20230502-022522', 1, NULL, 307, 15, 1, 35, NULL, 0, 'Cash', NULL, '2023-05-02 11:25:22', '2023-05-02 11:25:22'),
(385, 'spr-20230502-023038', 1, NULL, 308, 15, 1, 35, NULL, 0, 'Cash', NULL, '2023-05-02 11:30:38', '2023-05-02 11:30:38'),
(386, 'spr-20230502-025153', 1, NULL, 309, 15, 1, 125, NULL, 0, 'Cash', NULL, '2023-05-02 11:51:53', '2023-05-02 11:51:53'),
(387, 'spr-20230504-023441', 1, NULL, 310, 15, 1, 20, NULL, 0, 'Cash', NULL, '2023-05-04 11:34:41', '2023-05-04 11:34:41'),
(388, 'spr-20230504-023510', 1, NULL, 311, 15, 1, 20, NULL, 0, 'Cash', NULL, '2023-05-04 11:35:10', '2023-05-04 11:35:10'),
(389, 'spr-20230504-023839', 1, NULL, 312, 15, 1, 20, NULL, 0, 'Cash', NULL, '2023-05-04 11:38:39', '2023-05-04 11:38:39'),
(390, 'spr-20230504-023905', 1, NULL, 313, 15, 1, 20, NULL, 0, 'Cash', NULL, '2023-05-04 11:39:05', '2023-05-04 11:39:05'),
(391, 'spr-20230504-024056', 1, NULL, 314, 15, 1, 20, NULL, 0, 'Cash', NULL, '2023-05-04 11:40:56', '2023-05-04 11:40:56'),
(392, 'spr-20230504-024255', 1, NULL, 315, 15, 1, 20, NULL, 0, 'Cash', NULL, '2023-05-04 11:42:55', '2023-05-04 11:42:55'),
(393, 'spr-20230504-024412', 1, NULL, 316, 15, 1, 20, NULL, 0, 'Cash', NULL, '2023-05-04 11:44:12', '2023-05-04 11:44:12'),
(394, 'spr-20230504-025029', 1, NULL, 317, 15, 1, 20, NULL, 0, 'Cash', NULL, '2023-05-04 11:50:29', '2023-05-04 11:50:29'),
(395, 'spr-20230504-025133', 1, NULL, 318, 15, 1, 20, NULL, 0, 'Cash', NULL, '2023-05-04 11:51:33', '2023-05-04 11:51:33'),
(396, 'spr-20230507-100452', 1, NULL, 319, 15, 1, 85, NULL, 0, 'Cash', NULL, '2023-05-07 07:04:52', '2023-05-07 07:04:52'),
(397, 'spr-20230507-101000', 1, NULL, 321, 15, 1, 20, NULL, 0, 'Cash', NULL, '2023-05-07 07:10:00', '2023-05-07 07:10:00'),
(398, 'spr-20230507-101357', 1, NULL, 322, 15, 1, 20, NULL, 0, 'Cash', NULL, '2023-05-07 07:13:57', '2023-05-07 07:13:57'),
(399, 'spr-20230507-101503', 1, NULL, 323, 15, 1, 20, NULL, 0, 'Cash', NULL, '2023-05-07 07:15:03', '2023-05-07 07:15:03'),
(400, 'spr-20230507-101901', 1, NULL, 327, 15, 1, 20, NULL, 0, 'Cash', NULL, '2023-05-07 07:19:01', '2023-05-07 07:19:01'),
(401, 'spr-20230507-101943', 1, NULL, 328, 15, 1, 20, NULL, 0, 'Cash', NULL, '2023-05-07 07:19:43', '2023-05-07 07:19:43'),
(402, 'spr-20230507-103039', 1, NULL, 335, 15, 1, 20, NULL, 0, 'Cash', NULL, '2023-05-07 07:30:39', '2023-05-07 07:30:39'),
(403, 'spr-20230507-105001', 1, NULL, 336, 15, 1, 40, NULL, 0, 'Cash', NULL, '2023-05-07 07:50:01', '2023-05-07 07:50:01'),
(404, 'spr-20230507-105250', 1, NULL, 337, 15, 1, 20, NULL, 80, 'Cash', NULL, '2023-05-07 07:52:50', '2023-05-07 07:52:50'),
(405, 'spr-20230507-112857', 1, NULL, 360, 15, 1, 20, NULL, 0, 'Cash', NULL, '2023-05-07 08:28:57', '2023-05-07 08:28:57'),
(406, 'spr-20230507-114506', 1, NULL, 361, 15, 1, 23, NULL, 0, 'Cash', NULL, '2023-05-07 08:45:06', '2023-05-07 08:45:06'),
(407, 'spr-20230507-020745', 1, NULL, 363, 15, 1, 45, NULL, 0, 'Cash', NULL, '2023-05-07 11:07:45', '2023-05-07 11:07:45'),
(408, 'spr-20230507-021128', 1, NULL, 365, 15, 1, 35, NULL, 0, 'Cash', NULL, '2023-05-07 11:11:28', '2023-05-07 11:11:28'),
(409, 'spr-20230507-021543', 1, NULL, 366, 15, 1, 22.25, NULL, 0, 'Cash', NULL, '2023-05-07 11:15:43', '2023-05-07 11:15:43'),
(410, 'spr-20230507-022004', 1, NULL, 368, 15, 1, 10, NULL, 0, 'Cash', NULL, '2023-05-07 11:20:04', '2023-05-07 11:20:04'),
(411, 'spr-20230507-022247', 1, NULL, 369, 15, 1, 9, NULL, 0, 'Cash', NULL, '2023-05-07 11:22:47', '2023-05-07 11:22:47'),
(412, 'spr-20230507-022930', 1, NULL, 370, 15, 1, 15, NULL, 0, 'Cash', NULL, '2023-05-07 11:29:30', '2023-05-07 11:29:30'),
(413, 'spr-20230507-023804', 1, NULL, 371, 15, 1, 60, NULL, 0, 'Cash', NULL, '2023-05-07 11:38:04', '2023-05-07 11:38:04'),
(414, 'spr-20230507-023832', 1, NULL, 372, 15, 1, 32.8, NULL, 0, 'Cash', NULL, '2023-05-07 11:38:32', '2023-05-07 11:38:32'),
(415, 'spr-20230509-124529', 1, NULL, 373, 15, 1, 31.5, NULL, 0, 'Cash', NULL, '2023-05-09 09:45:29', '2023-05-09 09:45:29'),
(416, 'spr-20230509-124751', 1, NULL, 374, 15, 1, 35, NULL, 0, 'Cash', NULL, '2023-05-09 09:47:51', '2023-05-09 09:47:51'),
(417, 'spr-20230509-125538', 1, NULL, 375, 15, 1, 31.5, NULL, 0, 'Cash', NULL, '2023-05-09 09:55:38', '2023-05-09 09:55:38'),
(418, 'spr-20230509-010954', 1, NULL, 376, 15, 1, 31.5, NULL, 0, 'Cash', NULL, '2023-05-09 10:09:54', '2023-05-09 10:09:54'),
(419, 'spr-20230509-011639', 1, NULL, 377, 15, 1, 25, NULL, 0, 'Cash', NULL, '2023-05-09 10:16:39', '2023-05-09 10:16:39'),
(420, 'spr-20230509-011953', 1, NULL, 378, 15, 1, 35, NULL, 0, 'Credit Card', NULL, '2023-05-09 10:19:53', '2023-05-09 10:19:53'),
(421, 'spr-20230509-015549', 1, NULL, 379, 15, 1, 200, NULL, 0, 'Cash', NULL, '2023-05-09 10:55:49', '2023-05-09 10:55:49'),
(422, 'spr-20230510-093527', 1, NULL, 381, 15, 1, 70, NULL, 0, 'Cash', NULL, '2023-05-10 06:35:27', '2023-05-10 06:35:27'),
(423, 'spr-20230510-094218', 1, NULL, 382, 15, 1, 35, NULL, 0, 'Cash', NULL, '2023-05-10 06:42:18', '2023-05-10 06:42:18'),
(424, 'spr-20230510-094258', 1, NULL, 383, 15, 1, 35, NULL, 0, 'Cash', NULL, '2023-05-10 06:42:58', '2023-05-10 06:42:58'),
(425, 'spr-20230510-094623', 1, NULL, 384, 15, 1, 31.5, NULL, 0, 'Cash', NULL, '2023-05-10 06:46:23', '2023-05-10 06:46:23'),
(426, 'spr-20230510-100202', 1, NULL, 385, 15, 1, 35, NULL, 0, 'Cash', NULL, '2023-05-10 07:02:02', '2023-05-10 07:02:02'),
(427, 'spr-20230510-101050', 1, NULL, 386, 15, 1, 35, NULL, 0, 'Cash', NULL, '2023-05-10 07:10:50', '2023-05-10 07:10:50'),
(428, 'spr-20230510-101159', 1, NULL, 387, 15, 1, 35, NULL, 0, 'Cash', NULL, '2023-05-10 07:11:59', '2023-05-10 07:11:59'),
(429, 'spr-20230510-102122', 1, NULL, 388, 15, 1, 70, NULL, 0, 'Cash', NULL, '2023-05-10 07:21:22', '2023-05-10 07:21:22'),
(430, 'spr-20230510-102611', 1, NULL, 389, 15, 1, 35, NULL, 0, 'Cash', NULL, '2023-05-10 07:26:11', '2023-05-10 07:26:11'),
(431, 'spr-20230510-102749', 1, NULL, 390, 15, 1, 130, NULL, 0, 'Cash', NULL, '2023-05-10 07:27:49', '2023-05-10 07:27:49'),
(432, 'spr-20230510-103905', 1, NULL, 391, 15, 1, 120, NULL, 0, 'Cash', NULL, '2023-05-10 07:39:05', '2023-05-10 07:39:05');
INSERT INTO `payments` (`id`, `payment_reference`, `user_id`, `purchase_id`, `sale_id`, `cash_register_id`, `account_id`, `amount`, `used_points`, `change`, `paying_method`, `payment_note`, `created_at`, `updated_at`) VALUES
(433, 'spr-20230510-104811', 1, NULL, 392, 15, 1, 175, NULL, 0, 'Cash', NULL, '2023-05-10 07:48:11', '2023-05-10 07:48:11'),
(434, 'spr-20230510-105121', 1, NULL, 393, 15, 1, 175, NULL, 0, 'Cash', NULL, '2023-05-10 07:51:21', '2023-05-10 07:51:21'),
(435, 'spr-20230510-105259', 1, NULL, 394, 15, 1, 20, NULL, 0, 'Cash', NULL, '2023-05-10 07:52:59', '2023-05-10 07:52:59'),
(436, 'spr-20230510-105346', 1, NULL, 395, 15, 1, 20, NULL, 0, 'Cash', NULL, '2023-05-10 07:53:46', '2023-05-10 07:53:46'),
(437, 'spr-20230510-110821', 1, NULL, 396, 15, 1, 35, NULL, 0, 'Cash', NULL, '2023-05-10 08:08:21', '2023-05-10 08:08:21'),
(438, 'spr-20230510-115007', 1, NULL, 397, 15, 1, 165, NULL, 0, 'Cash', NULL, '2023-05-10 08:50:07', '2023-05-10 08:50:07'),
(439, 'spr-20230510-115131', 1, NULL, 398, 15, 1, 70, NULL, 0, 'Cash', NULL, '2023-05-10 08:51:31', '2023-05-10 08:51:31'),
(440, 'spr-20230510-115225', 1, NULL, 399, 15, 1, 175, NULL, 0, 'Cash', NULL, '2023-05-10 08:52:25', '2023-05-10 08:52:25'),
(441, 'spr-20230510-115249', 1, NULL, 400, 15, 1, 70, NULL, 0, 'Cash', NULL, '2023-05-10 08:52:49', '2023-05-10 08:52:49'),
(442, 'spr-20230510-120210', 1, NULL, 401, 15, 1, 60, NULL, 0, 'Cash', NULL, '2023-05-10 09:02:10', '2023-05-10 09:02:10'),
(443, 'spr-20230510-120934', 1, NULL, 402, 15, 1, 57.5, NULL, 0, 'Cash', NULL, '2023-05-10 09:09:34', '2023-05-10 09:09:34'),
(444, 'spr-20230511-091828', 1, NULL, 403, 15, 1, 50, NULL, 0, 'Cash', NULL, '2023-05-11 06:18:28', '2023-05-11 06:18:28'),
(445, 'spr-20230511-091850', 1, NULL, 404, 15, 1, 63, NULL, 0, 'Cash', NULL, '2023-05-11 06:18:50', '2023-05-11 06:18:50'),
(446, 'spr-20230511-023504', 1, NULL, 405, 15, 1, 50, NULL, 0, 'Cash', NULL, '2023-05-11 11:35:04', '2023-05-11 11:35:04'),
(447, 'spr-20230511-023521', 1, NULL, 406, 15, 1, 140, NULL, 0, 'Cash', NULL, '2023-05-11 11:35:21', '2023-05-11 11:35:21'),
(448, 'spr-20230529-100048', 1, NULL, 407, 15, 1, 35, NULL, 0, 'Cash', NULL, '2023-05-29 07:00:48', '2023-05-29 07:00:48'),
(449, 'spr-20230529-100845', 1, NULL, 408, 15, 1, 110, NULL, 0, 'Cash', NULL, '2023-05-29 07:08:45', '2023-05-29 07:08:45'),
(450, 'spr-20230529-101413', 1, NULL, 409, 15, 1, 79.8, NULL, 0, 'Cash', NULL, '2023-05-29 07:14:13', '2023-05-29 07:14:13'),
(451, 'spr-20230529-101559', 1, NULL, 410, 15, 1, 71.82, NULL, 0, 'Cash', NULL, '2023-05-29 07:15:59', '2023-05-29 07:15:59'),
(452, 'spr-20230529-104836', 1, NULL, 411, 15, 1, 68.4, NULL, 0, 'Cash', NULL, '2023-05-29 07:48:36', '2023-05-29 07:48:36'),
(453, 'spr-20230529-111729', 1, NULL, 412, 15, 1, 94.5, NULL, 0, 'Cash', NULL, '2023-05-29 08:17:29', '2023-05-29 08:17:29'),
(454, 'spr-20230529-112000', 1, NULL, 413, 15, 1, 92.34, NULL, 0, 'Cash', NULL, '2023-05-29 08:20:00', '2023-05-29 08:20:00'),
(455, 'spr-20230529-113418', 1, NULL, 414, 15, 1, 125, NULL, 0, 'Cash', NULL, '2023-05-29 08:34:18', '2023-05-29 08:34:18'),
(456, 'spr-20230529-030812', 1, NULL, 415, 15, 1, 79.8, NULL, 0, 'Cash', NULL, '2023-05-29 12:08:12', '2023-05-29 12:08:12'),
(457, 'spr-20230529-030901', 1, NULL, 416, 15, 1, 35, NULL, 0, 'Cash', NULL, '2023-05-29 12:09:01', '2023-05-29 12:09:01'),
(458, 'spr-20230529-031242', 1, NULL, 417, 15, 1, 35, NULL, 0, 'Cash', NULL, '2023-05-29 12:12:42', '2023-05-29 12:12:42'),
(459, 'spr-20230529-031345', 1, NULL, 418, 15, 1, 35.91, NULL, 0, 'Cash', NULL, '2023-05-29 12:13:45', '2023-05-29 12:13:45'),
(460, 'spr-20230530-082134', 1, NULL, 419, 15, 1, 140, NULL, 0, 'Cash', NULL, '2023-05-30 05:21:34', '2023-05-30 05:21:34'),
(461, 'spr-20230530-083649', 1, NULL, 420, 16, 1, 245, NULL, 0, 'Cash', NULL, '2023-05-30 05:36:49', '2023-05-30 05:36:49'),
(462, 'spr-20230530-113630', 1, NULL, 421, 17, 1, 25, NULL, 0, 'Cash', NULL, '2023-05-30 08:36:30', '2023-05-30 08:36:30'),
(463, 'spr-20230530-113709', 1, NULL, 422, 17, 1, 12, NULL, 0, 'Cash', NULL, '2023-05-30 08:37:09', '2023-05-30 08:37:09'),
(464, 'spr-20230530-113851', 1, NULL, 423, 17, 1, 100, NULL, 0, 'Cash', NULL, '2023-05-30 08:38:51', '2023-05-30 08:38:51'),
(465, 'spr-20230530-115110', 1, NULL, 424, 17, 1, 119.7, NULL, 0, 'Cash', NULL, '2023-05-30 08:51:10', '2023-05-30 08:51:10'),
(466, 'spr-20230530-010939', 1, NULL, 425, 17, 1, 119.7, NULL, 0, 'Cash', NULL, '2023-05-30 10:09:39', '2023-05-30 10:09:39'),
(467, 'spr-20230530-012856', 1, NULL, 426, 17, 1, 53.58, NULL, 0, 'Cash', NULL, '2023-05-30 10:28:56', '2023-05-30 10:28:56'),
(468, 'spr-20230530-013155', 1, NULL, 427, 17, 1, 42.18, NULL, 0, 'Cash', NULL, '2023-05-30 10:31:55', '2023-05-30 10:31:55'),
(469, 'spr-20230530-013243', 1, NULL, 428, 17, 1, 57, NULL, 0, 'Cash', NULL, '2023-05-30 10:32:43', '2023-05-30 10:32:43'),
(470, 'spr-20230530-014202', 1, NULL, 429, 17, 1, 119.7, NULL, 0, 'Cash', NULL, '2023-05-30 10:42:02', '2023-05-30 10:42:02'),
(471, 'spr-20230530-014358', 1, NULL, 430, 17, 1, 39.9, NULL, 0, 'Cash', NULL, '2023-05-30 10:43:58', '2023-05-30 10:43:58'),
(472, 'spr-20230530-015331', 1, NULL, 431, 17, 1, 39.9, NULL, 0, 'Cash', NULL, '2023-05-30 10:53:31', '2023-05-30 10:53:31'),
(473, 'spr-20230530-020421', 1, NULL, 432, 17, 1, 39.9, NULL, 0, 'Cash', NULL, '2023-05-30 11:04:21', '2023-05-30 11:04:21'),
(474, 'spr-20230530-021308', 1, NULL, 433, 17, 1, 64.9, NULL, 0, 'Cash', NULL, '2023-05-30 11:13:08', '2023-05-30 11:13:08'),
(475, 'spr-20230530-024031', 1, NULL, 434, 17, 1, 74.9, NULL, 0, 'Cash', NULL, '2023-05-30 11:40:31', '2023-05-30 11:40:31'),
(476, 'spr-20230530-024212', 1, NULL, 435, 17, 1, 70, NULL, 0, 'Cash', NULL, '2023-05-30 11:42:12', '2023-05-30 11:42:12'),
(477, 'spr-20230531-074932', 1, NULL, 436, 17, 1, 35, NULL, 0, 'Cash', NULL, '2023-05-31 04:49:32', '2023-05-31 04:49:32'),
(478, 'spr-20230531-080928', 1, NULL, 437, 17, 1, 350, NULL, 0, 'Cash', NULL, '2023-05-31 05:09:28', '2023-05-31 05:09:28'),
(479, 'spr-20230531-080955', 1, NULL, 438, 17, 1, 105, NULL, 0, 'Cash', NULL, '2023-05-31 05:09:55', '2023-05-31 05:09:55'),
(480, 'spr-20230531-081353', 1, NULL, 439, 17, 1, 140, NULL, 0, 'Cash', NULL, '2023-05-31 05:13:53', '2023-05-31 05:13:53'),
(481, 'spr-20230531-082230', 1, NULL, 440, 17, 1, 70, NULL, 0, 'Cash', NULL, '2023-05-31 05:22:30', '2023-05-31 05:22:30'),
(482, 'spr-20230531-082403', 1, NULL, 441, 17, 1, 350, NULL, 0, 'Cash', NULL, '2023-05-31 05:24:03', '2023-05-31 05:24:03'),
(483, 'spr-20230531-082505', 1, NULL, 442, 17, 1, 144.9, NULL, 0, 'Cash', NULL, '2023-05-31 05:25:05', '2023-05-31 05:25:05'),
(484, 'spr-20230531-090020', 1, NULL, 443, 17, 1, 109.9, NULL, 0, 'Cash', NULL, '2023-05-31 06:00:20', '2023-05-31 06:00:20'),
(485, 'spr-20230531-092709', 1, NULL, 444, 17, 1, 109.9, NULL, 0, 'Cash', NULL, '2023-05-31 06:27:09', '2023-05-31 06:27:09'),
(486, 'spr-20230531-103121', 1, NULL, 445, 17, 1, 70, NULL, 0, 'Cash', NULL, '2023-05-31 07:31:21', '2023-05-31 07:31:21'),
(487, 'spr-20230531-104347', 1, NULL, 446, NULL, 1, 70, NULL, 0, 'Cash', NULL, '2023-05-31 07:43:47', '2023-05-31 07:43:47'),
(488, 'spr-20230531-104827', 1, NULL, 447, 18, 1, 74.9, NULL, 0, 'Cash', NULL, '2023-05-31 07:48:27', '2023-05-31 07:48:27'),
(489, 'spr-20230531-105500', 1, NULL, 448, 18, 1, 74.9, NULL, 0, 'Cash', NULL, '2023-05-31 07:55:00', '2023-05-31 07:55:00'),
(490, 'spr-20230531-110202', 1, NULL, 449, 18, 1, 184.8, NULL, 0, 'Cash', NULL, '2023-05-31 08:02:02', '2023-05-31 08:02:02'),
(491, 'spr-20230531-110546', 1, NULL, 450, 18, 1, 271.9, NULL, 0, 'Cash', NULL, '2023-05-31 08:05:46', '2023-05-31 08:05:46'),
(492, 'spr-20230531-111212', 1, NULL, 451, 18, 1, 35, NULL, 0, 'Cash', NULL, '2023-05-31 08:12:12', '2023-05-31 08:12:12'),
(493, 'spr-20230531-114856', 1, NULL, 452, 18, 1, 74.9, NULL, 0, 'Cash', NULL, '2023-05-31 08:48:56', '2023-05-31 08:48:56'),
(494, 'spr-20230601-084527', 1, NULL, 453, 18, 1, 40.25, NULL, 0, 'Cash', NULL, '2023-06-01 05:45:27', '2023-06-01 05:45:27'),
(495, 'spr-20230601-084611', 1, NULL, 454, 18, 1, 35, NULL, 0, 'Cash', NULL, '2023-06-01 05:46:11', '2023-06-01 05:46:11'),
(496, 'spr-20230601-085341', 1, NULL, 455, 18, 1, 35, NULL, 0, 'Cash', NULL, '2023-06-01 05:53:41', '2023-06-01 05:53:41'),
(497, 'spr-20230601-085348', 1, NULL, 456, 18, 1, 35, NULL, 0, 'Cash', NULL, '2023-06-01 05:53:48', '2023-06-01 05:53:48');

-- --------------------------------------------------------

--
-- Table structure for table `payment_with_cheque`
--

DROP TABLE IF EXISTS `payment_with_cheque`;
CREATE TABLE IF NOT EXISTS `payment_with_cheque` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `payment_id` int NOT NULL,
  `cheque_no` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `payment_with_credit_card`
--

DROP TABLE IF EXISTS `payment_with_credit_card`;
CREATE TABLE IF NOT EXISTS `payment_with_credit_card` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `payment_id` int NOT NULL,
  `customer_id` int DEFAULT NULL,
  `customer_stripe_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `charge_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `payment_with_credit_card`
--

INSERT INTO `payment_with_credit_card` (`id`, `payment_id`, `customer_id`, `customer_stripe_id`, `charge_id`, `created_at`, `updated_at`) VALUES
(1, 372, 2, NULL, NULL, '2023-03-14 13:04:15', '2023-04-12 13:04:17'),
(2, 373, 2, NULL, NULL, '2023-03-14 13:04:42', '2023-04-12 13:04:44'),
(3, 378, 2, NULL, NULL, '2023-03-14 07:24:12', '2023-05-02 07:24:15'),
(4, 379, 2, NULL, NULL, '2023-03-14 07:26:34', '2023-05-02 07:26:36'),
(5, 380, 2, NULL, NULL, '2023-03-14 12:18:43', '2023-05-02 11:18:45'),
(6, 420, 2, NULL, NULL, '2023-03-14 11:19:51', '2023-05-09 10:19:53');

-- --------------------------------------------------------

--
-- Table structure for table `payment_with_gift_card`
--

DROP TABLE IF EXISTS `payment_with_gift_card`;
CREATE TABLE IF NOT EXISTS `payment_with_gift_card` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `payment_id` int NOT NULL,
  `gift_card_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `payment_with_paypal`
--

DROP TABLE IF EXISTS `payment_with_paypal`;
CREATE TABLE IF NOT EXISTS `payment_with_paypal` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `payment_id` int NOT NULL,
  `transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `payrolls`
--

DROP TABLE IF EXISTS `payrolls`;
CREATE TABLE IF NOT EXISTS `payrolls` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `employee_id` int NOT NULL,
  `account_id` int NOT NULL,
  `user_id` int NOT NULL,
  `amount` double NOT NULL,
  `paying_method` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `permissions`
--

DROP TABLE IF EXISTS `permissions`;
CREATE TABLE IF NOT EXISTS `permissions` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=109 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `permissions`
--

INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
(4, 'products-edit', 'web', '2018-06-03 01:00:09', '2018-06-03 01:00:09'),
(5, 'products-delete', 'web', '2018-06-03 22:54:22', '2018-06-03 22:54:22'),
(6, 'products-add', 'web', '2018-06-04 00:34:14', '2018-06-04 00:34:14'),
(7, 'products-index', 'web', '2018-06-04 03:34:27', '2018-06-04 03:34:27'),
(8, 'purchases-index', 'web', '2018-06-04 08:03:19', '2018-06-04 08:03:19'),
(9, 'purchases-add', 'web', '2018-06-04 08:12:25', '2018-06-04 08:12:25'),
(10, 'purchases-edit', 'web', '2018-06-04 09:47:36', '2018-06-04 09:47:36'),
(11, 'purchases-delete', 'web', '2018-06-04 09:47:36', '2018-06-04 09:47:36'),
(12, 'sales-index', 'web', '2018-06-04 10:49:08', '2018-06-04 10:49:08'),
(13, 'sales-add', 'web', '2018-06-04 10:49:52', '2018-06-04 10:49:52'),
(14, 'sales-edit', 'web', '2018-06-04 10:49:52', '2018-06-04 10:49:52'),
(15, 'sales-delete', 'web', '2018-06-04 10:49:53', '2018-06-04 10:49:53'),
(16, 'quotes-index', 'web', '2018-06-04 22:05:10', '2018-06-04 22:05:10'),
(17, 'quotes-add', 'web', '2018-06-04 22:05:10', '2018-06-04 22:05:10'),
(18, 'quotes-edit', 'web', '2018-06-04 22:05:10', '2018-06-04 22:05:10'),
(19, 'quotes-delete', 'web', '2018-06-04 22:05:10', '2018-06-04 22:05:10'),
(20, 'transfers-index', 'web', '2018-06-04 22:30:03', '2018-06-04 22:30:03'),
(21, 'transfers-add', 'web', '2018-06-04 22:30:03', '2018-06-04 22:30:03'),
(22, 'transfers-edit', 'web', '2018-06-04 22:30:03', '2018-06-04 22:30:03'),
(23, 'transfers-delete', 'web', '2018-06-04 22:30:03', '2018-06-04 22:30:03'),
(24, 'returns-index', 'web', '2018-06-04 22:50:24', '2018-06-04 22:50:24'),
(25, 'returns-add', 'web', '2018-06-04 22:50:24', '2018-06-04 22:50:24'),
(26, 'returns-edit', 'web', '2018-06-04 22:50:25', '2018-06-04 22:50:25'),
(27, 'returns-delete', 'web', '2018-06-04 22:50:25', '2018-06-04 22:50:25'),
(28, 'customers-index', 'web', '2018-06-04 23:15:54', '2018-06-04 23:15:54'),
(29, 'customers-add', 'web', '2018-06-04 23:15:55', '2018-06-04 23:15:55'),
(30, 'customers-edit', 'web', '2018-06-04 23:15:55', '2018-06-04 23:15:55'),
(31, 'customers-delete', 'web', '2018-06-04 23:15:55', '2018-06-04 23:15:55'),
(32, 'suppliers-index', 'web', '2018-06-04 23:40:12', '2018-06-04 23:40:12'),
(33, 'suppliers-add', 'web', '2018-06-04 23:40:12', '2018-06-04 23:40:12'),
(34, 'suppliers-edit', 'web', '2018-06-04 23:40:12', '2018-06-04 23:40:12'),
(35, 'suppliers-delete', 'web', '2018-06-04 23:40:12', '2018-06-04 23:40:12'),
(36, 'product-report', 'web', '2018-06-24 23:05:33', '2018-06-24 23:05:33'),
(37, 'purchase-report', 'web', '2018-06-24 23:24:56', '2018-06-24 23:24:56'),
(38, 'sale-report', 'web', '2018-06-24 23:33:13', '2018-06-24 23:33:13'),
(39, 'customer-report', 'web', '2018-06-24 23:36:51', '2018-06-24 23:36:51'),
(40, 'due-report', 'web', '2018-06-24 23:39:52', '2018-06-24 23:39:52'),
(41, 'users-index', 'web', '2018-06-25 00:00:10', '2018-06-25 00:00:10'),
(42, 'users-add', 'web', '2018-06-25 00:00:10', '2018-06-25 00:00:10'),
(43, 'users-edit', 'web', '2018-06-25 00:01:30', '2018-06-25 00:01:30'),
(44, 'users-delete', 'web', '2018-06-25 00:01:30', '2018-06-25 00:01:30'),
(45, 'profit-loss', 'web', '2018-07-14 21:50:05', '2018-07-14 21:50:05'),
(46, 'best-seller', 'web', '2018-07-14 22:01:38', '2018-07-14 22:01:38'),
(47, 'daily-sale', 'web', '2018-07-14 22:24:21', '2018-07-14 22:24:21'),
(48, 'monthly-sale', 'web', '2018-07-14 22:30:41', '2018-07-14 22:30:41'),
(49, 'daily-purchase', 'web', '2018-07-14 22:36:46', '2018-07-14 22:36:46'),
(50, 'monthly-purchase', 'web', '2018-07-14 22:48:17', '2018-07-14 22:48:17'),
(51, 'payment-report', 'web', '2018-07-14 23:10:41', '2018-07-14 23:10:41'),
(52, 'warehouse-stock-report', 'web', '2018-07-14 23:16:55', '2018-07-14 23:16:55'),
(53, 'product-qty-alert', 'web', '2018-07-14 23:33:21', '2018-07-14 23:33:21'),
(54, 'supplier-report', 'web', '2018-07-30 03:00:01', '2018-07-30 03:00:01'),
(55, 'expenses-index', 'web', '2018-09-05 01:07:10', '2018-09-05 01:07:10'),
(56, 'expenses-add', 'web', '2018-09-05 01:07:10', '2018-09-05 01:07:10'),
(57, 'expenses-edit', 'web', '2018-09-05 01:07:10', '2018-09-05 01:07:10'),
(58, 'expenses-delete', 'web', '2018-09-05 01:07:11', '2018-09-05 01:07:11'),
(59, 'general_setting', 'web', '2018-10-19 23:10:04', '2018-10-19 23:10:04'),
(60, 'mail_setting', 'web', '2018-10-19 23:10:04', '2018-10-19 23:10:04'),
(61, 'pos_setting', 'web', '2018-10-19 23:10:04', '2018-10-19 23:10:04'),
(62, 'hrm_setting', 'web', '2019-01-02 10:30:23', '2019-01-02 10:30:23'),
(63, 'purchase-return-index', 'web', '2019-01-02 21:45:14', '2019-01-02 21:45:14'),
(64, 'purchase-return-add', 'web', '2019-01-02 21:45:14', '2019-01-02 21:45:14'),
(65, 'purchase-return-edit', 'web', '2019-01-02 21:45:14', '2019-01-02 21:45:14'),
(66, 'purchase-return-delete', 'web', '2019-01-02 21:45:14', '2019-01-02 21:45:14'),
(67, 'account-index', 'web', '2019-01-02 22:06:13', '2019-01-02 22:06:13'),
(68, 'balance-sheet', 'web', '2019-01-02 22:06:14', '2019-01-02 22:06:14'),
(69, 'account-statement', 'web', '2019-01-02 22:06:14', '2019-01-02 22:06:14'),
(70, 'department', 'web', '2019-01-02 22:30:01', '2019-01-02 22:30:01'),
(71, 'attendance', 'web', '2019-01-02 22:30:01', '2019-01-02 22:30:01'),
(72, 'payroll', 'web', '2019-01-02 22:30:01', '2019-01-02 22:30:01'),
(73, 'employees-index', 'web', '2019-01-02 22:52:19', '2019-01-02 22:52:19'),
(74, 'employees-add', 'web', '2019-01-02 22:52:19', '2019-01-02 22:52:19'),
(75, 'employees-edit', 'web', '2019-01-02 22:52:19', '2019-01-02 22:52:19'),
(76, 'employees-delete', 'web', '2019-01-02 22:52:19', '2019-01-02 22:52:19'),
(77, 'user-report', 'web', '2019-01-16 06:48:18', '2019-01-16 06:48:18'),
(78, 'stock_count', 'web', '2019-02-17 10:32:01', '2019-02-17 10:32:01'),
(79, 'adjustment', 'web', '2019-02-17 10:32:02', '2019-02-17 10:32:02'),
(80, 'sms_setting', 'web', '2019-02-22 05:18:03', '2019-02-22 05:18:03'),
(81, 'create_sms', 'web', '2019-02-22 05:18:03', '2019-02-22 05:18:03'),
(82, 'print_barcode', 'web', '2019-03-07 05:02:19', '2019-03-07 05:02:19'),
(83, 'empty_database', 'web', '2019-03-07 05:02:19', '2019-03-07 05:02:19'),
(84, 'customer_group', 'web', '2019-03-07 05:37:15', '2019-03-07 05:37:15'),
(85, 'unit', 'web', '2019-03-07 05:37:15', '2019-03-07 05:37:15'),
(86, 'tax', 'web', '2019-03-07 05:37:15', '2019-03-07 05:37:15'),
(87, 'gift_card', 'web', '2019-03-07 06:29:38', '2019-03-07 06:29:38'),
(88, 'coupon', 'web', '2019-03-07 06:29:38', '2019-03-07 06:29:38'),
(89, 'holiday', 'web', '2019-10-19 08:57:15', '2019-10-19 08:57:15'),
(90, 'warehouse-report', 'web', '2019-10-22 06:00:23', '2019-10-22 06:00:23'),
(91, 'warehouse', 'web', '2020-02-26 06:47:32', '2020-02-26 06:47:32'),
(92, 'brand', 'web', '2020-02-26 06:59:59', '2020-02-26 06:59:59'),
(93, 'billers-index', 'web', '2020-02-26 07:11:15', '2020-02-26 07:11:15'),
(94, 'billers-add', 'web', '2020-02-26 07:11:15', '2020-02-26 07:11:15'),
(95, 'billers-edit', 'web', '2020-02-26 07:11:15', '2020-02-26 07:11:15'),
(96, 'billers-delete', 'web', '2020-02-26 07:11:15', '2020-02-26 07:11:15'),
(97, 'money-transfer', 'web', '2020-03-02 05:41:48', '2020-03-02 05:41:48'),
(98, 'category', 'web', '2020-07-13 12:13:16', '2020-07-13 12:13:16'),
(99, 'delivery', 'web', '2020-07-13 12:13:16', '2020-07-13 12:13:16'),
(100, 'send_notification', 'web', '2020-10-31 06:21:31', '2020-10-31 06:21:31'),
(101, 'today_sale', 'web', '2020-10-31 06:57:04', '2020-10-31 06:57:04'),
(102, 'today_profit', 'web', '2020-10-31 06:57:04', '2020-10-31 06:57:04'),
(103, 'currency', 'web', '2020-11-09 00:23:11', '2020-11-09 00:23:11'),
(104, 'backup_database', 'web', '2020-11-15 00:16:55', '2020-11-15 00:16:55'),
(105, 'reward_point_setting', 'web', '2021-06-27 04:34:42', '2021-06-27 04:34:42'),
(106, 'makeUnits', 'web', '2018-06-03 01:00:09', '2018-06-03 01:00:09'),
(107, 'makeOrder', 'web', '2018-06-03 22:54:22', '2018-06-03 22:54:22'),
(108, 'productionLine', 'web', '2018-06-04 00:34:14', '2018-06-04 00:34:14');

-- --------------------------------------------------------

--
-- Table structure for table `pos_setting`
--

DROP TABLE IF EXISTS `pos_setting`;
CREATE TABLE IF NOT EXISTS `pos_setting` (
  `id` int NOT NULL,
  `customer_id` int NOT NULL,
  `warehouse_id` int NOT NULL,
  `biller_id` int NOT NULL,
  `product_number` int NOT NULL,
  `keybord_active` tinyint(1) NOT NULL,
  `stripe_public_key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stripe_secret_key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  UNIQUE KEY `pos_setting_id_unique` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `pos_setting`
--

INSERT INTO `pos_setting` (`id`, `customer_id`, `warehouse_id`, `biller_id`, `product_number`, `keybord_active`, `stripe_public_key`, `stripe_secret_key`, `created_at`, `updated_at`) VALUES
(1, 2, 3, 10, 5, 0, 'pk_test_ITN7KOYiIsHSCQ0UMRcgaYUB', 'sk_test_TtQQaawhEYRwa3mU9CzttrEy', '2018-09-02 03:17:04', '2022-09-17 13:29:45');

-- --------------------------------------------------------

--
-- Table structure for table `production_units`
--

DROP TABLE IF EXISTS `production_units`;
CREATE TABLE IF NOT EXISTS `production_units` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `product_id` bigint UNSIGNED DEFAULT NULL,
  `manufacturing_order_id` bigint UNSIGNED DEFAULT NULL,
  `warehouse_id` bigint UNSIGNED DEFAULT NULL,
  `is_active` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT '1',
  `notes` text COLLATE utf8mb4_unicode_ci,
  `amount` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT '1',
  `waste` double DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `production_units`
--

INSERT INTO `production_units` (`id`, `product_id`, `manufacturing_order_id`, `warehouse_id`, `is_active`, `notes`, `amount`, `waste`, `created_at`, `updated_at`) VALUES
(1, 285, 1, 1, '1', NULL, '5', 0, '2022-01-31 15:59:52', '2022-01-31 15:59:52');

-- --------------------------------------------------------

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
CREATE TABLE IF NOT EXISTS `products` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `barcode_symbology` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `brand_id` int DEFAULT NULL,
  `category_id` int NOT NULL,
  `unit_id` int NOT NULL,
  `purchase_unit_id` int NOT NULL,
  `sale_unit_id` int NOT NULL,
  `cost` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `qty` double DEFAULT NULL,
  `alert_quantity` double DEFAULT NULL,
  `promotion` tinyint DEFAULT NULL,
  `promotion_price` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `starting_date` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_date` date DEFAULT NULL,
  `tax_id` int DEFAULT NULL,
  `tax_method` int DEFAULT NULL,
  `image` longtext COLLATE utf8mb4_unicode_ci,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_variant` tinyint(1) DEFAULT NULL,
  `is_batch` tinyint(1) DEFAULT NULL,
  `is_diffPrice` tinyint(1) DEFAULT NULL,
  `is_imei` tinyint(1) DEFAULT NULL,
  `featured` tinyint DEFAULT NULL,
  `product_list` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `variant_list` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty_list` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price_list` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_details` text COLLATE utf8mb4_unicode_ci,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=119 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `products`
--

INSERT INTO `products` (`id`, `name`, `code`, `type`, `barcode_symbology`, `brand_id`, `category_id`, `unit_id`, `purchase_unit_id`, `sale_unit_id`, `cost`, `price`, `qty`, `alert_quantity`, `promotion`, `promotion_price`, `starting_date`, `last_date`, `tax_id`, `tax_method`, `image`, `file`, `is_variant`, `is_batch`, `is_diffPrice`, `is_imei`, `featured`, `product_list`, `variant_list`, `qty_list`, `price_list`, `product_details`, `is_active`, `created_at`, `updated_at`) VALUES
(20, 'Water', '6223001930549', 'standard', 'C128', 2, 2, 6, 6, 6, '2.50', '10', 1, 24, NULL, NULL, NULL, NULL, 1, 2, '1659958416643Capture.JPG', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 0, '2022-08-08 13:33:27', '2023-03-14 09:36:25'),
(21, 'Juice', '6222014330513', 'standard', 'C128', 3, 2, 6, 6, 6, '3.95', '10', 1, 24, NULL, NULL, NULL, NULL, 1, 2, '1659959264038Captdure.JPG', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 0, '2022-08-08 13:47:10', '2023-03-14 09:36:25'),
(22, 'NUTELLA AND GO', '9800800056', 'standard', 'C128', NULL, 1, 6, 6, 6, '1', '1', 1, NULL, NULL, NULL, NULL, NULL, 1, 1, '1660915306497nutella.jpg', NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '', 0, '2022-08-19 15:21:21', '2023-05-30 07:35:46'),
(23, 'KIT KAT 4 FINGER WHITE', '40057750', 'standard', 'C128', NULL, 1, 6, 6, 6, '1', '1', 1, NULL, NULL, NULL, NULL, NULL, 1, 1, '1660916907974kit-kat-white-nestle-415-gr.jpg', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 0, '2022-08-19 15:24:10', '2023-05-30 07:35:46'),
(24, 'KIT KAT 4 FINGER DARK', '40057767', 'standard', 'C128', NULL, 1, 6, 6, 6, '1', '1', 1, NULL, NULL, NULL, NULL, NULL, 1, 1, '1660915636431nestle-kitkat-dark-nestle.jpg', NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '', 0, '2022-08-19 15:26:51', '2023-05-30 07:35:46'),
(25, 'KINDER MAXI T', '40084077', 'standard', 'C128', NULL, 1, 6, 6, 6, '1', '1', 1, NULL, NULL, NULL, NULL, NULL, 1, 1, '1660917006201image.jpg', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 0, '2022-08-19 15:28:45', '2023-05-30 07:35:46'),
(26, 'KINDER SURPRISE', '40084107', 'standard', 'C128', NULL, 1, 6, 6, 6, '15.45', '30', 1, NULL, NULL, NULL, NULL, NULL, 1, 1, '1660915877218front_xx.74.full.jpg', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 0, '2022-08-19 15:30:54', '2023-05-30 07:35:46'),
(27, 'BOUNTY CHOCOLATE', '40111216', 'standard', 'C128', NULL, 1, 3, 3, 3, '16.19', '35', 46, 12, NULL, NULL, NULL, NULL, 1, 2, '1660916002253large-40111216.jpg', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-08-19 15:32:56', '2023-06-01 05:53:48'),
(28, 'M And M PEANUT', '40111445', 'standard', 'C128', NULL, 1, 6, 6, 6, '18.82', '35', 80, NULL, NULL, NULL, NULL, NULL, 1, 1, '1660916123668front_en.119.full.jpg', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-08-19 15:34:57', '2023-05-31 08:53:02'),
(29, 'M And M CHOCOLATE', '40111490', 'standard', 'C128', NULL, 1, 6, 6, 6, '21.45', '35', 1, NULL, NULL, NULL, NULL, NULL, 1, 2, '1660916337567MMs-Choco-Single-45g-40111490.jpg', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-08-19 15:36:17', '2023-05-30 07:35:46'),
(30, 'MALTESERS', '5000159020312', 'standard', 'C128', NULL, 1, 6, 6, 6, '16.51', '35', 1, NULL, NULL, NULL, NULL, NULL, 1, 2, '1660916569694images.jpg', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-08-19 15:42:24', '2023-05-30 07:35:46'),
(31, 'MARS CHOCOLATE', '5000159407236', 'standard', 'C128', NULL, 1, 6, 6, 6, '21.01', '35', 1, NULL, NULL, NULL, NULL, NULL, 1, 2, '1660916653350front_fr.78.full.jpg', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-08-19 15:43:47', '2023-05-30 07:35:46'),
(32, 'SNICKERS', '5000159461122', 'standard', 'C128', NULL, 1, 6, 6, 6, '18.95', '35', 1, NULL, NULL, NULL, NULL, NULL, 1, 2, '16609167275625000159461122-515Wx515H.png', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-08-19 15:45:01', '2023-05-30 07:35:46'),
(33, 'MC VITIES SHORTCAKE', '5000168104621', 'standard', 'C128', NULL, 1, 6, 6, 6, '1', '1', 1, NULL, NULL, NULL, NULL, NULL, 1, 1, '16609168057985000168104621.jpg', NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '', 0, '2022-08-19 15:46:19', '2023-05-30 07:35:46'),
(34, 'Pringles Sour Cream And Onion 130gm', '5050083943652', 'standard', 'C128', NULL, 1, 6, 6, 6, '16.95', '35', 1, NULL, NULL, NULL, NULL, NULL, 1, 1, '1661181829546Pringles Sour Cream & Onion 130gm.jpg', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 0, '2022-08-22 16:21:03', '2023-05-30 07:35:46'),
(35, 'Pringles Original 130 gm', '5050083943645', 'standard', 'C128', NULL, 1, 6, 6, 6, '16.95', '35', 1, NULL, NULL, NULL, NULL, NULL, 1, 1, '1661180103740Pringles Original 130 gm.jpg', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 0, '2022-08-22 16:55:04', '2023-05-30 07:35:46'),
(36, 'Pringles Barbeque 40gm', '5053990107278', 'standard', 'C128', NULL, 1, 6, 6, 6, '1.00', '1', 1, NULL, NULL, NULL, NULL, NULL, 1, 1, '1661180244093Pringles Barbeque 40gm.jpg', NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '', 0, '2022-08-22 16:57:01', '2023-05-30 07:35:46'),
(37, 'Pringles Hot And Spicy 40gm', '5053990107292', 'standard', 'C128', NULL, 1, 6, 6, 6, '1', '1', 1, NULL, NULL, NULL, NULL, NULL, 1, 1, '1661180546138Pringles Hot & Spicy 40gm 3.jpg', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 0, '2022-08-22 16:59:16', '2023-05-30 07:35:46'),
(38, 'Pringles Paprika 40gm', '5053990107308', 'standard', 'C128', NULL, 1, 6, 6, 6, '1', '1', 1, NULL, NULL, NULL, NULL, NULL, 1, 1, '1661180820386Pringles Paprika 40gm.jpg', NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '', 0, '2022-08-22 17:06:41', '2023-05-30 07:35:46'),
(39, 'Pringles Original 40gm', '5053990107339', 'standard', 'C128', NULL, 1, 6, 6, 6, '1', '1', 1, NULL, NULL, NULL, NULL, NULL, 1, 1, '1661180895401Pringles Original 40gm.jpg', NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '', 0, '2022-08-22 17:08:11', '2023-05-30 07:35:46'),
(40, 'Pringle Salt And Vinegar 40gm', '5053990107353', 'standard', 'C128', NULL, 1, 6, 6, 6, '1', '1', 1, NULL, NULL, NULL, NULL, NULL, 1, 1, '1661181044883Pringle Salt & Vinegar 40gm 2.jpg', NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '', 0, '2022-08-22 17:10:32', '2023-05-30 07:35:46'),
(41, 'Pringles Sour Cream And Onion 40gm', '5053990107384', 'standard', 'C128', NULL, 1, 6, 6, 6, '1', '1', 1, NULL, NULL, NULL, NULL, NULL, 1, 1, '1661181166464Pringles Sour Cream & Onion 130gm.jpeg', NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '', 0, '2022-08-22 17:12:32', '2023-05-30 07:35:46'),
(42, 'Pringles Paprika 130gm', '5053990113118', 'standard', 'C128', NULL, 1, 6, 6, 6, '1', '1', 1, NULL, NULL, NULL, NULL, NULL, 1, 1, '1661181239795Pringles Paprika 130gm.jpg', NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '', 0, '2022-08-22 17:13:40', '2023-05-30 07:35:46'),
(43, 'Pringles Hot And Spicy 130gm', '5053990137565', 'standard', 'C128', NULL, 1, 6, 6, 6, '1', '1', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, '1661181316847Pringles Hot & Spicy 130gm.png', NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '', 0, '2022-08-22 17:14:55', '2023-05-30 07:35:46'),
(44, 'Cadbury Dairy Milk 90gm', '6221021197003', 'standard', 'C128', NULL, 1, 6, 6, 6, '12.95', '20', 1, NULL, NULL, NULL, NULL, NULL, 1, 1, '1661181377370Cadbury_Dairy_Milk1.jpg', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 0, '2022-08-22 17:16:14', '2023-05-30 07:35:46'),
(45, 'M And M Crispy', '5000159304245', 'standard', 'C128', NULL, 1, 3, 3, 3, '21.45', '35', 1, 12, NULL, NULL, NULL, NULL, NULL, 2, '1663316096583mandm.JPG', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-09-16 10:15:14', '2023-05-30 07:35:46'),
(46, 'Kinder Joy Girls', '80768258', 'standard', 'C128', NULL, 1, 3, 3, 3, '18.95', '35', 1, 5, NULL, NULL, NULL, NULL, 1, 2, '1663316212655كيندر-جوي-للبنات-20-غم.jpg', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-09-16 10:16:52', '2023-05-30 07:35:46'),
(47, 'Kinder Joy Boys', '80974482', 'standard', 'C128', NULL, 1, 3, 3, 3, '18.95', '35', 1, 5, NULL, NULL, NULL, NULL, 1, 2, '1663316264400كيندرجوي بنين.jpg', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-09-16 10:17:44', '2023-05-30 07:35:46'),
(48, 'Cadbury dairy milk', '7622210609915', 'standard', 'C128', NULL, 1, 3, 3, 3, '13.95', '25', 1, NULL, NULL, NULL, NULL, NULL, 1, 2, '1663316316038cad.jpg', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-09-16 10:18:39', '2023-05-30 07:35:46'),
(49, 'Cadbury Marvellous', '7622210327826', 'standard', 'C128', NULL, 1, 3, 3, 3, '13.95', '25', 2, 5, NULL, NULL, NULL, NULL, 1, 2, '1663316541990Cad MACapture.JPG', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-09-16 10:22:22', '2023-05-31 08:52:47'),
(50, 'Cadbury Bubbly', '7622210077660', 'standard', 'C128', NULL, 1, 3, 3, 3, '6.14', '25', 1, 5, NULL, NULL, NULL, NULL, 1, 2, '1663316703675bably.JPG', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-09-16 10:25:03', '2023-05-30 07:35:46'),
(51, 'Cadbury Oreo', '7622210625038', 'standard', 'C128', NULL, 1, 3, 3, 3, '13.95', '25', 1, 5, NULL, NULL, NULL, NULL, 1, 2, '1663317181175Oreo.JPG', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-09-16 10:33:00', '2023-05-30 07:35:47'),
(52, 'Kitkat 4 Fingers', '6294003532987', 'standard', 'C128', NULL, 1, 3, 3, 3, '13.95', '25', 1, 5, NULL, NULL, NULL, NULL, 1, 2, '1663317388629kit.JPG', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-09-16 10:36:28', '2023-05-30 07:35:47'),
(53, 'Kitkat Chunky', '6294003582678', 'standard', 'C128', NULL, 1, 3, 3, 3, '14.45', '25', 1, 5, NULL, NULL, NULL, NULL, 1, 2, '1663317534644chan.JPG', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-09-16 10:38:56', '2023-05-30 07:35:47'),
(54, 'Kinder Bueno', '80052760', 'standard', 'C128', NULL, 1, 3, 3, 3, '15.25', '25', 1, 5, NULL, NULL, NULL, NULL, 1, 2, '1663317729996kinderbun.JPG', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-09-16 10:42:18', '2023-05-30 07:35:47'),
(55, 'Twix', '5000159462594', 'standard', 'C128', NULL, 1, 3, 3, 3, '11.40', '25', 1, 5, NULL, NULL, NULL, NULL, 1, 2, '1663317894436twixL.jpg', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-09-16 10:44:55', '2023-05-30 07:35:47'),
(56, 'Oreo Choco Coated', '7622201699277', 'standard', 'C128', NULL, 1, 3, 3, 3, '6.5', '10', 1, 5, NULL, NULL, NULL, NULL, 1, 2, '1663318185061co.JPG', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-09-16 10:49:45', '2023-05-30 07:35:47'),
(57, 'Galaxy Smooth Milk', '6221134004922', 'standard', 'C128', NULL, 1, 3, 3, 3, '12.24', '24', 1, 5, NULL, NULL, NULL, NULL, 1, 2, '1663318493840gla.JPG', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-09-16 10:54:55', '2023-05-30 07:35:47'),
(58, 'Soft Drink', '6223001360063', 'standard', 'C128', NULL, 1, 3, 3, 3, '4.39', '15', 1, 5, NULL, NULL, NULL, NULL, 1, 2, '1663318637303pipsi.jpg', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-09-16 10:57:43', '2023-05-30 07:35:47'),
(59, 'Juhayna Juice', '6222014330537', 'standard', 'C128', NULL, 1, 3, 3, 3, '4.61', '10', 1, 5, NULL, NULL, NULL, NULL, 1, 2, '1663318893023ju.JPG', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-09-16 11:01:33', '2023-05-30 07:35:47'),
(60, 'Nestle Pure Water', '6223001930549', 'standard', 'C128', NULL, 1, 3, 3, 3, '2.31', '10', 1, 5, NULL, NULL, NULL, NULL, 1, 2, '1663318969325water.JPG', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-09-16 11:02:48', '2023-05-30 07:35:47'),
(61, 'Poplay Popcorn Caramel And Chocolate', '6224009598039', 'standard', 'C128', NULL, 1, 3, 3, 3, '17.54', '30', 1, 5, NULL, NULL, NULL, NULL, 1, 2, '16642092306956224009598039.JPG', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-09-26 18:20:42', '2023-05-30 07:35:47'),
(62, 'Poplay Popcorn Caramel And Cinnamon', '6224009598113', 'standard', 'C128', NULL, 1, 3, 3, 3, '17.54', '30', 1, 5, NULL, NULL, NULL, NULL, 1, 2, '16642093394796224009598113.JPG', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-09-26 18:22:30', '2023-05-30 07:35:47'),
(63, 'Poplay Popcorn Saled Caramel', '6224009598014', 'standard', 'C128', NULL, 1, 3, 3, 3, '17.54', '30', 1, 5, NULL, NULL, NULL, NULL, 1, 2, '16642094292766224009598014.JPG', NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-09-26 18:23:59', '2023-05-30 07:35:47'),
(64, 'Poplay Popcorn Caramel And Almond', '6224009598076', 'standard', 'C128', NULL, 1, 3, 3, 3, '21.93', '30', 1, 5, NULL, NULL, NULL, NULL, 1, 2, '16642095414966224009598076.JPG', NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-09-26 18:25:51', '2023-05-30 07:35:47'),
(65, 'PopCorn', '1000000800', 'standard', 'C128', NULL, 1, 3, 3, 3, '8.77', '20', 1, 20, NULL, NULL, NULL, NULL, 1, 2, '1665245417299how-to-make-popcorn.jpg', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-10-08 18:11:16', '2023-05-30 07:35:47'),
(66, 'Granita', '1000000900', 'standard', 'C128', NULL, 1, 1, 1, 1, '15', '25', 1, NULL, NULL, NULL, NULL, NULL, 1, 1, '1665245750478granités.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2022-10-08 18:15:56', '2023-05-30 07:35:47'),
(67, 'Chipsy Kebab', '622133300121', 'standard', 'C128', 1, 1, 6, 6, 6, '5.26', '10', 1, 4, NULL, NULL, NULL, NULL, 1, 2, '167101648622141gk1VJ5rWL._AC_SY1000_.jpg', NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-12-14 13:16:04', '2023-05-30 07:35:47'),
(68, 'Chipsy Gabna', '6221333000022', 'standard', 'C128', 1, 1, 6, 6, 6, '4.61', '10', 1, 4, NULL, NULL, NULL, NULL, 1, 2, '16710167181139997770034_3.jpg', NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-12-14 13:18:58', '2023-05-30 07:35:47'),
(69, 'Chipsy Gabna Motabla', '6221333000145', 'standard', 'C128', 1, 1, 6, 6, 6, '4.04', '10', 1, 4, NULL, NULL, NULL, NULL, 1, 2, '1671016781461IUXnSV0H2MUWUUq6J4zgUqYnDGTkjPJcnLylt64r.jpeg', NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-12-14 13:19:51', '2023-05-30 07:35:47'),
(70, 'Chipsy Tomato', '6221333000084', 'standard', 'C128', 1, 1, 6, 6, 6, '4.61', '10', 1, 4, NULL, NULL, NULL, NULL, 1, 2, '1671017606147ghjgh.jpg', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-12-14 13:20:57', '2023-05-30 07:35:47'),
(71, 'Chipsy Chill and Lemon', '622133300107', 'standard', 'C128', 1, 1, 6, 6, 6, '4.61', '10', 1, 4, NULL, NULL, NULL, NULL, 1, 2, '167101701887641zIjiHzDrL.jpg', NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-12-14 13:23:55', '2023-05-30 07:35:47'),
(72, 'Mythic Chocolate Mlik', '6194005449422', 'standard', 'C128', NULL, 1, 6, 6, 6, '7.46', '15', 1, 3, NULL, NULL, NULL, NULL, 1, 2, '1672073703546126.JPG', NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-12-26 18:55:28', '2023-05-30 07:35:47'),
(73, 'Mythic Chocolate Hazelnuts', '6194005449439', 'standard', 'C128', NULL, 1, 6, 6, 6, '7.46', '15', 1, 5, NULL, NULL, NULL, NULL, 1, 2, '1672073795967127.JPG', NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-12-26 18:57:00', '2023-05-30 07:35:47'),
(74, 'CADBURY DAIRY MILK HAZEL NUT 35G', '7622201510633', 'standard', 'C128', NULL, 1, 6, 6, 6, '21.93', '25', 1, NULL, NULL, NULL, NULL, NULL, 1, 2, '1672340304415128.JPG', NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2022-12-29 20:58:57', '2023-05-30 07:35:47'),
(75, 'koshary', '93123498', 'service', 'C128', NULL, 3, 0, 0, 0, '10', '20', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, '', 1, '2023-03-14 09:31:56', '2023-04-09 10:34:28'),
(76, 'Makrona', '31918397', 'standard', 'C128', NULL, 5, 4, 4, 4, '5.00', '10', 4, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-03-14 09:32:57', '2023-05-31 08:05:44'),
(77, 'Roz', '95360033', 'standard', 'C128', NULL, 5, 1, 1, 1, '5.00', '10', 4, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-03-14 09:33:34', '2023-05-31 08:05:44'),
(78, 'tea', '26453911', 'service', 'C128', NULL, 2, 0, 0, 0, '0', '10', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-03-14 13:55:12', '2023-04-09 10:34:28'),
(79, 'salta', '59865736', 'service', 'C128', NULL, 3, 0, 0, 0, '5', '20', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-03-14 13:55:57', '2023-04-09 10:34:28'),
(80, 'tomato', '01471993', 'standard', 'C128', NULL, 5, 4, 4, 4, '2.00', '5', 4, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-03-14 13:56:40', '2023-05-31 08:05:44'),
(81, 'carrot', '97059471', 'standard', 'C128', NULL, 5, 4, 4, 4, '3.00', '5', 4, NULL, NULL, NULL, NULL, NULL, 1, 2, 'zummXD2dvAtI.png', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, '', 1, '2023-03-14 13:57:40', '2023-05-31 08:05:44'),
(82, 'oreo chocolate 55.2gm ', '29897665', 'standard', 'C128', NULL, 1, 3, 3, 3, '4.66', '10', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-03-15 08:40:44', '2023-05-30 07:35:47'),
(83, 'glaxy flutes 22.5 gm ', '29897666', 'standard', 'C128', NULL, 1, 3, 3, 3, '8.92', '20', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-03-15 08:40:44', '2023-05-30 07:35:47'),
(84, 'ulker 54gm', '29897667', 'standard', 'C128', NULL, 1, 3, 3, 3, '5.92', '10', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-03-15 08:40:44', '2023-05-30 07:35:47'),
(85, 'twix 22gm', '29897668', 'standard', 'C128', NULL, 1, 3, 3, 3, '8.92', '20', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-03-15 08:40:44', '2023-05-30 07:35:47'),
(86, 'bembo ', '29897669', 'standard', 'C128', NULL, 1, 3, 3, 3, '3.91', '10', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-03-15 08:40:44', '2023-05-30 07:35:47'),
(87, 'hohos mix ', '29897670', 'standard', 'C128', NULL, 1, 3, 3, 3, '4.97', '10', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-03-15 08:40:44', '2023-05-30 07:35:47'),
(88, 'Chipsy KFC 73 gm ', '29897671', 'standard', 'C128', NULL, 1, 3, 3, 3, '6.95', '15', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-03-15 08:40:44', '2023-05-30 07:35:47'),
(89, 'CHEETOS 63 gm', '29897672', 'standard', 'C128', NULL, 1, 3, 3, 3, '5', '15', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-03-15 08:40:44', '2023-05-30 07:35:47'),
(90, 'cadbury 28gm', '29897673', 'standard', 'C128', NULL, 1, 3, 3, 3, '9.33', '20', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-03-15 08:40:44', '2023-05-30 07:35:47'),
(91, 'oreo cookies 32gm ', '29897674', 'standard', 'C128', NULL, 1, 3, 3, 3, '7.75', '15', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-03-15 08:40:44', '2023-05-30 07:35:47'),
(92, 'Lays 54 gm', '29897675', 'standard', 'C128', NULL, 1, 3, 3, 3, '6.95', '15', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-03-15 08:40:44', '2023-05-30 07:35:47'),
(93, 'moro 38 gm', '29897676', 'standard', 'C128', NULL, 1, 3, 3, 3, '9.33', '20', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-03-15 08:40:44', '2023-05-30 07:35:47'),
(94, 'fun day 40gm', '29897677', 'standard', 'C128', NULL, 1, 3, 3, 3, '10.5', '25', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-03-15 08:40:44', '2023-05-30 07:35:47'),
(95, 'BeBeto Sour 35gm', '29897678', 'standard', 'C128', NULL, 1, 3, 3, 3, '9', '20', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-03-15 08:40:44', '2023-05-30 07:35:47'),
(96, 'Doritos 77 gm', '29897679', 'standard', 'C128', NULL, 1, 3, 3, 3, '6', '15', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-03-15 08:40:44', '2023-05-30 07:35:47'),
(97, 'Biskrem 59 gm', '29897680', 'standard', 'C128', NULL, 1, 3, 3, 3, '6.64', '10', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-03-15 08:40:44', '2023-05-30 07:35:47'),
(98, 'Tuc 24 gm', '29897681', 'standard', 'C128', NULL, 1, 3, 3, 3, '3.66', '10', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-03-15 08:40:44', '2023-05-30 07:35:47'),
(99, 'Twix 50gm', '29897682', 'standard', 'C128', NULL, 1, 3, 3, 3, '18.48', '35', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-03-15 08:40:44', '2023-05-30 07:35:47'),
(100, 'Break 30gm', '29897683', 'standard', 'C128', NULL, 1, 3, 3, 3, '6.91', '15', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-03-15 08:40:44', '2023-05-30 07:35:47'),
(101, 'mandolin 50gm', '29897684', 'standard', 'C128', NULL, 1, 3, 3, 3, '6.33', '15', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-03-15 08:40:44', '2023-05-30 07:35:47'),
(102, 'Glaxy 22.5 gm', '29897685', 'standard', 'C128', NULL, 1, 3, 3, 3, '8.92', '20', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-03-15 08:40:44', '2023-05-30 07:35:47'),
(103, 'KIT KAT Ramdan', '29897686', 'standard', 'C128', NULL, 1, 3, 3, 3, '34.45', '75', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-03-15 08:40:44', '2023-05-30 07:35:47'),
(104, 'Magical Gummies', '29897687', 'standard', 'C128', NULL, 1, 3, 3, 3, '14.7', '30', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-03-15 08:40:44', '2023-05-30 07:35:47'),
(105, 'milka 90gm', '29897688', 'standard', 'C128', NULL, 1, 3, 3, 3, '25.95', '60', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-03-15 08:40:44', '2023-05-30 07:35:47'),
(106, 'Bubbly chocolate new ', '29897689', 'standard', 'C128', NULL, 1, 3, 3, 3, '9.1', '20', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-03-15 08:40:44', '2023-05-30 07:35:47'),
(107, 'cafe', '31026942', 'standard', 'C128', NULL, 5, 4, 4, 4, '10.00', '20', 19, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-04-09 10:01:52', '2023-05-31 08:05:44'),
(108, 'sokr', '07339293', 'standard', 'C128', NULL, 5, 4, 4, 4, '10.00', '15', 197.5, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-04-09 10:02:47', '2023-05-31 08:05:44'),
(109, 'cup of cafe', '24784310', 'service', 'C128', NULL, 3, 0, 0, 0, '42.14', '10', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-04-09 10:04:24', '2023-05-30 08:45:11'),
(110, 'limon', '61207234', 'standard', 'C128', NULL, 5, 4, 4, 4, '5.00', '10', 16, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, '', 1, '2023-04-09 10:15:57', '2023-05-31 08:05:44'),
(111, 'limonada', '78051267', 'service', 'C128', NULL, 3, 0, 0, 0, '15', '20', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, '', 1, '2023-04-09 10:16:52', '2023-05-02 07:05:06'),
(112, 'Pasta', '05392296', 'service', 'C128', NULL, 3, 0, 0, 0, '10', '20', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, '', 1, '2023-04-09 11:37:25', '2023-05-30 08:45:11'),
(113, 'Makrona l7ma', '56369229', 'standard', 'C128', NULL, 5, 4, 4, 4, '5.00', '10', 16, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-04-09 11:38:08', '2023-05-31 08:05:44'),
(114, 'milk', '90382283', 'standard', 'C128', NULL, 5, 4, 4, 4, '22.00', '25', 13, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2023-04-09 11:39:04', '2023-05-31 08:05:44'),
(115, 'a', '33232929', 'standard', 'C128', NULL, 5, 3, 3, 3, '10.00', '12', 92.5, 1, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, '', 1, '2023-05-02 07:02:10', '2023-05-31 08:05:44'),
(116, 'b', '39167059', 'standard', 'C128', NULL, 5, 3, 3, 3, '20.00', '25', 92.5, 1, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, '', 1, '2023-05-02 07:03:04', '2023-05-31 08:05:44'),
(117, 'a+b', '75169024', 'service', 'C128', NULL, 3, 0, 0, 0, '30', '50', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, '', 1, '2023-05-02 07:03:53', '2023-05-31 08:05:44'),
(118, 'aa', '60138796', 'standard', 'C128', 2, 2, 3, 3, 3, '10.00', '20', 101, 10, NULL, NULL, NULL, NULL, NULL, 1, 'zummXD2dvAtI.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, '2023-05-14 10:49:29', '2023-05-30 08:35:40');

-- --------------------------------------------------------

--
-- Table structure for table `product_adjustments`
--

DROP TABLE IF EXISTS `product_adjustments`;
CREATE TABLE IF NOT EXISTS `product_adjustments` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `adjustment_id` int NOT NULL,
  `product_id` int NOT NULL,
  `variant_id` int DEFAULT NULL,
  `qty` double NOT NULL,
  `action` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=117 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `product_adjustments`
--

INSERT INTO `product_adjustments` (`id`, `adjustment_id`, `product_id`, `variant_id`, `qty`, `action`, `created_at`, `updated_at`) VALUES
(9, 8, 27, NULL, 10, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(10, 8, 60, NULL, 448, '-', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(11, 8, 59, NULL, 108, '-', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(12, 8, 58, NULL, 237, '-', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(13, 8, 57, NULL, 6, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(14, 8, 56, NULL, 3, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(15, 8, 32, NULL, 10, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(16, 8, 30, NULL, 8, '-', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(17, 8, 55, NULL, 10, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(18, 8, 54, NULL, 10, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(19, 8, 53, NULL, 10, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(20, 8, 31, NULL, 6, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(21, 8, 52, NULL, 10, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(22, 8, 51, NULL, 7, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(23, 8, 50, NULL, 10, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(24, 8, 49, NULL, 10, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(25, 8, 48, NULL, 2, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(26, 8, 47, NULL, 10, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(27, 8, 46, NULL, 10, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(28, 8, 29, NULL, 10, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(29, 8, 45, NULL, 10, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(30, 8, 28, NULL, 10, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(31, 8, 61, NULL, 10, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(32, 8, 62, NULL, 10, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(33, 8, 63, NULL, 2, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(34, 8, 64, NULL, 5, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(35, 8, 65, NULL, 62, '-', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(36, 8, 71, NULL, 10, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(37, 8, 70, NULL, 9, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(38, 8, 69, NULL, 7, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(39, 8, 68, NULL, 10, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(40, 8, 67, NULL, 10, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(41, 8, 73, NULL, 10, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(42, 8, 72, NULL, 10, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(43, 8, 74, NULL, 10, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(44, 8, 77, NULL, 90, '-', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(45, 8, 76, NULL, 80, '-', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(46, 8, 75, NULL, 10, '+', '2023-03-14 09:52:31', '2023-03-14 09:52:31'),
(47, 9, 27, NULL, 10, '+', '2023-03-15 08:20:36', '2023-03-15 08:20:36'),
(48, 9, 60, NULL, 10, '+', '2023-03-15 08:20:36', '2023-03-15 08:20:36'),
(49, 9, 59, NULL, 10, '+', '2023-03-15 08:20:36', '2023-03-15 08:20:36'),
(50, 9, 58, NULL, 10, '+', '2023-03-15 08:20:36', '2023-03-15 08:20:36'),
(51, 9, 57, NULL, 10, '+', '2023-03-15 08:20:36', '2023-03-15 08:20:36'),
(52, 9, 56, NULL, 10, '+', '2023-03-15 08:20:36', '2023-03-15 08:20:36'),
(53, 9, 32, NULL, 10, '+', '2023-03-15 08:20:36', '2023-03-15 08:20:36'),
(54, 9, 30, NULL, 10, '+', '2023-03-15 08:20:36', '2023-03-15 08:20:36'),
(55, 9, 55, NULL, 10, '+', '2023-03-15 08:20:36', '2023-03-15 08:20:36'),
(56, 9, 54, NULL, 10, '+', '2023-03-15 08:20:36', '2023-03-15 08:20:36'),
(57, 9, 53, NULL, 10, '+', '2023-03-15 08:20:36', '2023-03-15 08:20:36'),
(58, 9, 31, NULL, 10, '+', '2023-03-15 08:20:36', '2023-03-15 08:20:36'),
(59, 9, 52, NULL, 10, '+', '2023-03-15 08:20:36', '2023-03-15 08:20:36'),
(60, 9, 51, NULL, 10, '+', '2023-03-15 08:20:36', '2023-03-15 08:20:36'),
(61, 9, 50, NULL, 10, '+', '2023-03-15 08:20:36', '2023-03-15 08:20:36'),
(62, 9, 49, NULL, 10, '+', '2023-03-15 08:20:36', '2023-03-15 08:20:36'),
(63, 9, 48, NULL, 10, '+', '2023-03-15 08:20:36', '2023-03-15 08:20:36'),
(64, 9, 47, NULL, 10, '+', '2023-03-15 08:20:36', '2023-03-15 08:20:36'),
(65, 9, 46, NULL, 10, '+', '2023-03-15 08:20:36', '2023-03-15 08:20:36'),
(66, 9, 29, NULL, 10, '+', '2023-03-15 08:20:36', '2023-03-15 08:20:36'),
(67, 9, 45, NULL, 10, '+', '2023-03-15 08:20:36', '2023-03-15 08:20:36'),
(68, 9, 28, NULL, 10, '+', '2023-03-15 08:20:36', '2023-03-15 08:20:36'),
(69, 9, 61, NULL, 10, '+', '2023-03-15 08:20:36', '2023-03-15 08:20:36'),
(70, 9, 62, NULL, 5, '-', '2023-03-15 08:20:36', '2023-03-15 08:20:36'),
(71, 9, 63, NULL, 5, '-', '2023-03-15 08:20:37', '2023-03-15 08:20:37'),
(72, 9, 64, NULL, 5, '-', '2023-03-15 08:20:37', '2023-03-15 08:20:37'),
(73, 9, 65, NULL, 5, '-', '2023-03-15 08:20:37', '2023-03-15 08:20:37'),
(74, 9, 71, NULL, 5, '-', '2023-03-15 08:20:37', '2023-03-15 08:20:37'),
(75, 9, 70, NULL, 5, '-', '2023-03-15 08:20:37', '2023-03-15 08:20:37'),
(76, 9, 69, NULL, 5, '-', '2023-03-15 08:20:37', '2023-03-15 08:20:37'),
(77, 9, 68, NULL, 5, '-', '2023-03-15 08:20:37', '2023-03-15 08:20:37'),
(78, 9, 67, NULL, 5, '-', '2023-03-15 08:20:37', '2023-03-15 08:20:37'),
(79, 9, 73, NULL, 5, '-', '2023-03-15 08:20:37', '2023-03-15 08:20:37'),
(80, 9, 72, NULL, 5, '-', '2023-03-15 08:20:37', '2023-03-15 08:20:37'),
(81, 9, 74, NULL, 5, '-', '2023-03-15 08:20:37', '2023-03-15 08:20:37'),
(82, 9, 77, NULL, 5, '-', '2023-03-15 08:20:37', '2023-03-15 08:20:37'),
(83, 9, 76, NULL, 5, '-', '2023-03-15 08:20:37', '2023-03-15 08:20:37'),
(84, 9, 80, NULL, 45, '-', '2023-03-15 08:20:37', '2023-03-15 08:20:37'),
(85, 9, 81, NULL, 35, '-', '2023-03-15 08:20:37', '2023-03-15 08:20:37'),
(86, 9, 75, NULL, 5, '+', '2023-03-15 08:20:37', '2023-03-15 08:20:37'),
(87, 9, 78, NULL, 5, '+', '2023-03-15 08:20:37', '2023-03-15 08:20:37'),
(88, 9, 79, NULL, 5, '+', '2023-03-15 08:20:37', '2023-03-15 08:20:37'),
(89, 10, 27, NULL, 13, '-', '2023-04-09 10:34:27', '2023-04-09 10:34:27'),
(90, 10, 60, NULL, 15, '-', '2023-04-09 10:34:27', '2023-04-09 10:34:27'),
(91, 10, 59, NULL, 15, '-', '2023-04-09 10:34:27', '2023-04-09 10:34:27'),
(92, 10, 58, NULL, 15, '-', '2023-04-09 10:34:27', '2023-04-09 10:34:27'),
(93, 10, 57, NULL, 15, '-', '2023-04-09 10:34:27', '2023-04-09 10:34:27'),
(94, 10, 56, NULL, 15, '-', '2023-04-09 10:34:27', '2023-04-09 10:34:27'),
(95, 10, 32, NULL, 15, '-', '2023-04-09 10:34:27', '2023-04-09 10:34:27'),
(96, 10, 30, NULL, 15, '-', '2023-04-09 10:34:27', '2023-04-09 10:34:27'),
(97, 10, 55, NULL, 15, '-', '2023-04-09 10:34:27', '2023-04-09 10:34:27'),
(98, 10, 54, NULL, 15, '-', '2023-04-09 10:34:27', '2023-04-09 10:34:27'),
(99, 10, 53, NULL, 15, '-', '2023-04-09 10:34:27', '2023-04-09 10:34:27'),
(100, 10, 31, NULL, 15, '-', '2023-04-09 10:34:27', '2023-04-09 10:34:27'),
(101, 10, 52, NULL, 15, '-', '2023-04-09 10:34:27', '2023-04-09 10:34:27'),
(102, 10, 51, NULL, 15, '-', '2023-04-09 10:34:27', '2023-04-09 10:34:27'),
(103, 10, 50, NULL, 15, '-', '2023-04-09 10:34:27', '2023-04-09 10:34:27'),
(104, 10, 49, NULL, 15, '-', '2023-04-09 10:34:27', '2023-04-09 10:34:27'),
(105, 10, 48, NULL, 15, '-', '2023-04-09 10:34:27', '2023-04-09 10:34:27'),
(106, 10, 47, NULL, 15, '-', '2023-04-09 10:34:27', '2023-04-09 10:34:27'),
(107, 10, 46, NULL, 15, '-', '2023-04-09 10:34:27', '2023-04-09 10:34:27'),
(108, 10, 29, NULL, 15, '-', '2023-04-09 10:34:27', '2023-04-09 10:34:27'),
(109, 10, 45, NULL, 15, '-', '2023-04-09 10:34:27', '2023-04-09 10:34:27'),
(110, 10, 28, NULL, 15, '-', '2023-04-09 10:34:27', '2023-04-09 10:34:27'),
(111, 10, 61, NULL, 15, '-', '2023-04-09 10:34:27', '2023-04-09 10:34:27'),
(112, 10, 80, NULL, 3, '+', '2023-04-09 10:34:27', '2023-04-09 10:34:27'),
(113, 10, 81, NULL, 3, '+', '2023-04-09 10:34:27', '2023-04-09 10:34:27'),
(114, 10, 75, NULL, 5, '+', '2023-04-09 10:34:27', '2023-04-09 10:34:27'),
(115, 10, 78, NULL, 5, '+', '2023-04-09 10:34:27', '2023-04-09 10:34:27'),
(116, 10, 79, NULL, 5, '+', '2023-04-09 10:34:27', '2023-04-09 10:34:27');

-- --------------------------------------------------------

--
-- Table structure for table `product_batches`
--

DROP TABLE IF EXISTS `product_batches`;
CREATE TABLE IF NOT EXISTS `product_batches` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `product_id` int NOT NULL,
  `batch_no` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expired_date` date NOT NULL,
  `qty` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `product_batches`
--

INSERT INTO `product_batches` (`id`, `product_id`, `batch_no`, `expired_date`, `qty`, `created_at`, `updated_at`) VALUES
(1, 18, '002', '2022-06-15', 0, '2022-06-13 13:55:40', '2022-08-08 13:51:13');

-- --------------------------------------------------------

--
-- Table structure for table `product_purchases`
--

DROP TABLE IF EXISTS `product_purchases`;
CREATE TABLE IF NOT EXISTS `product_purchases` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `purchase_id` int NOT NULL,
  `product_id` int NOT NULL,
  `product_batch_id` int DEFAULT NULL,
  `variant_id` int DEFAULT NULL,
  `imei_number` text COLLATE utf8mb4_unicode_ci,
  `qty` double NOT NULL,
  `recieved` double NOT NULL,
  `purchase_unit_id` int NOT NULL,
  `net_unit_cost` double NOT NULL,
  `discount` double NOT NULL,
  `tax_rate` double NOT NULL,
  `tax` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=138 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `product_purchases`
--

INSERT INTO `product_purchases` (`id`, `purchase_id`, `product_id`, `product_batch_id`, `variant_id`, `imei_number`, `qty`, `recieved`, `purchase_unit_id`, `net_unit_cost`, `discount`, `tax_rate`, `tax`, `total`, `created_at`, `updated_at`) VALUES
(18, 11, 60, NULL, NULL, NULL, 145, 145, 3, 2.19, 0, 14, 44.52, 362.5, '2022-09-16 11:37:29', '2022-09-16 11:37:29'),
(19, 11, 59, NULL, NULL, NULL, 105, 105, 3, 3.46, 0, 14, 50.93, 414.75, '2022-09-16 11:37:29', '2022-09-16 11:37:29'),
(20, 11, 58, NULL, NULL, NULL, 94, 94, 3, 4.96, 0, 14, 65.22, 531.1, '2022-09-16 11:37:29', '2022-09-16 11:37:29'),
(21, 11, 57, NULL, NULL, NULL, 12, 12, 3, 9.61, 0, 14, 16.14, 131.4, '2022-09-16 11:37:29', '2022-09-16 11:37:29'),
(22, 11, 56, NULL, NULL, NULL, 39, 39, 3, 5.26, 0, 14, 28.74, 234, '2022-09-16 11:37:29', '2022-09-16 11:37:29'),
(23, 11, 32, NULL, NULL, NULL, 23, 23, 6, 13.55, 0, 14, 43.63, 355.28, '2022-09-16 11:37:29', '2022-09-16 11:37:29'),
(24, 11, 30, NULL, NULL, NULL, 19, 19, 6, 12.6, 0, 14, 33.52, 272.92, '2022-09-16 11:37:29', '2022-09-16 11:37:29'),
(25, 11, 27, NULL, NULL, NULL, 23, 23, 6, 13.55, 0, 14, 43.63, 355.28, '2022-09-16 11:37:29', '2022-09-16 11:37:29'),
(26, 11, 55, NULL, NULL, NULL, 15, 15, 3, 10.18, 0, 14, 21.37, 174, '2022-09-16 11:37:29', '2022-09-16 11:37:29'),
(27, 11, 54, NULL, NULL, NULL, 17, 17, 3, 11.89, 0, 14, 28.29, 230.35, '2022-09-16 11:37:29', '2022-09-16 11:37:29'),
(28, 11, 53, NULL, NULL, NULL, 20, 20, 3, 11.62, 0, 14, 32.54, 265, '2022-09-16 11:37:29', '2022-09-16 11:37:29'),
(29, 11, 31, NULL, NULL, NULL, 10, 10, 6, 13.7, 0, 14, 19.18, 156.18, '2022-09-16 11:37:29', '2022-09-16 11:37:29'),
(30, 11, 52, NULL, NULL, NULL, 7, 7, 3, 10.75, 0, 14, 10.53, 85.75, '2022-09-16 11:37:29', '2022-09-16 11:37:29'),
(31, 11, 51, NULL, NULL, NULL, 27, 27, 3, 10.53, 0, 14, 39.79, 324, '2022-09-16 11:37:29', '2022-09-16 11:37:29'),
(32, 11, 50, NULL, NULL, NULL, 16, 16, 3, 6.14, 0, 14, 13.75, 112, '2022-09-16 11:37:29', '2022-09-16 11:37:29'),
(33, 11, 49, NULL, NULL, NULL, 8, 8, 3, 9.47, 0, 14, 10.61, 86.4, '2022-09-16 11:37:29', '2022-09-16 11:37:29'),
(34, 11, 48, NULL, NULL, NULL, 30, 30, 3, 10.53, 0, 14, 44.21, 360, '2022-09-16 11:37:29', '2022-09-16 11:37:29'),
(35, 11, 47, NULL, NULL, NULL, 9, 9, 3, 13.55, 0, 14, 17.08, 139.05, '2022-09-16 11:37:29', '2022-09-16 11:37:29'),
(36, 11, 46, NULL, NULL, NULL, 14, 14, 3, 13.55, 0, 14, 26.56, 216.3, '2022-09-16 11:37:29', '2022-09-16 11:37:29'),
(37, 11, 29, NULL, NULL, NULL, 19, 19, 6, 12.6, 0, 14, 33.52, 272.92, '2022-09-16 11:37:29', '2022-09-16 11:37:29'),
(38, 11, 45, NULL, NULL, NULL, 23, 23, 3, 12.6, 0, 0, 0, 289.8, '2022-09-16 11:37:29', '2022-09-16 11:37:29'),
(39, 11, 28, NULL, NULL, NULL, 14, 14, 6, 12.6, 0, 14, 24.7, 201.1, '2022-09-16 11:37:29', '2022-09-16 11:37:29'),
(40, 12, 60, NULL, NULL, NULL, 100, 100, 3, 1.92, 0, 14, 26.89, 219, '2022-09-21 12:17:40', '2022-09-21 12:17:40'),
(41, 12, 48, NULL, NULL, NULL, 15, 15, 3, 11.36, 0, 14, 23.86, 194.25, '2022-09-21 12:17:40', '2022-09-21 12:17:40'),
(42, 13, 58, NULL, NULL, NULL, 32, 32, 3, 4.35, 0, 14, 19.49, 158.72, '2022-09-24 22:48:46', '2022-09-24 22:48:46'),
(43, 14, 60, NULL, NULL, NULL, 50, 50, 3, 1.68, 0, 14, 11.79, 96, '2022-09-24 22:56:45', '2022-09-24 22:56:45'),
(44, 15, 61, NULL, NULL, NULL, 34, 34, 3, 17.54, 0, 14, 83.51, 680, '2022-09-26 18:27:08', '2022-09-26 18:27:08'),
(45, 15, 62, NULL, NULL, NULL, 36, 36, 3, 17.54, 0, 14, 88.42, 720, '2022-09-26 18:27:08', '2022-09-26 18:27:08'),
(46, 15, 63, NULL, NULL, NULL, 36, 36, 3, 17.54, 0, 14, 88.42, 720, '2022-09-26 18:27:08', '2022-09-26 18:27:08'),
(47, 15, 64, NULL, NULL, NULL, 36, 36, 3, 21.93, 0, 14, 110.53, 900, '2022-09-26 18:27:08', '2022-09-26 18:27:08'),
(48, 16, 60, NULL, NULL, NULL, 475, 475, 3, 1.47, 0, 14, 98, 798, '2022-09-28 17:08:49', '2022-09-28 17:08:49'),
(49, 17, 58, NULL, NULL, NULL, 105, 105, 3, 3.82, 0, 14, 56.09, 456.75, '2022-09-28 17:14:11', '2022-09-28 17:14:11'),
(50, 18, 59, NULL, NULL, NULL, 82, 82, 3, 3.04, 0, 14, 34.84, 283.72, '2022-09-28 17:15:21', '2022-09-28 17:15:21'),
(51, 19, 57, NULL, NULL, NULL, 144, 144, 3, 8.43, 0, 14, 169.95, 1383.84, '2022-09-28 17:16:37', '2022-09-28 17:16:37'),
(52, 20, 46, NULL, NULL, NULL, 2, 2, 3, 11.89, 0, 14, 3.33, 27.1, '2022-10-08 18:23:44', '2022-10-08 18:23:44'),
(53, 21, 47, NULL, NULL, NULL, 8, 8, 3, 11.89, 0, 14, 13.31, 108.4, '2022-10-08 18:26:27', '2022-10-08 18:26:27'),
(54, 22, 46, NULL, NULL, NULL, 1, 1, 3, 10.43, 0, 14, 1.46, 11.89, '2022-10-11 22:49:03', '2022-10-11 22:49:03'),
(55, 23, 58, NULL, NULL, NULL, 50, 50, 3, 3.35, 0, 14, 23.46, 191, '2022-10-14 23:12:41', '2022-10-14 23:12:41'),
(56, 24, 60, NULL, NULL, NULL, 242, 242, 3, 1.29, 0, 14, 43.69, 355.74, '2022-10-14 23:13:31', '2022-10-14 23:13:31'),
(57, 25, 59, NULL, NULL, NULL, 75, 75, 3, 2.67, 0, 14, 28, 228, '2022-10-14 23:14:39', '2022-10-14 23:14:39'),
(58, 26, 57, NULL, NULL, NULL, 60, 60, 3, 7.39, 0, 14, 62.12, 505.8, '2022-10-27 23:04:04', '2022-10-27 23:04:04'),
(59, 27, 60, NULL, NULL, NULL, 400, 400, 3, 1.13, 0, 14, 63.37, 516, '2022-10-27 23:04:39', '2022-10-27 23:04:39'),
(60, 28, 59, NULL, NULL, NULL, 135, 135, 3, 2.34, 0, 14, 44.27, 360.45, '2022-10-27 23:05:21', '2022-10-27 23:05:21'),
(61, 29, 58, NULL, NULL, NULL, 120, 120, 3, 2.94, 0, 14, 49.37, 402, '2022-10-27 23:05:55', '2022-10-27 23:05:55'),
(62, 30, 60, NULL, NULL, NULL, 140, 140, 3, 0.99, 0, 14, 19.43, 158.2, '2022-11-03 21:45:18', '2022-11-03 21:45:18'),
(63, 31, 58, NULL, NULL, NULL, 144, 144, 3, 2.58, 0, 14, 51.99, 423.36, '2022-11-03 21:46:20', '2022-11-03 21:46:20'),
(64, 32, 59, NULL, NULL, NULL, 54, 54, 3, 2.05, 0, 14, 15.52, 126.36, '2022-11-03 21:47:24', '2022-11-03 21:47:24'),
(65, 33, 65, NULL, NULL, NULL, 100, 100, 3, 10, 0, 14, 140, 1140, '2022-11-08 10:02:25', '2022-11-08 10:02:25'),
(66, 34, 60, NULL, NULL, NULL, 400, 400, 3, 0.87, 0, 14, 48.63, 396, '2022-11-18 13:31:14', '2022-11-18 13:31:14'),
(67, 35, 58, NULL, NULL, NULL, 144, 144, 3, 2.26, 0, 14, 45.63, 371.52, '2022-11-18 13:31:52', '2022-11-18 13:31:52'),
(68, 36, 59, NULL, NULL, NULL, 216, 216, 3, 1.8, 0, 14, 54.38, 442.8, '2022-11-18 13:32:24', '2022-11-18 13:32:24'),
(69, 37, 48, NULL, NULL, NULL, 200, 200, 3, 9.96, 0, 14, 279.02, 2272, '2022-11-18 13:34:33', '2022-11-18 13:34:33'),
(70, 38, 32, NULL, NULL, NULL, 10, 10, 6, 11.89, 0, 14, 16.64, 135.5, '2022-11-19 13:36:09', '2022-11-19 13:36:09'),
(71, 39, 47, NULL, NULL, NULL, 6, 6, 3, 10.43, 0, 14, 8.76, 71.34, '2022-11-19 13:38:33', '2022-11-19 13:38:33'),
(72, 40, 28, NULL, NULL, NULL, 3, 3, 6, 11.05, 0, 14, 4.64, 37.8, '2022-11-19 13:46:53', '2022-11-19 13:46:53'),
(73, 41, 60, NULL, NULL, NULL, 200, 200, 3, 0.76, 0, 14, 21.37, 174, '2022-11-25 22:17:58', '2022-11-25 22:17:58'),
(74, 42, 58, NULL, NULL, NULL, 144, 144, 3, 1.98, 0, 14, 39.97, 325.44, '2022-11-25 22:18:35', '2022-11-25 22:18:35'),
(75, 43, 59, NULL, NULL, NULL, 81, 81, 3, 1.58, 0, 14, 17.91, 145.8, '2022-11-25 22:19:13', '2022-11-25 22:19:13'),
(76, 44, 28, NULL, NULL, NULL, 1, 1, 6, 9.69, 0, 14, 1.36, 11.05, '2022-11-27 11:27:18', '2022-11-27 11:27:18'),
(77, 45, 48, NULL, NULL, NULL, 100, 100, 3, 8.74, 0, 14, 122.32, 996, '2022-11-27 11:27:56', '2022-11-27 11:27:56'),
(78, 46, 48, NULL, NULL, NULL, 100, 100, 3, 7.67, 0, 14, 107.33, 874, '2022-11-27 11:30:02', '2022-11-27 11:30:02'),
(79, 47, 65, NULL, NULL, NULL, 100, 100, 3, 8.77, 0, 14, 122.81, 1000, '2022-11-30 20:29:41', '2022-11-30 20:29:41'),
(80, 48, 58, NULL, NULL, NULL, 120, 120, 3, 1.74, 0, 14, 29.18, 237.6, '2022-12-08 21:20:12', '2022-12-08 21:20:12'),
(81, 48, 59, NULL, NULL, NULL, 216, 216, 3, 1.39, 0, 14, 41.91, 341.28, '2022-12-08 21:20:12', '2022-12-08 21:20:12'),
(82, 48, 60, NULL, NULL, NULL, 400, 400, 3, 0.67, 0, 14, 37.33, 304, '2022-12-08 21:20:12', '2022-12-08 21:20:12'),
(83, 49, 58, NULL, NULL, NULL, 72, 72, 3, 1.53, 0, 14, 15.39, 125.28, '2022-12-12 14:10:55', '2022-12-12 14:10:55'),
(84, 50, 71, NULL, NULL, NULL, 12, 12, 6, 5.26, 0, 14, 8.84, 72, '2022-12-14 20:24:39', '2022-12-14 20:24:39'),
(85, 50, 70, NULL, NULL, NULL, 12, 12, 6, 5.26, 0, 14, 8.84, 72, '2022-12-14 20:24:39', '2022-12-14 20:24:39'),
(86, 50, 69, NULL, NULL, NULL, 12, 12, 6, 5.26, 0, 14, 8.84, 72, '2022-12-14 20:24:39', '2022-12-14 20:24:39'),
(87, 50, 68, NULL, NULL, NULL, 12, 12, 6, 5.26, 0, 14, 8.84, 72, '2022-12-14 20:24:39', '2022-12-14 20:24:39'),
(88, 50, 67, NULL, NULL, NULL, 12, 12, 6, 5.26, 0, 14, 8.84, 72, '2022-12-14 20:24:39', '2022-12-14 20:24:39'),
(89, 51, 57, NULL, NULL, NULL, 60, 60, 3, 6.48, 0, 14, 54.45, 443.4, '2022-12-17 21:57:31', '2022-12-17 21:57:31'),
(90, 52, 60, NULL, NULL, NULL, 200, 200, 3, 0.59, 0, 14, 16.46, 134, '2022-12-17 21:58:06', '2022-12-17 21:58:06'),
(91, 53, 59, NULL, NULL, NULL, 135, 135, 3, 1.22, 0, 14, 23.04, 187.65, '2022-12-17 21:58:44', '2022-12-17 21:58:44'),
(92, 54, 58, NULL, NULL, NULL, 120, 120, 3, 1.34, 0, 14, 22.55, 183.6, '2022-12-17 21:59:28', '2022-12-17 21:59:28'),
(93, 55, 71, NULL, NULL, NULL, 6, 6, 6, 4.61, 0, 14, 3.88, 31.56, '2022-12-17 22:07:05', '2022-12-17 22:07:05'),
(94, 56, 69, NULL, NULL, NULL, 6, 6, 6, 4.61, 0, 14, 3.88, 31.56, '2022-12-17 22:07:49', '2022-12-17 22:07:49'),
(95, 57, 68, NULL, NULL, NULL, 5, 5, 6, 4.61, 0, 14, 3.23, 26.3, '2022-12-17 22:10:40', '2022-12-17 22:10:40'),
(96, 58, 73, NULL, NULL, NULL, 24, 24, 6, 7.46, 0, 14, 25.05, 204, '2022-12-26 19:25:38', '2022-12-26 19:25:38'),
(97, 58, 72, NULL, NULL, NULL, 7, 7, 6, 7.46, 0, 14, 7.31, 59.5, '2022-12-26 19:25:38', '2022-12-26 19:25:38'),
(98, 59, 56, NULL, NULL, NULL, 8, 8, 3, 4.61, 0, 14, 5.17, 42.08, '2022-12-29 18:02:52', '2022-12-29 18:02:52'),
(99, 59, 51, NULL, NULL, NULL, 13, 13, 3, 9.24, 0, 14, 16.81, 136.89, '2022-12-29 18:02:52', '2022-12-29 18:02:52'),
(100, 59, 48, NULL, NULL, NULL, 25, 25, 3, 6.73, 0, 14, 23.55, 191.75, '2022-12-29 18:02:52', '2022-12-29 18:02:52'),
(101, 59, 30, NULL, NULL, NULL, 4, 4, 6, 11.05, 0, 14, 6.19, 50.4, '2022-12-29 18:02:52', '2022-12-29 18:02:52'),
(102, 60, 74, NULL, NULL, NULL, 15, 15, 6, 21.93, 0, 14, 46.05, 375, '2022-12-29 21:00:12', '2022-12-29 21:00:12'),
(103, 61, 58, NULL, NULL, NULL, 36, 36, 3, 5.7, 0, 14, 28.74, 234, '2022-12-30 21:35:59', '2022-12-30 21:35:59'),
(104, 62, 31, NULL, NULL, NULL, 4, 4, 6, 21.01, 0, 14, 11.76, 95.8, '2023-01-03 21:05:11', '2023-01-03 21:05:11'),
(105, 63, 30, NULL, NULL, NULL, 5, 5, 6, 18.82, 0, 14, 13.17, 107.25, '2023-01-03 21:05:42', '2023-01-03 21:05:42'),
(106, 64, 70, NULL, NULL, NULL, 15, 15, 6, 4.61, 0, 14, 9.69, 78.9, '2023-01-06 18:06:16', '2023-01-06 18:06:16'),
(107, 64, 69, NULL, NULL, NULL, 15, 15, 6, 4.04, 0, 14, 8.49, 69.15, '2023-01-06 18:06:16', '2023-01-06 18:06:16'),
(108, 64, 59, NULL, NULL, NULL, 243, 243, 3, 5.26, 0, 14, 179.05, 1458, '2023-01-06 18:06:16', '2023-01-06 18:06:16'),
(109, 64, 58, NULL, NULL, NULL, 193, 193, 3, 5, 0, 14, 135.1, 1100.1, '2023-01-06 18:06:16', '2023-01-06 18:06:16'),
(110, 64, 60, NULL, NULL, NULL, 400, 400, 3, 2.63, 0, 14, 147.37, 1200, '2023-01-06 18:06:16', '2023-01-06 18:06:16'),
(111, 65, 58, NULL, NULL, NULL, 144, 144, 3, 4.39, 0, 14, 88.42, 720, '2023-01-20 16:19:34', '2023-01-20 16:19:34'),
(112, 65, 59, NULL, NULL, NULL, 189, 189, 3, 4.61, 0, 14, 122.09, 994.14, '2023-01-20 16:19:34', '2023-01-20 16:19:34'),
(113, 65, 60, NULL, NULL, NULL, 300, 300, 3, 2.31, 0, 14, 96.89, 789, '2023-01-20 16:19:34', '2023-01-20 16:19:34'),
(114, 65, 57, NULL, NULL, NULL, 26, 26, 3, 12.24, 0, 14, 44.54, 362.7, '2023-01-20 16:19:34', '2023-01-20 16:19:34'),
(115, 66, 77, NULL, NULL, NULL, 100, 100, 1, 5, 0, 0, 0, 500, '2023-03-14 09:35:47', '2023-03-14 09:35:47'),
(116, 66, 76, NULL, NULL, NULL, 90, 90, 4, 5, 0, 0, 0, 450, '2023-03-14 09:35:47', '2023-03-14 09:35:47'),
(117, 67, 80, NULL, NULL, NULL, 50, 50, 4, 2, 0, 0, 0, 100, '2023-03-14 13:58:22', '2023-03-14 13:58:22'),
(118, 67, 81, NULL, NULL, NULL, 40, 40, 4, 3, 0, 0, 0, 120, '2023-03-14 13:58:22', '2023-03-14 13:58:22'),
(119, 68, 107, NULL, NULL, NULL, 10, 10, 4, 10, 0, 0, 0, 100, '2023-04-09 10:19:19', '2023-04-09 10:19:19'),
(120, 68, 108, NULL, NULL, NULL, 100, 100, 4, 10, 0, 0, 0, 1000, '2023-04-09 10:19:19', '2023-04-09 10:19:19'),
(121, 68, 110, NULL, NULL, NULL, 10, 10, 3, 5, 0, 0, 0, 50, '2023-04-09 10:19:19', '2023-04-09 10:19:19'),
(122, 69, 107, NULL, NULL, NULL, 10, 10, 4, 10, 0, 0, 0, 100, '2023-04-09 11:32:25', '2023-04-09 11:32:25'),
(123, 69, 108, NULL, NULL, NULL, 100, 100, 4, 10, 0, 0, 0, 1000, '2023-04-09 11:32:25', '2023-04-09 11:32:25'),
(124, 69, 110, NULL, NULL, NULL, 10, 10, 3, 5, 0, 0, 0, 50, '2023-04-09 11:32:25', '2023-04-09 11:32:25'),
(125, 70, 113, NULL, NULL, NULL, 20, 20, 4, 5, 0, 0, 0, 100, '2023-04-09 11:40:53', '2023-04-09 11:40:53'),
(126, 70, 114, NULL, NULL, NULL, 20, 20, 4, 22, 0, 0, 0, 440, '2023-04-09 11:40:53', '2023-04-09 11:40:53'),
(127, 71, 116, NULL, NULL, NULL, 17, 17, 4, 20, 0, 0, 0, 340, '2023-05-02 07:05:06', '2023-05-02 07:05:06'),
(128, 71, 115, NULL, NULL, NULL, 100, 100, 3, 10, 0, 0, 0, 1000, '2023-05-02 07:05:06', '2023-05-02 07:05:06'),
(129, 72, 27, NULL, NULL, NULL, 200, 200, 6, 21.05, 0, 14, 589.47, 4800, '2023-05-07 11:33:32', '2023-05-07 11:33:32'),
(130, 72, 30, NULL, NULL, NULL, 200, 200, 6, 16.51, 0, 14, 462.25, 3764, '2023-05-07 11:33:32', '2023-05-07 11:33:32'),
(131, 73, 118, NULL, NULL, NULL, 100, 100, 3, 10, 0, 0, 0, 1000, '2023-05-14 10:49:59', '2023-05-14 10:49:59'),
(132, 74, 118, NULL, NULL, NULL, 100, 100, 3, 10, 0, 0, 0, 1000, '2023-05-14 10:52:58', '2023-05-14 10:52:58'),
(133, 75, 27, NULL, NULL, NULL, 300, 300, 3, 18.46, 0, 14, 775.53, 6315, '2023-05-30 08:00:03', '2023-05-30 08:00:03'),
(134, 76, 116, NULL, NULL, NULL, 95, 95, 4, 20, 0, 0, 0, 1900, '2023-05-30 08:33:43', '2023-05-30 08:33:43'),
(135, 76, 115, NULL, NULL, NULL, 15, 15, 4, 10, 0, 0, 0, 150, '2023-05-30 08:33:43', '2023-05-30 08:33:43'),
(136, 77, 27, NULL, NULL, NULL, 100, 100, 3, 16.19, 0, 14, 226.7, 1846, '2023-05-30 08:45:11', '2023-05-30 08:45:11'),
(137, 78, 28, NULL, NULL, NULL, 100, 100, 6, 18.82, 0, 14, 263.42, 2145, '2023-05-30 11:34:36', '2023-05-30 11:34:36');

-- --------------------------------------------------------

--
-- Table structure for table `product_quotation`
--

DROP TABLE IF EXISTS `product_quotation`;
CREATE TABLE IF NOT EXISTS `product_quotation` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `quotation_id` int NOT NULL,
  `product_id` int NOT NULL,
  `product_batch_id` int DEFAULT NULL,
  `variant_id` int DEFAULT NULL,
  `qty` double NOT NULL,
  `sale_unit_id` int NOT NULL,
  `net_unit_price` double NOT NULL,
  `discount` double NOT NULL,
  `tax_rate` double NOT NULL,
  `tax` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `product_returns`
--

DROP TABLE IF EXISTS `product_returns`;
CREATE TABLE IF NOT EXISTS `product_returns` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `return_id` int NOT NULL,
  `product_id` int NOT NULL,
  `product_batch_id` int DEFAULT NULL,
  `variant_id` int DEFAULT NULL,
  `imei_number` text COLLATE utf8mb4_unicode_ci,
  `qty` double NOT NULL,
  `sale_unit_id` int NOT NULL,
  `net_unit_price` double NOT NULL,
  `discount` double NOT NULL,
  `tax_rate` double NOT NULL,
  `tax` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `product_returns`
--

INSERT INTO `product_returns` (`id`, `return_id`, `product_id`, `product_batch_id`, `variant_id`, `imei_number`, `qty`, `sale_unit_id`, `net_unit_price`, `discount`, `tax_rate`, `tax`, `total`, `created_at`, `updated_at`) VALUES
(8, 8, 27, NULL, NULL, NULL, 1, 3, 30.7, 0, 14, 4.3, 35, '2023-05-09 10:17:38', '2023-05-09 10:17:38'),
(9, 9, 27, NULL, NULL, NULL, 1, 3, 30.7, 0, 14, 4.3, 35, '2023-05-09 10:51:03', '2023-05-09 10:51:03');

-- --------------------------------------------------------

--
-- Table structure for table `product_sales`
--

DROP TABLE IF EXISTS `product_sales`;
CREATE TABLE IF NOT EXISTS `product_sales` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `sale_id` int NOT NULL,
  `product_id` int NOT NULL,
  `product_batch_id` int DEFAULT NULL,
  `variant_id` int DEFAULT NULL,
  `imei_number` text COLLATE utf8mb4_unicode_ci,
  `qty` double NOT NULL,
  `sale_unit_id` int NOT NULL,
  `net_unit_price` double NOT NULL,
  `discount` double NOT NULL,
  `tax_rate` double NOT NULL,
  `tax` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=911 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `product_sales`
--

INSERT INTO `product_sales` (`id`, `sale_id`, `product_id`, `product_batch_id`, `variant_id`, `imei_number`, `qty`, `sale_unit_id`, `net_unit_price`, `discount`, `tax_rate`, `tax`, `total`, `created_at`, `updated_at`) VALUES
(817, 401, 30, NULL, NULL, NULL, 1, 6, 30.7, 0, 14, 4.3, 35, '2023-03-14 10:02:08', '2023-05-10 09:02:08'),
(818, 401, 27, NULL, NULL, NULL, 1, 3, 30.7, 0, 14, 4.3, 35, '2023-03-14 10:02:08', '2023-05-10 09:02:08'),
(819, 402, 49, NULL, NULL, NULL, 1, 3, 21.93, 0, 14, 3.07, 25, '2023-03-14 10:09:32', '2023-05-10 09:09:32'),
(820, 402, 30, NULL, NULL, NULL, 1, 6, 30.7, 0, 14, 4.3, 35, '2023-03-14 10:09:32', '2023-05-10 09:09:32'),
(821, 403, 27, NULL, NULL, NULL, 1, 3, 30.7, 0, 14, 4.3, 35, '2023-03-14 07:18:25', '2023-05-11 06:18:25'),
(822, 403, 49, NULL, NULL, NULL, 1, 3, 21.93, 0, 14, 3.07, 25, '2023-03-14 07:18:25', '2023-05-11 06:18:25'),
(823, 404, 30, NULL, NULL, NULL, 1, 6, 30.7, 0, 14, 4.3, 35, '2023-03-14 07:18:48', '2023-05-11 06:18:48'),
(824, 404, 27, NULL, NULL, NULL, 1, 3, 30.7, 0, 14, 4.3, 35, '2023-03-14 07:18:48', '2023-05-11 06:18:48'),
(825, 405, 49, NULL, NULL, NULL, 1, 3, 21.93, 0, 14, 3.07, 25, '2023-03-14 12:35:02', '2023-05-11 11:35:02'),
(826, 405, 27, NULL, NULL, NULL, 1, 3, 30.7, 0, 14, 4.3, 35, '2023-03-14 12:35:02', '2023-05-11 11:35:02'),
(827, 406, 27, NULL, NULL, NULL, 4, 3, 30.7, 0, 14, 17.19, 140, '2023-03-14 12:35:19', '2023-05-11 11:35:19'),
(828, 407, 27, NULL, NULL, NULL, 1, 3, 30.7, 0, 14, 4.3, 35, '2023-03-14 08:00:46', '2023-05-29 07:00:46'),
(829, 408, 112, NULL, NULL, NULL, 2, 0, 20, 0, 0, 0, 40, '2023-03-14 08:08:33', '2023-05-29 07:08:33'),
(830, 408, 27, NULL, NULL, NULL, 2, 3, 30.7, 0, 14, 8.6, 70, '2023-03-14 08:08:33', '2023-05-29 07:08:33'),
(831, 409, 27, NULL, NULL, NULL, 2, 3, 30.7, 0, 14, 8.6, 70, '2023-03-14 08:14:01', '2023-05-29 07:14:01'),
(832, 410, 27, NULL, NULL, NULL, 2, 3, 30.7, 0, 14, 8.6, 70, '2023-03-14 08:15:47', '2023-05-29 07:15:47'),
(833, 411, 27, NULL, NULL, NULL, 2, 3, 30.7, 0, 14, 8.6, 70, '2023-03-14 08:48:24', '2023-05-29 07:48:24'),
(834, 412, 27, NULL, NULL, NULL, 3, 3, 30.7, 0, 14, 12.89, 105, '2023-03-14 09:17:26', '2023-05-29 08:17:27'),
(835, 413, 112, NULL, NULL, NULL, 1, 0, 20, 0, 0, 0, 20, '2023-03-14 09:19:57', '2023-05-29 08:19:57'),
(836, 413, 27, NULL, NULL, NULL, 2, 3, 30.7, 0, 14, 8.6, 70, '2023-03-14 09:19:57', '2023-05-29 08:19:57'),
(837, 414, 27, NULL, NULL, NULL, 3, 3, 30.7, 0, 14, 12.89, 105, '2023-03-14 09:34:15', '2023-05-29 08:34:15'),
(838, 414, 112, NULL, NULL, NULL, 1, 0, 20, 0, 0, 0, 20, '2023-03-14 09:34:15', '2023-05-29 08:34:15'),
(839, 415, 45, NULL, NULL, NULL, 1, 3, 35, 0, 0, 0, 35, '2023-03-14 13:08:10', '2023-05-29 12:08:10'),
(840, 415, 27, NULL, NULL, NULL, 1, 3, 30.7, 0, 14, 4.3, 35, '2023-03-14 13:08:10', '2023-05-29 12:08:10'),
(841, 416, 27, NULL, NULL, NULL, 1, 3, 30.7, 0, 14, 4.3, 35, '2023-03-14 13:08:59', '2023-05-29 12:08:59'),
(842, 417, 27, NULL, NULL, NULL, 1, 3, 30.7, 0, 14, 4.3, 35, '2023-03-14 13:12:40', '2023-05-29 12:12:40'),
(843, 418, 27, NULL, NULL, NULL, 1, 3, 30.7, 0, 14, 4.3, 35, '2023-03-14 13:13:43', '2023-05-29 12:13:43'),
(844, 419, 27, NULL, NULL, NULL, 4, 3, 30.7, 0, 14, 17.19, 140, '2023-03-14 06:21:31', '2023-05-30 05:21:31'),
(845, 420, 27, NULL, NULL, NULL, 7, 3, 30.7, 0, 14, 30.09, 245, '2023-05-30 05:36:46', '2023-05-30 05:36:46'),
(846, 421, 116, NULL, NULL, NULL, 1, 3, 25, 0, 0, 0, 25, '2023-05-30 08:36:27', '2023-05-30 08:36:27'),
(847, 422, 115, NULL, NULL, NULL, 1, 3, 12, 0, 0, 0, 12, '2023-05-30 08:37:06', '2023-05-30 08:37:06'),
(848, 423, 117, NULL, NULL, NULL, 2, 0, 50, 0, 0, 0, 100, '2023-05-30 08:38:49', '2023-05-30 08:38:49'),
(849, 424, 27, NULL, NULL, NULL, 3, 3, 30.7, 0, 14, 12.89, 105, '2023-05-30 08:51:08', '2023-05-30 08:51:08'),
(850, 425, 27, NULL, NULL, NULL, 3, 3, 30.7, 0, 14, 12.89, 105, '2023-05-30 10:09:36', '2023-05-30 10:09:36'),
(851, 426, 115, NULL, NULL, NULL, 1, 3, 12, 0, 0, 0, 12, '2023-05-30 10:28:54', '2023-05-30 10:28:54'),
(852, 426, 27, NULL, NULL, NULL, 1, 3, 30.7, 0, 14, 4.3, 35, '2023-05-30 10:28:54', '2023-05-30 10:28:54'),
(853, 427, 115, NULL, NULL, NULL, 1, 3, 12, 0, 0, 0, 12, '2023-05-30 10:31:53', '2023-05-30 10:31:53'),
(854, 427, 116, NULL, NULL, NULL, 1, 3, 25, 0, 0, 0, 25, '2023-05-30 10:31:53', '2023-05-30 10:31:53'),
(855, 428, 117, NULL, NULL, NULL, 1, 0, 50, 0, 0, 0, 50, '2023-05-30 10:32:40', '2023-05-30 10:32:41'),
(856, 429, 27, NULL, NULL, NULL, 3, 3, 30.7, 0, 14, 12.89, 105, '2023-05-30 10:41:59', '2023-05-30 10:41:59'),
(857, 430, 27, NULL, NULL, NULL, 1, 3, 30.7, 0, 14, 4.3, 35, '2023-05-30 10:43:55', '2023-05-30 10:43:55'),
(858, 431, 27, NULL, NULL, NULL, 1, 3, 30.7, 0, 14, 4.3, 35, '2023-05-30 10:53:28', '2023-05-30 10:53:28'),
(859, 432, 27, NULL, NULL, NULL, 1, 3, 35, 0, 14, 4.9, 39.9, '2023-05-30 11:04:18', '2023-05-30 11:04:18'),
(860, 433, 116, NULL, NULL, NULL, 1, 3, 25, 0, 0, 0, 25, '2023-05-30 11:13:06', '2023-05-30 11:13:06'),
(861, 433, 27, NULL, NULL, NULL, 1, 3, 35, 0, 14, 4.9, 39.9, '2023-05-30 11:13:06', '2023-05-30 11:13:06'),
(862, 434, 28, NULL, NULL, NULL, 1, 6, 30.7, 0, 14, 4.3, 35, '2023-05-30 11:40:29', '2023-05-30 11:40:29'),
(863, 434, 27, NULL, NULL, NULL, 1, 3, 35, 0, 14, 4.9, 39.9, '2023-05-30 11:40:29', '2023-05-30 11:40:29'),
(864, 435, 28, NULL, NULL, NULL, 1, 6, 30.7, 0, 14, 4.3, 35, '2023-05-30 11:42:10', '2023-05-30 11:42:10'),
(865, 435, 27, NULL, NULL, NULL, 1, 3, 35, 0, 0, 0, 35, '2023-05-30 11:42:10', '2023-05-30 11:42:10'),
(866, 436, 27, NULL, NULL, NULL, 1, 3, 35, 0, 0, 0, 35, '2023-05-30 04:49:30', '2023-05-31 04:49:30'),
(867, 437, 28, NULL, NULL, NULL, 5, 6, 30.7, 0, 14, 21.49, 175, '2023-05-30 05:09:26', '2023-05-31 05:09:26'),
(868, 437, 27, NULL, NULL, NULL, 5, 3, 35, 0, 0, 0, 175, '2023-05-30 05:09:26', '2023-05-31 05:09:26'),
(869, 438, 27, NULL, NULL, NULL, 3, 3, 35, 0, 0, 0, 105, '2023-05-30 05:09:53', '2023-05-31 05:09:53'),
(870, 439, 28, NULL, NULL, NULL, 2, 6, 30.7, 0, 14, 8.6, 70, '2023-05-30 05:13:50', '2023-05-31 05:13:51'),
(871, 439, 27, NULL, NULL, NULL, 2, 3, 35, 0, 0, 0, 70, '2023-05-30 05:13:50', '2023-05-31 05:13:51'),
(872, 440, 28, NULL, NULL, NULL, 1, 6, 30.7, 0, 14, 4.3, 35, '2023-05-30 05:22:28', '2023-05-31 05:22:28'),
(873, 440, 27, NULL, NULL, NULL, 1, 3, 35, 0, 0, 0, 35, '2023-05-30 05:22:28', '2023-05-31 05:22:28'),
(874, 441, 28, NULL, NULL, NULL, 3, 6, 30.7, 0, 14, 12.89, 105, '2023-05-30 05:24:00', '2023-05-31 05:24:00'),
(875, 441, 27, NULL, NULL, NULL, 7, 3, 35, 0, 0, 0, 245, '2023-05-30 05:24:00', '2023-05-31 05:24:00'),
(876, 442, 27, NULL, NULL, NULL, 3, 3, 35, 0, 0, 0, 105, '2023-05-30 05:25:03', '2023-05-31 05:25:03'),
(877, 442, 28, NULL, NULL, NULL, 1, 6, 35, 0, 14, 4.9, 39.9, '2023-05-30 05:25:03', '2023-05-31 05:25:03'),
(878, 443, 28, NULL, NULL, NULL, 1, 6, 35, 0, 14, 4.9, 39.9, '2023-05-30 06:00:17', '2023-05-31 06:00:17'),
(879, 443, 27, NULL, NULL, NULL, 2, 3, 35, 0, 0, 0, 70, '2023-05-30 06:00:17', '2023-05-31 06:00:17'),
(880, 444, 28, NULL, NULL, NULL, 1, 6, 35, 0, 14, 4.9, 39.9, '2023-05-30 06:27:06', '2023-05-31 06:27:06'),
(881, 444, 27, NULL, NULL, NULL, 2, 3, 35, 0, 0, 0, 70, '2023-05-30 06:27:06', '2023-05-31 06:27:06'),
(882, 445, 27, NULL, NULL, NULL, 2, 3, 35, 0, 0, 0, 70, '2023-05-30 07:31:19', '2023-05-31 07:31:19'),
(883, 446, 27, NULL, NULL, NULL, 2, 3, 35, 0, 0, 0, 70, '2023-05-30 07:43:45', '2023-05-31 07:43:45'),
(884, 447, 28, NULL, NULL, NULL, 1, 6, 35, 0, 14, 4.9, 39.9, '2023-05-31 07:48:25', '2023-05-31 07:48:25'),
(885, 447, 27, NULL, NULL, NULL, 1, 3, 35, 0, 0, 0, 35, '2023-05-31 07:48:25', '2023-05-31 07:48:25'),
(886, 448, 28, NULL, NULL, NULL, 1, 6, 35, 0, 14, 4.9, 39.9, '2023-05-31 07:54:57', '2023-05-31 07:54:57'),
(887, 448, 27, NULL, NULL, NULL, 1, 3, 35, 0, 0, 0, 35, '2023-05-31 07:54:57', '2023-05-31 07:54:57'),
(888, 449, 28, NULL, NULL, NULL, 2, 6, 35, 0, 14, 9.8, 79.8, '2023-05-31 08:02:00', '2023-05-31 08:02:00'),
(889, 449, 27, NULL, NULL, NULL, 3, 3, 35, 0, 0, 0, 105, '2023-05-31 08:02:00', '2023-05-31 08:02:00'),
(890, 450, 117, NULL, NULL, NULL, 1, 0, 50, 0, 0, 0, 50, '2023-05-31 08:05:43', '2023-05-31 08:05:44'),
(891, 450, 107, NULL, NULL, NULL, 1, 4, 20, 0, 0, 0, 20, '2023-05-31 08:05:43', '2023-05-31 08:05:44'),
(892, 450, 81, NULL, NULL, NULL, 1, 4, 4.39, 0, 14, 0.61, 5, '2023-05-31 08:05:43', '2023-05-31 08:05:44'),
(893, 450, 80, NULL, NULL, NULL, 1, 4, 5, 0, 0, 0, 5, '2023-05-31 08:05:43', '2023-05-31 08:05:44'),
(894, 450, 77, NULL, NULL, NULL, 1, 1, 10, 0, 0, 0, 10, '2023-05-31 08:05:43', '2023-05-31 08:05:44'),
(895, 450, 76, NULL, NULL, NULL, 1, 4, 10, 0, 0, 0, 10, '2023-05-31 08:05:43', '2023-05-31 08:05:44'),
(896, 450, 108, NULL, NULL, NULL, 1, 4, 15, 0, 0, 0, 15, '2023-05-31 08:05:43', '2023-05-31 08:05:44'),
(897, 450, 110, NULL, NULL, NULL, 1, 4, 10, 0, 0, 0, 10, '2023-05-31 08:05:43', '2023-05-31 08:05:44'),
(898, 450, 113, NULL, NULL, NULL, 1, 4, 10, 0, 0, 0, 10, '2023-05-31 08:05:43', '2023-05-31 08:05:44'),
(899, 450, 114, NULL, NULL, NULL, 1, 4, 25, 0, 0, 0, 25, '2023-05-31 08:05:43', '2023-05-31 08:05:44'),
(900, 450, 115, NULL, NULL, NULL, 1, 3, 12, 0, 0, 0, 12, '2023-05-31 08:05:43', '2023-05-31 08:05:44'),
(901, 450, 116, NULL, NULL, NULL, 1, 3, 25, 0, 0, 0, 25, '2023-05-31 08:05:43', '2023-05-31 08:05:44'),
(902, 450, 28, NULL, NULL, NULL, 1, 6, 35, 0, 14, 4.9, 39.9, '2023-05-31 08:05:43', '2023-05-31 08:05:44'),
(903, 450, 27, NULL, NULL, NULL, 1, 3, 35, 0, 0, 0, 35, '2023-05-31 08:05:43', '2023-05-31 08:05:44'),
(904, 451, 27, NULL, NULL, NULL, 1, 3, 35, 0, 0, 0, 35, '2023-05-31 08:12:10', '2023-05-31 08:12:10'),
(905, 452, 28, NULL, NULL, NULL, 1, 6, 35, 0, 14, 4.9, 39.9, '2023-05-31 08:48:54', '2023-05-31 08:48:54'),
(906, 452, 27, NULL, NULL, NULL, 1, 3, 35, 0, 0, 0, 35, '2023-05-31 08:48:54', '2023-05-31 08:48:54'),
(907, 453, 27, NULL, NULL, NULL, 1, 3, 35, 0, 15, 5.25, 40.25, '2023-05-31 05:45:25', '2023-06-01 05:45:25'),
(908, 454, 27, NULL, NULL, NULL, 1, 3, 30.43, 0, 15, 4.57, 35, '2023-05-31 05:46:09', '2023-06-01 05:46:09'),
(909, 455, 27, NULL, NULL, NULL, 1, 3, 30.43, 0, 15, 4.57, 35, '2023-05-31 05:53:41', '2023-06-01 05:53:41'),
(910, 456, 27, NULL, NULL, NULL, 1, 3, 30.43, 0, 15, 4.57, 35, '2023-05-31 05:53:48', '2023-06-01 05:53:48');

-- --------------------------------------------------------

--
-- Table structure for table `product_transfer`
--

DROP TABLE IF EXISTS `product_transfer`;
CREATE TABLE IF NOT EXISTS `product_transfer` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `transfer_id` int NOT NULL,
  `product_id` int NOT NULL,
  `product_batch_id` int DEFAULT NULL,
  `variant_id` int DEFAULT NULL,
  `imei_number` text COLLATE utf8mb4_unicode_ci,
  `qty` double NOT NULL,
  `purchase_unit_id` int NOT NULL,
  `net_unit_cost` double NOT NULL,
  `tax_rate` double NOT NULL,
  `tax` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `product_variants`
--

DROP TABLE IF EXISTS `product_variants`;
CREATE TABLE IF NOT EXISTS `product_variants` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `product_id` int NOT NULL,
  `variant_id` int NOT NULL,
  `position` int NOT NULL,
  `item_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `additional_price` double DEFAULT NULL,
  `qty` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `product_warehouse`
--

DROP TABLE IF EXISTS `product_warehouse`;
CREATE TABLE IF NOT EXISTS `product_warehouse` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `product_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_batch_id` int DEFAULT NULL,
  `variant_id` int DEFAULT NULL,
  `imei_number` text COLLATE utf8mb4_unicode_ci,
  `warehouse_id` int NOT NULL,
  `qty` double NOT NULL,
  `price` double DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7614226 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `product_warehouse`
--

INSERT INTO `product_warehouse` (`id`, `product_id`, `product_batch_id`, `variant_id`, `imei_number`, `warehouse_id`, `qty`, `price`, `created_at`, `updated_at`) VALUES
(1898133, '77', NULL, NULL, NULL, 3, 4, NULL, '2023-03-14 09:35:47', '2023-05-31 08:05:44'),
(1898134, '76', NULL, NULL, NULL, 3, 4, NULL, '2023-03-14 09:35:47', '2023-05-31 08:05:44'),
(1898711, '80', NULL, NULL, NULL, 3, 4, NULL, '2023-03-14 13:58:22', '2023-05-31 08:05:44'),
(1898712, '81', NULL, NULL, NULL, 3, 4, NULL, '2023-03-14 13:58:22', '2023-05-31 08:05:44'),
(2314779, '107', NULL, NULL, NULL, 3, 19, NULL, '2023-04-09 10:19:19', '2023-05-31 08:05:44'),
(2314780, '108', NULL, NULL, NULL, 3, 197.5, NULL, '2023-04-09 10:19:19', '2023-05-31 08:05:44'),
(2314781, '110', NULL, NULL, NULL, 3, 16, NULL, '2023-04-09 10:19:19', '2023-05-31 08:05:44'),
(2344536, '113', NULL, NULL, NULL, 3, 16, NULL, '2023-04-09 11:40:53', '2023-05-31 08:05:44'),
(2344537, '114', NULL, NULL, NULL, 3, 13, NULL, '2023-04-09 11:40:53', '2023-05-31 08:05:44'),
(6943475, '116', NULL, NULL, NULL, 3, 92.5, NULL, '2023-05-02 07:05:06', '2023-05-31 08:05:44'),
(6943484, '115', NULL, NULL, NULL, 3, 92.5, NULL, '2023-05-02 07:05:06', '2023-05-31 08:05:44'),
(7478466, '20', NULL, NULL, NULL, 3, 0, NULL, '2023-05-14 10:50:43', '2023-05-14 10:50:43'),
(7478467, '21', NULL, NULL, NULL, 3, 0, NULL, '2023-05-14 10:50:43', '2023-05-14 10:50:43'),
(7478469, '78', NULL, NULL, NULL, 3, 0, NULL, '2023-05-14 10:50:43', '2023-05-14 10:50:43'),
(7478475, '118', NULL, NULL, NULL, 3, 100, NULL, '2023-05-14 10:50:43', '2023-05-14 10:52:58'),
(7584340, '22', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584341, '23', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584342, '24', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584343, '25', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584344, '26', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584345, '27', NULL, NULL, NULL, 3, 44, NULL, '2023-05-30 08:06:08', '2023-06-01 05:53:48'),
(7584346, '28', NULL, NULL, NULL, 3, 79, NULL, '2023-05-30 08:06:08', '2023-05-31 08:53:02'),
(7584347, '29', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584348, '30', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584349, '31', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584350, '32', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584351, '33', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584352, '34', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584353, '35', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584354, '36', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584355, '37', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584356, '38', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584357, '39', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584358, '40', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584359, '41', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584360, '42', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584361, '43', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584362, '44', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584363, '45', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584364, '46', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584365, '47', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584366, '48', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584367, '49', NULL, NULL, NULL, 3, 1, NULL, '2023-05-30 08:06:08', '2023-05-31 08:52:47'),
(7584368, '50', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584369, '51', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584370, '52', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584371, '53', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584372, '54', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584373, '55', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584374, '56', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584375, '57', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584376, '58', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584377, '59', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584378, '60', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584379, '22', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584380, '61', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584381, '23', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584382, '62', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:08', '2023-05-30 08:06:08'),
(7584383, '24', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584384, '63', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584385, '25', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584386, '64', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584387, '26', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584388, '65', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584389, '27', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584390, '66', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584391, '28', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584392, '67', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584393, '29', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584394, '68', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584395, '30', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584396, '69', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584397, '31', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584398, '70', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584399, '32', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584400, '71', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584401, '33', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584402, '72', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584403, '34', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584404, '73', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584405, '35', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584406, '74', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584407, '36', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584409, '37', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584411, '38', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584412, '82', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584413, '39', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584414, '83', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584415, '40', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584416, '84', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584417, '41', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584418, '85', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584419, '42', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584420, '86', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584421, '43', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584422, '87', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584423, '44', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584424, '88', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584425, '45', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584426, '89', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584427, '46', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584428, '90', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584429, '47', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584430, '91', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584431, '48', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584432, '92', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584433, '49', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584434, '93', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584435, '50', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584436, '94', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584437, '51', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584438, '95', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584439, '52', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584440, '96', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584441, '53', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584442, '97', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584443, '54', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584444, '98', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584445, '55', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584446, '99', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584447, '56', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584448, '100', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584449, '57', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584450, '101', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584451, '58', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584452, '102', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584453, '59', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584454, '103', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584455, '60', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584456, '104', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584457, '61', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584458, '105', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584459, '106', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584460, '62', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584462, '63', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584464, '64', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584466, '65', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584468, '66', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584470, '67', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584473, '68', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584475, '69', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584477, '70', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584479, '71', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584480, '72', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584481, '73', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584482, '74', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584485, '82', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584486, '83', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584487, '84', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584488, '85', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584489, '86', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584490, '87', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584491, '88', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584492, '89', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584493, '90', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584494, '91', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584495, '92', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584496, '93', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584497, '94', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584498, '95', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584499, '96', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584500, '97', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584501, '98', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584502, '99', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584503, '100', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584504, '101', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584505, '102', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584506, '103', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584507, '104', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584508, '105', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7584509, '106', NULL, NULL, NULL, 3, 0, NULL, '2023-05-30 08:06:09', '2023-05-30 08:06:09'),
(7614220, '75', NULL, NULL, NULL, 3, 0, NULL, '2023-06-01 06:48:15', '2023-06-01 06:48:15'),
(7614221, '79', NULL, NULL, NULL, 3, 0, NULL, '2023-06-01 06:48:15', '2023-06-01 06:48:15'),
(7614222, '109', NULL, NULL, NULL, 3, 0, NULL, '2023-06-01 06:48:15', '2023-06-01 06:48:15'),
(7614223, '111', NULL, NULL, NULL, 3, 0, NULL, '2023-06-01 06:48:15', '2023-06-01 06:48:15'),
(7614224, '112', NULL, NULL, NULL, 3, 0, NULL, '2023-06-01 06:48:15', '2023-06-01 06:48:15'),
(7614225, '117', NULL, NULL, NULL, 3, 0, NULL, '2023-06-01 06:48:15', '2023-06-01 06:48:15');

-- --------------------------------------------------------

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
CREATE TABLE IF NOT EXISTS `purchases` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int NOT NULL,
  `warehouse_id` int NOT NULL,
  `supplier_id` int DEFAULT NULL,
  `item` int NOT NULL,
  `total_qty` double NOT NULL,
  `total_discount` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_cost` double NOT NULL,
  `order_tax_rate` double DEFAULT NULL,
  `order_tax` double DEFAULT NULL,
  `order_discount` double DEFAULT NULL,
  `shipping_cost` double DEFAULT NULL,
  `grand_total` double NOT NULL,
  `paid_amount` double NOT NULL,
  `status` int NOT NULL,
  `payment_status` int NOT NULL,
  `document` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `purchases`
--

INSERT INTO `purchases` (`id`, `reference_no`, `user_id`, `warehouse_id`, `supplier_id`, `item`, `total_qty`, `total_discount`, `total_tax`, `total_cost`, `order_tax_rate`, `order_tax`, `order_discount`, `shipping_cost`, `grand_total`, `paid_amount`, `status`, `payment_status`, `document`, `note`, `created_at`, `updated_at`) VALUES
(11, 'pr-20220916-113729', 1, 3, 3, 22, 689, 0, 648.46, 5570.08, 0, 0, NULL, NULL, 5570.08, 5570.08, 1, 2, NULL, NULL, '2022-09-16 11:37:29', '2022-09-16 11:38:47'),
(12, 'pr-20220921-121740', 1, 3, 3, 2, 115, 0, 50.75, 413.25, 0, 0, NULL, NULL, 413.25, 413.25, 1, 2, NULL, NULL, '2022-09-21 12:17:40', '2022-09-21 12:18:07'),
(13, 'pr-20220924-104846', 1, 3, 3, 1, 32, 0, 19.49, 158.72, 0, 0, NULL, NULL, 158.72, 158.72, 1, 2, NULL, NULL, '2022-09-24 22:48:46', '2022-09-24 22:49:13'),
(14, 'pr-20220924-105645', 1, 3, 3, 1, 50, 0, 11.79, 96, 0, 0, NULL, NULL, 96, 96, 1, 2, NULL, NULL, '2022-09-24 22:56:45', '2022-09-24 22:56:57'),
(15, 'pr-20220926-062707', 1, 3, 3, 4, 142, 0, 370.88, 3020, 0, 0, NULL, NULL, 3020, 3020, 1, 2, NULL, NULL, '2022-09-26 18:27:08', '2022-09-27 10:30:40'),
(16, 'pr-20220928-050849', 29, 3, NULL, 1, 475, 0, 98, 798, 0, 0, NULL, NULL, 798, 798, 1, 2, NULL, NULL, '2022-09-28 17:08:49', '2022-09-28 17:11:50'),
(17, 'pr-20220928-051411', 29, 3, NULL, 1, 105, 0, 56.09, 456.75, 0, 0, NULL, NULL, 456.75, 456.75, 1, 2, NULL, NULL, '2022-09-28 17:14:11', '2022-09-28 17:14:20'),
(18, 'pr-20220928-051521', 29, 3, NULL, 1, 82, 0, 34.84, 283.72, 0, 0, NULL, NULL, 283.72, 283.72, 1, 2, NULL, NULL, '2022-09-28 17:15:21', '2022-09-28 17:15:38'),
(19, 'pr-20220928-051637', 29, 3, NULL, 1, 144, 0, 169.95, 1383.84, 0, 0, NULL, NULL, 1383.84, 1383.84, 1, 2, NULL, NULL, '2022-09-28 17:16:37', '2022-09-28 17:16:44'),
(20, 'pr-20221008-062344', 29, 3, 3, 1, 2, 0, 3.33, 27.1, 0, 0, NULL, NULL, 27.1, 27.1, 1, 2, NULL, NULL, '2022-10-08 18:23:44', '2022-10-08 18:23:58'),
(21, 'pr-20221008-062627', 29, 3, NULL, 1, 8, 0, 13.31, 108.4, 0, 0, NULL, NULL, 108.4, 108.4, 1, 2, NULL, NULL, '2022-10-08 18:26:27', '2022-10-08 18:26:49'),
(22, 'pr-20221011-104903', 29, 3, NULL, 1, 1, 0, 1.46, 11.89, 0, 0, NULL, NULL, 11.89, 11.89, 1, 2, NULL, NULL, '2022-10-11 22:49:03', '2022-10-11 22:49:12'),
(23, 'pr-20221014-111241', 29, 3, NULL, 1, 50, 0, 23.46, 191, 0, 0, NULL, NULL, 191, 191, 1, 2, NULL, NULL, '2022-10-14 23:12:41', '2022-10-14 23:12:49'),
(24, 'pr-20221014-111331', 29, 3, NULL, 1, 242, 0, 43.69, 355.74, 0, 0, NULL, NULL, 355.74, 355.74, 1, 2, NULL, NULL, '2022-10-14 23:13:31', '2022-10-14 23:13:38'),
(25, 'pr-20221014-111439', 29, 3, NULL, 1, 75, 0, 28, 228, 0, 0, NULL, NULL, 228, 228, 1, 2, NULL, NULL, '2022-10-14 23:14:39', '2022-10-14 23:14:47'),
(26, 'pr-20221027-110404', 29, 3, NULL, 1, 60, 0, 62.12, 505.8, 0, 0, NULL, NULL, 505.8, 505.8, 1, 2, NULL, NULL, '2022-10-27 23:04:04', '2022-10-27 23:04:12'),
(27, 'pr-20221027-110439', 29, 3, NULL, 1, 400, 0, 63.37, 516, 0, 0, NULL, NULL, 516, 516, 1, 2, NULL, NULL, '2022-10-27 23:04:39', '2022-10-27 23:04:46'),
(28, 'pr-20221027-110521', 29, 3, NULL, 1, 135, 0, 44.27, 360.45, 0, 0, NULL, NULL, 360.45, 360.45, 1, 2, NULL, NULL, '2022-10-27 23:05:21', '2022-10-27 23:05:29'),
(29, 'pr-20221027-110555', 29, 3, NULL, 1, 120, 0, 49.37, 402, 0, 0, NULL, NULL, 402, 402, 1, 2, NULL, NULL, '2022-10-27 23:05:55', '2022-10-27 23:06:29'),
(30, 'pr-20221103-094518', 29, 3, NULL, 1, 140, 0, 19.43, 158.2, 0, 0, NULL, NULL, 158.2, 158.2, 1, 2, NULL, NULL, '2022-11-03 21:45:18', '2022-11-03 21:45:32'),
(31, 'pr-20221103-094620', 29, 3, NULL, 1, 144, 0, 51.99, 423.36, 0, 0, NULL, 20, 443.36, 443.36, 1, 2, NULL, NULL, '2022-11-03 21:46:20', '2022-11-03 21:46:33'),
(32, 'pr-20221103-094724', 29, 3, NULL, 1, 54, 0, 15.52, 126.36, 0, 0, NULL, NULL, 126.36, 126.36, 1, 2, NULL, NULL, '2022-11-03 21:47:24', '2022-11-03 21:47:36'),
(33, 'pr-20221108-100225', 29, 3, NULL, 1, 100, 0, 140, 1140, 0, 0, NULL, NULL, 1140, 1140, 1, 2, NULL, NULL, '2022-11-08 10:02:25', '2022-11-08 10:02:34'),
(34, 'pr-20221118-013114', 29, 3, NULL, 1, 400, 0, 48.63, 396, 0, 0, NULL, NULL, 396, 396, 1, 2, NULL, NULL, '2022-11-18 13:31:14', '2022-11-18 13:31:24'),
(35, 'pr-20221118-013152', 29, 3, NULL, 1, 144, 0, 45.63, 371.52, 0, 0, NULL, NULL, 371.52, 371.52, 1, 2, NULL, NULL, '2022-11-18 13:31:52', '2022-11-18 13:31:58'),
(36, 'pr-20221118-013224', 29, 3, NULL, 1, 216, 0, 54.38, 442.8, 0, 0, NULL, NULL, 442.8, 442.8, 1, 2, NULL, NULL, '2022-11-18 13:32:24', '2022-11-18 13:32:31'),
(37, 'pr-20221118-013433', 29, 3, NULL, 1, 200, 0, 279.02, 2272, 0, 0, NULL, NULL, 2272, 2272, 1, 2, NULL, NULL, '2022-11-18 13:34:33', '2022-11-18 13:34:39'),
(38, 'pr-20221119-013609', 29, 3, NULL, 1, 10, 0, 16.64, 135.5, 0, 0, NULL, NULL, 135.5, 135.5, 1, 2, NULL, NULL, '2022-11-19 13:36:09', '2022-11-19 13:36:17'),
(39, 'pr-20221119-013833', 29, 3, NULL, 1, 6, 0, 8.76, 71.34, 0, 0, NULL, NULL, 71.34, 71.34, 1, 2, NULL, NULL, '2022-11-19 13:38:33', '2022-11-19 13:38:40'),
(40, 'pr-20221119-014653', 29, 3, NULL, 1, 3, 0, 4.64, 37.8, 0, 0, NULL, NULL, 37.8, 37.8, 1, 2, NULL, NULL, '2022-11-19 13:46:53', '2022-11-19 13:46:59'),
(41, 'pr-20221125-101758', 29, 3, NULL, 1, 200, 0, 21.37, 174, 0, 0, NULL, NULL, 174, 174, 1, 2, NULL, NULL, '2022-11-25 22:17:58', '2022-11-25 22:18:11'),
(42, 'pr-20221125-101835', 29, 3, NULL, 1, 144, 0, 39.97, 325.44, 0, 0, NULL, NULL, 325.44, 325.44, 1, 2, NULL, NULL, '2022-11-25 22:18:35', '2022-11-25 22:18:43'),
(43, 'pr-20221125-101913', 29, 3, NULL, 1, 81, 0, 17.91, 145.8, 0, 0, NULL, NULL, 145.8, 145.8, 1, 2, NULL, NULL, '2022-11-25 22:19:13', '2022-11-25 22:19:21'),
(44, 'pr-20221127-112718', 29, 3, NULL, 1, 1, 0, 1.36, 11.05, 0, 0, NULL, NULL, 11.05, 11.05, 1, 2, NULL, NULL, '2022-11-27 11:27:18', '2022-11-27 11:27:29'),
(45, 'pr-20221127-112756', 29, 3, NULL, 1, 100, 0, 122.32, 996, 0, 0, NULL, NULL, 996, 996, 1, 2, NULL, NULL, '2022-11-27 11:27:56', '2022-11-27 11:28:03'),
(46, 'pr-20221127-113002', 29, 3, NULL, 1, 100, 0, 107.33, 874, 0, 0, NULL, NULL, 874, 874, 1, 2, NULL, NULL, '2022-11-27 11:30:02', '2022-11-27 11:30:12'),
(47, 'pr-20221130-082941', 29, 3, NULL, 1, 100, 0, 122.81, 1000, 0, 0, NULL, NULL, 1000, 1000, 1, 2, NULL, NULL, '2022-11-30 20:29:41', '2022-11-30 20:30:25'),
(48, 'pr-20221208-092012', 29, 3, 3, 3, 736, 0, 108.42, 882.88, 0, 0, NULL, NULL, 882.88, 882.88, 1, 2, NULL, NULL, '2022-12-08 21:20:12', '2022-12-08 21:28:06'),
(49, 'pr-20221212-021055', 29, 3, 3, 1, 72, 0, 15.39, 125.28, 0, 0, NULL, NULL, 125.28, 125.28, 1, 2, NULL, NULL, '2022-12-12 14:10:55', '2022-12-12 14:11:16'),
(50, 'pr-20221214-082439', 29, 3, NULL, 5, 60, 0, 44.2, 360, 0, 0, NULL, NULL, 360, 360, 1, 2, NULL, NULL, '2022-12-14 20:24:39', '2022-12-14 20:24:56'),
(51, 'pr-20221217-095731', 29, 3, NULL, 1, 60, 0, 54.45, 443.4, 0, 0, NULL, NULL, 443.4, 443.4, 1, 2, NULL, NULL, '2022-12-17 21:57:31', '2022-12-17 21:57:39'),
(52, 'pr-20221217-095806', 29, 3, NULL, 1, 200, 0, 16.46, 134, 0, 0, NULL, NULL, 134, 134, 1, 2, NULL, NULL, '2022-12-17 21:58:06', '2022-12-17 21:58:13'),
(53, 'pr-20221217-095844', 29, 3, NULL, 1, 135, 0, 23.04, 187.65, 0, 0, NULL, NULL, 187.65, 187.65, 1, 2, NULL, NULL, '2022-12-17 21:58:44', '2022-12-17 21:58:56'),
(54, 'pr-20221217-095928', 29, 3, NULL, 1, 120, 0, 22.55, 183.6, 0, 0, NULL, NULL, 183.6, 183.6, 1, 2, NULL, NULL, '2022-12-17 21:59:28', '2022-12-17 21:59:35'),
(55, 'pr-20221217-100705', 29, 3, NULL, 1, 6, 0, 3.88, 31.56, 0, 0, NULL, NULL, 31.56, 31.56, 1, 2, NULL, NULL, '2022-12-17 22:07:05', '2022-12-17 22:07:12'),
(56, 'pr-20221217-100749', 29, 3, NULL, 1, 6, 0, 3.88, 31.56, 0, 0, NULL, NULL, 31.56, 31.56, 1, 2, NULL, NULL, '2022-12-17 22:07:49', '2022-12-17 22:08:19'),
(57, 'pr-20221217-101040', 29, 3, NULL, 1, 5, 0, 3.23, 26.3, 0, 0, NULL, NULL, 26.3, 26.3, 1, 2, NULL, NULL, '2022-12-17 22:10:40', '2022-12-17 22:10:46'),
(58, 'pr-20221226-072538', 29, 3, NULL, 2, 31, 0, 32.36, 263.5, 0, 0, NULL, NULL, 263.5, 263.5, 1, 2, NULL, NULL, '2022-12-26 19:25:38', '2022-12-26 19:29:31'),
(59, 'pr-20221229-060252', 29, 3, NULL, 4, 50, 0, 51.72, 421.12, 0, 0, NULL, NULL, 421.12, 421.12, 1, 2, NULL, NULL, '2022-12-29 18:02:52', '2022-12-29 18:03:04'),
(60, 'pr-20221229-090012', 1, 3, 3, 1, 15, 0, 46.05, 375, 0, 0, NULL, NULL, 375, 375, 1, 2, NULL, NULL, '2022-12-29 21:00:12', '2022-12-29 21:00:22'),
(61, 'pr-20221230-093559', 29, 3, NULL, 1, 36, 0, 28.74, 234, 0, 0, NULL, NULL, 234, 234, 1, 2, NULL, NULL, '2022-12-30 21:35:59', '2022-12-30 21:36:07'),
(62, 'pr-20230103-090511', 29, 3, NULL, 1, 4, 0, 11.76, 95.8, 0, 0, NULL, NULL, 95.8, 95.8, 1, 2, NULL, NULL, '2023-01-03 21:05:11', '2023-01-03 21:05:20'),
(63, 'pr-20230103-090542', 29, 3, NULL, 1, 5, 0, 13.17, 107.25, 0, 0, NULL, NULL, 107.25, 107.25, 1, 2, NULL, NULL, '2023-01-03 21:05:42', '2023-01-03 21:05:50'),
(64, 'pr-20230106-060616', 29, 3, NULL, 5, 866, 0, 479.7, 3906.15, 0, 0, NULL, NULL, 3906.15, 3906.15, 1, 2, NULL, NULL, '2023-01-06 18:06:16', '2023-01-06 18:06:34'),
(65, 'pr-20230120-041934', 29, 3, NULL, 4, 659, 0, 351.94, 2865.84, 0, 0, NULL, NULL, 2865.84, 2865.84, 1, 2, NULL, NULL, '2023-01-20 16:19:34', '2023-01-20 16:19:58'),
(66, 'pr-20230314-113547', 1, 3, 3, 2, 190, 0, 0, 950, 0, 0, NULL, NULL, 950, 950, 1, 2, NULL, NULL, '2023-03-14 09:35:47', '2023-03-14 09:36:01'),
(67, 'pr-20230314-035822', 1, 3, 3, 2, 90, 0, 0, 220, 0, 0, NULL, NULL, 220, 220, 1, 2, NULL, NULL, '2023-03-14 13:58:22', '2023-03-14 13:58:34'),
(68, 'pr-20230409-121919', 1, 3, 3, 3, 120, 0, 0, 1150, 0, 0, NULL, NULL, 1150, 0, 1, 1, NULL, NULL, '2023-04-09 10:19:19', '2023-04-09 10:19:19'),
(69, 'pr-20230409-013225', 1, 3, NULL, 3, 120, 0, 0, 1150, 0, 0, NULL, NULL, 1150, 1150, 1, 2, NULL, NULL, '2023-04-09 11:32:25', '2023-04-09 11:32:36'),
(70, 'pr-20230409-014053', 1, 3, NULL, 2, 40, 0, 0, 540, 0, 0, NULL, NULL, 540, 540, 1, 2, NULL, NULL, '2023-04-09 11:40:53', '2023-04-09 11:41:02'),
(71, 'pr-20230502-090506', 1, 3, NULL, 2, 117, 0, 0, 1340, 0, 0, NULL, NULL, 1340, 0, 1, 1, NULL, NULL, '2023-05-02 07:05:06', '2023-05-02 07:05:06'),
(72, 'pr-20230507-023332', 1, 3, 3, 2, 400, 0, 1051.72, 8564, 0, 0, NULL, NULL, 8564, 0, 1, 1, NULL, NULL, '2023-05-07 11:33:32', '2023-05-07 11:33:32'),
(73, 'pr-20230514-014959', 1, 3, 3, 1, 100, 0, 0, 1000, 0, 0, NULL, NULL, 1000, 0, 1, 1, NULL, NULL, '2023-05-14 10:49:59', '2023-05-14 10:49:59'),
(74, 'pr-20230514-015258', 1, 3, 3, 1, 100, 0, 0, 1000, 0, 0, NULL, NULL, 1000, 0, 1, 1, NULL, NULL, '2023-05-14 10:52:58', '2023-05-14 10:52:58'),
(75, 'pr-20230530-110003', 1, 3, 3, 1, 300, 0, 775.53, 6315, 0, 0, NULL, NULL, 6315, 0, 1, 1, NULL, NULL, '2023-05-30 08:00:03', '2023-05-30 08:00:03'),
(76, 'pr-20230530-113343', 1, 3, 3, 2, 110, 0, 0, 2050, 0, 0, NULL, NULL, 2050, 0, 1, 1, NULL, NULL, '2023-05-30 08:33:43', '2023-05-30 08:33:43'),
(77, 'pr-20230530-114511', 1, 3, 3, 1, 100, 0, 226.7, 1846, 0, 0, NULL, NULL, 1846, 0, 1, 1, NULL, NULL, '2023-05-30 08:45:11', '2023-05-30 08:45:11'),
(78, 'pr-20230530-023436', 1, 3, 3, 1, 100, 0, 263.42, 2145, 0, 0, NULL, NULL, 2145, 0, 1, 1, NULL, NULL, '2023-05-30 11:34:36', '2023-05-30 11:34:36');

-- --------------------------------------------------------

--
-- Table structure for table `purchase_product_return`
--

DROP TABLE IF EXISTS `purchase_product_return`;
CREATE TABLE IF NOT EXISTS `purchase_product_return` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `return_id` int NOT NULL,
  `product_id` int NOT NULL,
  `product_batch_id` int DEFAULT NULL,
  `variant_id` int DEFAULT NULL,
  `imei_number` text COLLATE utf8mb4_unicode_ci,
  `qty` double NOT NULL,
  `purchase_unit_id` int NOT NULL,
  `net_unit_cost` double NOT NULL,
  `discount` double NOT NULL,
  `tax_rate` double NOT NULL,
  `tax` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `quotations`
--

DROP TABLE IF EXISTS `quotations`;
CREATE TABLE IF NOT EXISTS `quotations` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int NOT NULL,
  `biller_id` int NOT NULL,
  `supplier_id` int DEFAULT NULL,
  `customer_id` int NOT NULL,
  `warehouse_id` int NOT NULL,
  `item` int NOT NULL,
  `total_qty` double NOT NULL,
  `total_discount` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_price` double NOT NULL,
  `order_tax_rate` double DEFAULT NULL,
  `order_tax` double DEFAULT NULL,
  `order_discount` double DEFAULT NULL,
  `shipping_cost` double DEFAULT NULL,
  `grand_total` double NOT NULL,
  `quotation_status` int NOT NULL,
  `document` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `returns`
--

DROP TABLE IF EXISTS `returns`;
CREATE TABLE IF NOT EXISTS `returns` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int NOT NULL,
  `cash_register_id` int DEFAULT NULL,
  `customer_id` int NOT NULL,
  `warehouse_id` int NOT NULL,
  `biller_id` int NOT NULL,
  `account_id` int NOT NULL,
  `sale_id` bigint DEFAULT NULL,
  `item` int NOT NULL,
  `total_qty` double NOT NULL,
  `total_discount` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_price` double NOT NULL,
  `order_tax_rate` double DEFAULT NULL,
  `order_tax` double DEFAULT NULL,
  `grand_total` double NOT NULL,
  `document` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `return_note` text COLLATE utf8mb4_unicode_ci,
  `staff_note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=86 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `returns`
--

INSERT INTO `returns` (`id`, `reference_no`, `user_id`, `cash_register_id`, `customer_id`, `warehouse_id`, `biller_id`, `account_id`, `sale_id`, `item`, `total_qty`, `total_discount`, `total_tax`, `total_price`, `order_tax_rate`, `order_tax`, `grand_total`, `document`, `return_note`, `staff_note`, `created_at`, `updated_at`) VALUES
(81, 'rr-20230510-120302', 1, 15, 2, 3, 10, 1, 401, 2, 2, 0, 8.6, 70, 0, 0, 60, NULL, NULL, NULL, '2023-05-10 09:03:02', '2023-05-10 09:03:02'),
(82, 'rr-20230510-120955', 1, 15, 2, 3, 10, 1, 402, 2, 2, 0, 7.37, 60, 0, 0, 57.5, NULL, NULL, NULL, '2023-05-10 09:09:55', '2023-05-10 09:09:55'),
(83, 'rr-20230511-023601', 1, 15, 2, 3, 10, 1, 403, 2, 2, 0, 7.37, 60, 0, 0, 50, NULL, NULL, NULL, '2023-05-11 11:36:01', '2023-05-11 11:36:01'),
(84, 'rr-20230531-115247', 1, 18, 2, 3, 10, 1, 405, 2, 2, 0, 7.37, 60, 0, 0, 50, NULL, NULL, NULL, '2023-05-31 08:52:47', '2023-05-31 08:52:47'),
(85, 'rr-20230531-115302', 1, 18, 2, 3, 10, 1, 452, 2, 2, 0, 4.9, 74.9, NULL, 0, 74.9, NULL, NULL, NULL, '2023-05-31 08:53:02', '2023-05-31 08:53:02');

-- --------------------------------------------------------

--
-- Table structure for table `return_purchases`
--

DROP TABLE IF EXISTS `return_purchases`;
CREATE TABLE IF NOT EXISTS `return_purchases` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `supplier_id` int DEFAULT NULL,
  `warehouse_id` int NOT NULL,
  `user_id` int NOT NULL,
  `account_id` int NOT NULL,
  `item` int NOT NULL,
  `total_qty` double NOT NULL,
  `total_discount` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_cost` double NOT NULL,
  `order_tax_rate` double DEFAULT NULL,
  `order_tax` double DEFAULT NULL,
  `grand_total` double NOT NULL,
  `document` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `return_note` text COLLATE utf8mb4_unicode_ci,
  `staff_note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `reward_point_settings`
--

DROP TABLE IF EXISTS `reward_point_settings`;
CREATE TABLE IF NOT EXISTS `reward_point_settings` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `per_point_amount` double NOT NULL,
  `minimum_amount` double NOT NULL,
  `duration` int DEFAULT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `reward_point_settings`
--

INSERT INTO `reward_point_settings` (`id`, `per_point_amount`, `minimum_amount`, `duration`, `type`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 300, 1000, 1, 'Year', 1, '2021-06-08 15:40:15', '2021-06-27 05:20:55');

-- --------------------------------------------------------

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
CREATE TABLE IF NOT EXISTS `roles` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `roles`
--

INSERT INTO `roles` (`id`, `name`, `description`, `guard_name`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'Admin', 'admin can access all data...', 'web', 1, '2018-06-01 23:46:44', '2018-06-02 23:13:05'),
(2, 'Owner', 'Owner of shop...', 'web', 1, '2018-10-22 02:38:13', '2018-10-22 02:38:13'),
(4, 'staff', 'staff has specific acess...', 'web', 1, '2018-06-02 00:05:27', '2018-06-02 00:05:27'),
(5, 'Customer', NULL, 'web', 1, '2020-11-05 06:43:16', '2020-11-15 00:24:15'),
(6, 'مدير', NULL, 'web', 1, '2021-11-29 19:23:55', '2021-11-29 19:23:55'),
(7, 'Branch manager', NULL, 'web', 1, '2022-09-01 18:18:54', '2022-09-01 18:18:54');

-- --------------------------------------------------------

--
-- Table structure for table `role_has_permissions`
--

DROP TABLE IF EXISTS `role_has_permissions`;
CREATE TABLE IF NOT EXISTS `role_has_permissions` (
  `permission_id` int UNSIGNED NOT NULL,
  `role_id` int UNSIGNED NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `role_has_permissions`
--

INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
(4, 1),
(5, 1),
(6, 1),
(7, 1),
(8, 1),
(9, 1),
(10, 1),
(11, 1),
(12, 1),
(13, 1),
(14, 1),
(15, 1),
(16, 1),
(17, 1),
(18, 1),
(19, 1),
(20, 1),
(21, 1),
(22, 1),
(23, 1),
(24, 1),
(25, 1),
(26, 1),
(27, 1),
(28, 1),
(29, 1),
(30, 1),
(31, 1),
(32, 1),
(33, 1),
(34, 1),
(35, 1),
(36, 1),
(37, 1),
(38, 1),
(39, 1),
(40, 1),
(41, 1),
(42, 1),
(43, 1),
(44, 1),
(45, 1),
(46, 1),
(47, 1),
(48, 1),
(49, 1),
(50, 1),
(51, 1),
(52, 1),
(53, 1),
(54, 1),
(55, 1),
(56, 1),
(57, 1),
(58, 1),
(59, 1),
(60, 1),
(61, 1),
(62, 1),
(63, 1),
(64, 1),
(65, 1),
(66, 1),
(67, 1),
(68, 1),
(69, 1),
(70, 1),
(71, 1),
(72, 1),
(73, 1),
(74, 1),
(75, 1),
(76, 1),
(77, 1),
(78, 1),
(79, 1),
(80, 1),
(81, 1),
(82, 1),
(83, 1),
(84, 1),
(85, 1),
(86, 1),
(87, 1),
(88, 1),
(89, 1),
(90, 1),
(91, 1),
(92, 1),
(93, 1),
(94, 1),
(95, 1),
(96, 1),
(97, 1),
(98, 1),
(99, 1),
(100, 1),
(101, 1),
(102, 1),
(103, 1),
(104, 1),
(105, 1),
(106, 1),
(107, 1),
(108, 1),
(4, 2),
(5, 2),
(6, 2),
(7, 2),
(8, 2),
(9, 2),
(10, 2),
(11, 2),
(12, 2),
(13, 2),
(14, 2),
(15, 2),
(16, 2),
(17, 2),
(18, 2),
(19, 2),
(20, 2),
(21, 2),
(22, 2),
(23, 2),
(24, 2),
(25, 2),
(26, 2),
(27, 2),
(28, 2),
(29, 2),
(30, 2),
(31, 2),
(32, 2),
(33, 2),
(34, 2),
(35, 2),
(36, 2),
(37, 2),
(38, 2),
(39, 2),
(40, 2),
(41, 2),
(42, 2),
(43, 2),
(44, 2),
(45, 2),
(46, 2),
(47, 2),
(48, 2),
(49, 2),
(50, 2),
(51, 2),
(52, 2),
(53, 2),
(54, 2),
(55, 2),
(56, 2),
(57, 2),
(58, 2),
(59, 2),
(60, 2),
(61, 2),
(62, 2),
(63, 2),
(64, 2),
(65, 2),
(66, 2),
(67, 2),
(68, 2),
(69, 2),
(70, 2),
(71, 2),
(72, 2),
(73, 2),
(74, 2),
(75, 2),
(76, 2),
(77, 2),
(78, 2),
(79, 2),
(80, 2),
(81, 2),
(82, 2),
(83, 2),
(84, 2),
(85, 2),
(86, 2),
(87, 2),
(88, 2),
(89, 2),
(90, 2),
(91, 2),
(92, 2),
(93, 2),
(94, 2),
(95, 2),
(96, 2),
(97, 2),
(98, 2),
(99, 2),
(100, 2),
(101, 2),
(102, 2),
(103, 2),
(104, 2),
(105, 2),
(12, 4),
(13, 4),
(4, 6),
(5, 6),
(6, 6),
(7, 6),
(8, 6),
(9, 6),
(10, 6),
(11, 6),
(12, 6),
(13, 6),
(14, 6),
(15, 6),
(20, 6),
(21, 6),
(22, 6),
(23, 6),
(24, 6),
(25, 6),
(26, 6),
(27, 6),
(28, 6),
(29, 6),
(30, 6),
(31, 6),
(32, 6),
(33, 6),
(34, 6),
(35, 6),
(36, 6),
(37, 6),
(38, 6),
(39, 6),
(40, 6),
(41, 6),
(42, 6),
(43, 6),
(44, 6),
(45, 6),
(46, 6),
(47, 6),
(48, 6),
(49, 6),
(50, 6),
(51, 6),
(52, 6),
(53, 6),
(54, 6),
(61, 6),
(62, 6),
(63, 6),
(64, 6),
(65, 6),
(66, 6),
(67, 6),
(68, 6),
(69, 6),
(70, 6),
(71, 6),
(72, 6),
(73, 6),
(74, 6),
(75, 6),
(76, 6),
(77, 6),
(78, 6),
(79, 6),
(80, 6),
(81, 6),
(82, 6),
(84, 6),
(85, 6),
(86, 6),
(87, 6),
(88, 6),
(89, 6),
(90, 6),
(91, 6),
(92, 6),
(93, 6),
(94, 6),
(95, 6),
(96, 6),
(97, 6),
(98, 6),
(99, 6),
(100, 6),
(101, 6),
(102, 6),
(103, 6),
(105, 6),
(7, 7),
(8, 7),
(9, 7),
(12, 7),
(24, 7),
(25, 7),
(26, 7),
(36, 7),
(37, 7),
(38, 7),
(39, 7),
(40, 7),
(45, 7),
(46, 7),
(47, 7),
(48, 7),
(49, 7),
(50, 7),
(51, 7),
(52, 7),
(53, 7),
(77, 7),
(90, 7);

-- --------------------------------------------------------

--
-- Table structure for table `sales`
--

DROP TABLE IF EXISTS `sales`;
CREATE TABLE IF NOT EXISTS `sales` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int NOT NULL,
  `cash_register_id` int DEFAULT NULL,
  `customer_id` int NOT NULL,
  `membership_number` bigint NOT NULL DEFAULT '0',
  `table_id` int DEFAULT NULL,
  `discount_eng` double NOT NULL DEFAULT '0',
  `warehouse_id` int NOT NULL,
  `biller_id` int DEFAULT NULL,
  `item` int NOT NULL,
  `total_qty` double NOT NULL,
  `total_discount` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_price` double NOT NULL,
  `grand_total` double NOT NULL,
  `order_tax_rate` double DEFAULT NULL,
  `order_tax` double DEFAULT NULL,
  `order_discount` double DEFAULT NULL,
  `coupon_id` int DEFAULT NULL,
  `coupon_discount` double DEFAULT NULL,
  `shipping_cost` double DEFAULT NULL,
  `sale_status` int NOT NULL,
  `payment_status` int NOT NULL,
  `document` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_amount` double DEFAULT NULL,
  `sale_note` text COLLATE utf8mb4_unicode_ci,
  `staff_note` text COLLATE utf8mb4_unicode_ci,
  `stored_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=457 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `sales`
--

INSERT INTO `sales` (`id`, `reference_no`, `user_id`, `cash_register_id`, `customer_id`, `membership_number`, `table_id`, `discount_eng`, `warehouse_id`, `biller_id`, `item`, `total_qty`, `total_discount`, `total_tax`, `total_price`, `grand_total`, `order_tax_rate`, `order_tax`, `order_discount`, `coupon_id`, `coupon_discount`, `shipping_cost`, `sale_status`, `payment_status`, `document`, `paid_amount`, `sale_note`, `staff_note`, `stored_at`, `created_at`, `updated_at`) VALUES
(401, 'posr-20230314-120208', 1, 15, 2, 0, 0, 0, 3, 10, 2, 2, 0, 8.6, 70, 60, 0, 0, 10, NULL, NULL, NULL, 4, 4, NULL, 60, NULL, NULL, '2023-05-10 09:02:08', '2023-05-10 09:02:08', '2023-05-10 09:03:02'),
(402, 'posr-20230314-120932', 1, 15, 2, 0, 0, 0, 3, 10, 2, 2, 0, 7.37, 60, 57.5, 0, 0, 2.5, NULL, NULL, NULL, 4, 4, NULL, 57.5, NULL, NULL, '2023-05-10 09:09:32', '2023-05-10 09:09:32', '2023-05-10 09:09:55'),
(403, 'posr-20230314-091825', 1, 15, 2, 0, 0, 0, 3, 10, 2, 2, 0, 7.37, 60, 50, 0, 0, 10, NULL, NULL, NULL, 4, 4, NULL, 50, NULL, NULL, '2023-05-11 06:18:25', '2023-05-11 06:18:25', '2023-05-11 11:36:01'),
(404, 'posr-20230314-091848', 1, 15, 2, 0, 0, 0, 3, 10, 2, 2, 0, 8.6, 70, 63, 0, 0, 7, NULL, NULL, NULL, 1, 4, NULL, 63, NULL, NULL, '2023-05-11 06:18:48', '2023-05-11 06:18:48', '2023-05-11 06:18:48'),
(405, 'posr-20230314-023502', 1, 15, 2, 0, 0, 0, 3, 10, 2, 2, 0, 7.37, 60, 50, 0, 0, 10, NULL, NULL, NULL, 4, 4, NULL, 50, NULL, NULL, '2023-05-11 11:35:02', '2023-05-11 11:35:02', '2023-05-31 08:52:47'),
(406, 'posr-20230314-023519', 1, 15, 2, 0, 0, 0, 3, 10, 1, 4, 0, 17.19, 140, 140, 0, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 140, NULL, NULL, '2023-05-11 11:35:19', '2023-05-11 11:35:19', '2023-05-11 11:35:19'),
(407, 'posr-20230314-100046', 1, 15, 2, 0, 0, 0, 3, 10, 1, 1, 0, 4.3, 35, 35, 0, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 35, NULL, NULL, '2023-05-29 07:00:46', '2023-05-29 07:00:46', '2023-05-29 07:00:46'),
(408, 'posr-20230314-100833', 1, 15, 2, 0, 0, 0, 3, 10, 2, 4, 0, 8.6, 110, 110, 0, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 110, NULL, NULL, '2023-05-29 07:08:33', '2023-05-29 07:08:33', '2023-05-29 07:08:33'),
(409, 'posr-20230314-101401', 1, 15, 2, 0, 0, 0, 3, 10, 1, 2, 0, 8.6, 70, 79.8, 14, 9.8, -9.8, NULL, NULL, NULL, 1, 4, NULL, 79.8, NULL, NULL, '2023-05-29 07:14:01', '2023-05-29 07:14:01', '2023-05-29 07:14:01'),
(410, 'posr-20230314-101547', 1, 15, 2, 0, 0, 0, 3, 10, 1, 2, 0, 8.6, 70, 71.82, 14, 8.82, -1.82, NULL, NULL, NULL, 1, 4, NULL, 71.82, NULL, NULL, '2023-05-29 07:15:47', '2023-05-29 07:15:47', '2023-05-29 07:15:47'),
(411, 'posr-20230314-104824', 1, 15, 2, 0, 0, 0, 3, 10, 1, 2, 0, 8.6, 70, 68.4, 14, 8.4, 10, NULL, NULL, NULL, 1, 4, NULL, 68.4, NULL, NULL, '2023-05-29 07:48:24', '2023-05-29 07:48:24', '2023-05-29 07:48:24'),
(412, 'posr-20230314-111726', 1, 15, 2, 0, 0, 0, 3, 10, 1, 3, 0, 12.89, 105, 94.5, 0, 0, 10.5, NULL, NULL, NULL, 1, 4, NULL, 94.5, NULL, NULL, '2023-05-29 08:17:26', '2023-05-29 08:17:26', '2023-05-29 08:17:26'),
(413, 'posr-20230314-111957', 1, 15, 2, 0, 0, 0, 3, 10, 2, 3, 0, 8.6, 90, 92.34, 14, 11.34, 9, NULL, NULL, NULL, 1, 4, NULL, 92.34, NULL, NULL, '2023-05-29 08:19:57', '2023-05-29 08:19:57', '2023-05-29 08:19:57'),
(414, 'posr-20230314-113415', 1, 15, 2, 0, 0, 0, 3, 10, 2, 4, 0, 12.89, 125, 125, 0, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 125, NULL, NULL, '2023-05-29 08:34:15', '2023-05-29 08:34:15', '2023-05-29 08:34:15'),
(415, 'posr-20230314-030810', 1, 15, 2, 0, 0, 0, 3, 10, 2, 2, 0, 4.3, 70, 79.8, 14, 9.8, 0, NULL, NULL, NULL, 1, 4, NULL, 79.8, NULL, NULL, '2023-05-29 12:08:10', '2023-05-29 12:08:10', '2023-05-29 12:08:10'),
(416, 'posr-20230314-030859', 1, 15, 2, 0, 0, 0, 3, 10, 1, 1, 0, 4.3, 35, 35, 0, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 35, NULL, NULL, '2023-05-29 12:08:59', '2023-05-29 12:08:59', '2023-05-29 12:08:59'),
(417, 'posr-20230314-031240', 1, 15, 2, 0, 0, 0, 3, 10, 1, 1, 0, 4.3, 35, 35, 0, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 35, NULL, NULL, '2023-05-29 12:12:40', '2023-05-29 12:12:40', '2023-05-29 12:12:40'),
(418, 'posr-20230314-031343', 1, 15, 2, 0, 0, 0, 3, 10, 1, 1, 0, 4.3, 35, 35.91, 14, 4.41, 3.5, NULL, NULL, NULL, 1, 4, NULL, 35.91, NULL, NULL, '2023-05-29 12:13:43', '2023-05-29 12:13:43', '2023-05-29 12:13:43'),
(419, 'posr-20230314-082131', 1, 15, 2, 0, 0, 0, 3, 10, 1, 4, 0, 17.19, 140, 140, 0, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 140, NULL, NULL, '2023-05-30 05:21:31', '2023-05-30 05:21:31', '2023-05-30 05:21:31'),
(420, 'posr-20230530-083646', 1, 16, 2, 0, 0, 0, 3, 10, 1, 7, 0, 30.09, 245, 245, 0, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 245, NULL, NULL, '2023-05-30 05:36:46', '2023-05-30 05:36:46', '2023-05-30 05:36:46'),
(421, 'posr-20230530-113627', 1, 17, 2, 0, 0, 0, 3, 10, 1, 1, 0, 0, 25, 25, 0, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 25, NULL, NULL, '2023-05-30 08:36:27', '2023-05-30 08:36:27', '2023-05-30 08:36:27'),
(422, 'posr-20230530-113706', 1, 17, 2, 0, 0, 0, 3, 10, 1, 1, 0, 0, 12, 12, 0, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 12, NULL, NULL, '2023-05-30 08:37:06', '2023-05-30 08:37:06', '2023-05-30 08:37:06'),
(423, 'posr-20230530-113849', 1, 17, 2, 0, 0, 0, 3, 10, 1, 2, 0, 0, 100, 100, 0, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 100, NULL, NULL, '2023-05-30 08:38:49', '2023-05-30 08:38:49', '2023-05-30 08:38:49'),
(424, 'posr-20230530-115108', 1, 17, 2, 0, 0, 0, 3, 10, 1, 3, 0, 12.89, 105, 119.7, NULL, 14.7, 0, NULL, NULL, NULL, 1, 4, NULL, 119.7, NULL, NULL, '2023-05-30 08:51:08', '2023-05-30 08:51:08', '2023-05-30 08:51:08'),
(425, 'posr-20230530-010936', 1, 17, 2, 0, 0, 0, 3, 10, 1, 3, 0, 12.89, 105, 119.7, NULL, 14.7, 0, NULL, NULL, NULL, 1, 4, NULL, 119.7, NULL, NULL, '2023-05-30 10:09:36', '2023-05-30 10:09:36', '2023-05-30 10:09:36'),
(426, 'posr-20230530-012854', 1, 17, 2, 0, 0, 0, 3, 10, 2, 2, 0, 4.3, 47, 53.58, NULL, 6.58, 0, NULL, NULL, NULL, 1, 4, NULL, 53.58, NULL, NULL, '2023-05-30 10:28:54', '2023-05-30 10:28:54', '2023-05-30 10:28:54'),
(427, 'posr-20230530-013153', 1, 17, 2, 0, 0, 0, 3, 10, 2, 2, 0, 0, 37, 42.18, NULL, 5.18, 0, NULL, NULL, NULL, 1, 4, NULL, 42.18, NULL, NULL, '2023-05-30 10:31:53', '2023-05-30 10:31:53', '2023-05-30 10:31:53'),
(428, 'posr-20230530-013240', 1, 17, 2, 0, 0, 0, 3, 10, 1, 1, 0, 0, 50, 57, NULL, 7, 0, NULL, NULL, NULL, 1, 4, NULL, 57, NULL, NULL, '2023-05-30 10:32:40', '2023-05-30 10:32:40', '2023-05-30 10:32:40'),
(429, 'posr-20230530-014159', 1, 17, 2, 0, 0, 0, 3, 10, 1, 3, 0, 12.89, 105, 119.7, NULL, 14.7, 0, NULL, NULL, NULL, 1, 4, NULL, 119.7, NULL, NULL, '2023-05-30 10:41:59', '2023-05-30 10:41:59', '2023-05-30 10:41:59'),
(430, 'posr-20230530-014355', 1, 17, 2, 0, 0, 0, 3, 10, 1, 1, 0, 4.3, 35, 39.9, NULL, 4.9, 0, NULL, NULL, NULL, 1, 4, NULL, 39.9, NULL, NULL, '2023-05-30 10:43:55', '2023-05-30 10:43:55', '2023-05-30 10:43:55'),
(431, 'posr-20230530-015328', 1, 17, 2, 0, 0, 0, 3, 10, 1, 1, 0, 4.3, 35, 39.9, NULL, 4.9, 0, NULL, NULL, NULL, 1, 4, NULL, 39.9, NULL, NULL, '2023-05-30 10:53:28', '2023-05-30 10:53:28', '2023-05-30 10:53:28'),
(432, 'posr-20230530-020418', 1, 17, 2, 0, 0, 0, 3, 10, 1, 1, 0, 4.9, 39.9, 39.9, NULL, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 39.9, NULL, NULL, '2023-05-30 11:04:18', '2023-05-30 11:04:18', '2023-05-30 11:04:18'),
(433, 'posr-20230530-021306', 1, 17, 2, 0, 0, 0, 3, 10, 2, 2, 0, 4.9, 64.9, 64.9, NULL, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 64.9, NULL, NULL, '2023-05-30 11:13:06', '2023-05-30 11:13:06', '2023-05-30 11:13:06'),
(434, 'posr-20230530-024029', 1, 17, 2, 0, 0, 0, 3, 10, 2, 2, 0, 9.2, 74.9, 74.9, NULL, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 74.9, NULL, NULL, '2023-05-30 11:40:29', '2023-05-30 11:40:29', '2023-05-30 11:40:29'),
(435, 'posr-20230530-024210', 1, 17, 2, 0, 0, 0, 3, 10, 2, 2, 0, 4.3, 70, 70, NULL, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 70, NULL, NULL, '2023-05-30 11:42:10', '2023-05-30 11:42:10', '2023-05-30 11:42:10'),
(436, 'posr-20230530-074930', 1, 17, 2, 0, 0, 0, 3, 10, 1, 1, 0, 0, 35, 35, NULL, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 35, NULL, NULL, '2023-05-31 04:49:30', '2023-05-31 04:49:30', '2023-05-31 04:49:30'),
(437, 'posr-20230530-080926', 1, 17, 2, 0, 0, 0, 3, 10, 2, 10, 0, 21.49, 350, 350, NULL, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 350, NULL, NULL, '2023-05-31 05:09:26', '2023-05-31 05:09:26', '2023-05-31 05:09:26'),
(438, 'posr-20230530-080953', 1, 17, 2, 0, 0, 0, 3, 10, 1, 3, 0, 0, 105, 105, NULL, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 105, NULL, NULL, '2023-05-31 05:09:53', '2023-05-31 05:09:53', '2023-05-31 05:09:53'),
(439, 'posr-20230530-081350', 1, 17, 2, 0, 0, 0, 3, 10, 2, 4, 0, 8.6, 140, 140, NULL, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 140, NULL, NULL, '2023-05-31 05:13:50', '2023-05-31 05:13:50', '2023-05-31 05:13:50'),
(440, 'posr-20230530-082228', 1, 17, 2, 0, 0, 0, 3, 10, 2, 2, 0, 4.3, 70, 70, NULL, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 70, NULL, NULL, '2023-05-31 05:22:28', '2023-05-31 05:22:28', '2023-05-31 05:22:28'),
(441, 'posr-20230530-082400', 1, 17, 2, 0, 0, 0, 3, 10, 2, 10, 0, 12.89, 350, 350, NULL, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 350, NULL, NULL, '2023-05-31 05:24:00', '2023-05-31 05:24:00', '2023-05-31 05:24:00'),
(442, 'posr-20230530-082503', 1, 17, 2, 0, 0, 0, 3, 10, 2, 4, 0, 4.9, 144.9, 144.9, NULL, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 144.9, NULL, NULL, '2023-05-31 05:25:03', '2023-05-31 05:25:03', '2023-05-31 05:25:03'),
(443, 'posr-20230530-090017', 1, 17, 2, 0, 0, 0, 3, 10, 2, 3, 0, 4.9, 109.9, 109.9, NULL, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 109.9, NULL, NULL, '2023-05-31 06:00:17', '2023-05-31 06:00:17', '2023-05-31 06:00:17'),
(444, 'posr-20230530-092706', 1, 17, 2, 0, 0, 0, 3, 10, 2, 3, 0, 4.9, 109.9, 109.9, NULL, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 109.9, NULL, NULL, '2023-05-31 06:27:06', '2023-05-31 06:27:06', '2023-05-31 06:27:06'),
(445, 'posr-20230530-103119', 1, 17, 2, 0, 0, 0, 3, 10, 1, 2, 0, 0, 70, 70, NULL, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 70, NULL, NULL, '2023-05-31 07:31:19', '2023-05-31 07:31:19', '2023-05-31 07:31:19'),
(446, 'posr-20230530-104345', 1, NULL, 2, 0, 0, 0, 3, 10, 1, 2, 0, 0, 70, 70, NULL, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 70, NULL, NULL, '2023-05-31 07:43:45', '2023-05-31 07:43:45', '2023-05-31 07:43:45'),
(447, 'posr-20230531-104825', 1, 18, 2, 0, 0, 0, 3, 10, 2, 2, 0, 4.9, 74.9, 74.9, NULL, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 74.9, NULL, NULL, '2023-05-31 07:48:25', '2023-05-31 07:48:25', '2023-05-31 07:48:25'),
(448, 'posr-20230531-105457', 1, 18, 7, 0, 0, 0, 3, 10, 2, 2, 0, 4.9, 74.9, 74.9, NULL, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 74.9, NULL, NULL, '2023-05-31 07:54:57', '2023-05-31 07:54:57', '2023-05-31 07:54:57'),
(449, 'posr-20230531-110200', 1, 18, 2, 0, 0, 0, 3, 10, 2, 5, 0, 9.8, 184.8, 184.8, NULL, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 184.8, NULL, NULL, '2023-05-31 08:02:00', '2023-05-31 08:02:00', '2023-05-31 08:02:00'),
(450, 'posr-20230531-110543', 1, 18, 2, 0, 0, 0, 3, 10, 14, 14, 0, 5.51, 271.9, 271.9, NULL, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 271.9, NULL, NULL, '2023-05-31 08:05:43', '2023-05-31 08:05:43', '2023-05-31 08:05:43'),
(451, 'posr-20230531-111210', 1, 18, 2, 0, 0, 0, 3, 10, 1, 1, 0, 0, 35, 35, NULL, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 35, NULL, NULL, '2023-05-31 08:12:10', '2023-05-31 08:12:10', '2023-05-31 08:12:10'),
(452, 'posr-20230531-114854', 1, 18, 2, 0, 0, 0, 3, 10, 2, 2, 0, 4.9, 74.9, 74.9, NULL, 0, 0, NULL, NULL, NULL, 4, 4, NULL, 74.9, NULL, NULL, '2023-05-31 08:48:54', '2023-05-31 08:48:54', '2023-05-31 08:53:02'),
(453, 'posr-20230531-084525', 1, 18, 2, 0, 0, 0, 3, 10, 1, 1, 0, 5.25, 40.25, 40.25, NULL, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 40.25, NULL, NULL, '2023-06-01 05:45:25', '2023-06-01 05:45:25', '2023-06-01 05:45:25'),
(454, 'posr-20230531-084609', 1, 18, 2, 0, 0, 0, 3, 10, 1, 1, 0, 4.57, 35, 35, NULL, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 35, NULL, NULL, '2023-06-01 05:46:09', '2023-06-01 05:46:09', '2023-06-01 05:46:09'),
(455, 'posr-20230531-085341', 1, 18, 8, 0, 0, 0, 3, 10, 1, 1, 0, 4.57, 35, 35, NULL, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 35, NULL, NULL, '2023-06-01 05:53:41', '2023-06-01 05:53:41', '2023-06-01 05:53:41'),
(456, 'posr-20230531-085348', 1, 18, 8, 0, 0, 0, 3, 10, 1, 1, 0, 4.57, 35, 35, NULL, 0, 0, NULL, NULL, NULL, 1, 4, NULL, 35, NULL, NULL, '2023-06-01 05:53:48', '2023-06-01 05:53:48', '2023-06-01 05:53:48');

-- --------------------------------------------------------

--
-- Table structure for table `stock_counts`
--

DROP TABLE IF EXISTS `stock_counts`;
CREATE TABLE IF NOT EXISTS `stock_counts` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `warehouse_id` int NOT NULL,
  `category_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `brand_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` int NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `initial_file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `final_file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `is_adjusted` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `stock_counts`
--

INSERT INTO `stock_counts` (`id`, `reference_no`, `warehouse_id`, `category_id`, `brand_id`, `user_id`, `type`, `initial_file`, `final_file`, `note`, `is_adjusted`, `created_at`, `updated_at`) VALUES
(14, 'scr-20221214-014354', 3, NULL, NULL, 1, 'full', '20221214-014354.csv', NULL, NULL, 0, '2022-12-14 13:43:54', '2022-12-14 13:43:54'),
(15, 'scr-20221229-082623', 3, NULL, NULL, 1, 'full', '20221229-082623.csv', NULL, NULL, 0, '2022-12-29 20:26:23', '2022-12-29 20:26:23'),
(16, 'scr-20230314-114807', 3, NULL, NULL, 1, 'full', '20230314-114807.csv', '20230314-114908.csv', NULL, 1, '2023-03-14 09:48:07', '2023-03-14 09:52:31'),
(17, 'scr-20230315-101809', 3, NULL, NULL, 1, 'full', '20230315-101809.csv', '20230315-101914.csv', NULL, 1, '2023-03-15 08:18:09', '2023-03-15 08:20:36'),
(18, 'scr-20230315-112207', 3, NULL, NULL, 1, 'full', '20230315-112207.csv', NULL, NULL, 0, '2023-03-15 09:22:07', '2023-03-15 09:22:07'),
(19, 'scr-20230409-123034', 3, NULL, NULL, 1, 'full', '20230409-123034.csv', '20230409-123325.csv', NULL, 1, '2023-04-09 10:30:34', '2023-04-09 10:34:27');

-- --------------------------------------------------------

--
-- Table structure for table `suppliers`
--

DROP TABLE IF EXISTS `suppliers`;
CREATE TABLE IF NOT EXISTS `suppliers` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `vat_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone_number` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postal_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `suppliers`
--

INSERT INTO `suppliers` (`id`, `name`, `image`, `company_name`, `vat_number`, `email`, `phone_number`, `address`, `city`, `state`, `postal_code`, `country`, `is_active`, `created_at`, `updated_at`) VALUES
(3, 'Cash Supplier', NULL, 'Cash Supplier', NULL, 'CashSupplier@CashSupplier.com', '01111111111', 'Cash Supplier', 'Cairo', NULL, NULL, NULL, 1, '2022-09-05 13:23:42', '2022-09-05 13:23:42');

-- --------------------------------------------------------

--
-- Table structure for table `tables`
--

DROP TABLE IF EXISTS `tables`;
CREATE TABLE IF NOT EXISTS `tables` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `count` int DEFAULT NULL,
  `floor_id` int DEFAULT NULL,
  `photo` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `taxes`
--

DROP TABLE IF EXISTS `taxes`;
CREATE TABLE IF NOT EXISTS `taxes` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rate` double NOT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `taxes`
--

INSERT INTO `taxes` (`id`, `name`, `rate`, `is_active`, `created_at`, `updated_at`) VALUES
(1, '15%', 15, 1, '2022-04-26 14:29:32', '2023-06-01 05:43:02');

-- --------------------------------------------------------

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
CREATE TABLE IF NOT EXISTS `transfers` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int NOT NULL,
  `status` int NOT NULL,
  `from_warehouse_id` int NOT NULL,
  `to_warehouse_id` int NOT NULL,
  `item` int NOT NULL,
  `total_qty` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_cost` double NOT NULL,
  `shipping_cost` double DEFAULT NULL,
  `grand_total` double NOT NULL,
  `document` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `units`
--

DROP TABLE IF EXISTS `units`;
CREATE TABLE IF NOT EXISTS `units` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `unit_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `unit_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `base_unit` int DEFAULT NULL,
  `operator` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `operation_value` double DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `units`
--

INSERT INTO `units` (`id`, `unit_code`, `unit_name`, `base_unit`, `operator`, `operation_value`, `is_active`, `created_at`, `updated_at`) VALUES
(1, '1', 'كوب', NULL, '*', 1, 1, '2021-12-31 15:42:49', '2021-12-31 15:42:49'),
(2, '2', 'طبق', NULL, '*', 1, 1, '2021-12-31 21:20:57', '2021-12-31 21:20:57'),
(3, '3', 'عدد', NULL, '*', 1, 1, '2021-12-31 21:21:51', '2021-12-31 21:21:51'),
(4, 'كيلو', 'كيلو', NULL, '*', 1, 1, '2022-01-31 15:48:03', '2022-01-31 15:48:03'),
(5, 'جرام', 'جرام', 4, '/', 1000, 1, '2022-01-31 15:48:30', '2023-05-08 11:46:46'),
(6, 'قطعة', 'قطعة', NULL, '*', 1, 1, '2022-01-31 15:48:46', '2022-01-31 15:48:46');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
CREATE TABLE IF NOT EXISTS `users` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `role_id` int NOT NULL,
  `biller_id` int DEFAULT NULL,
  `warehouse_id` int DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL,
  `is_deleted` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `name`, `email`, `password`, `remember_token`, `phone`, `company_name`, `role_id`, `biller_id`, `warehouse_id`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES
(1, 'admin', 'admin@gmail.com', '$2y$10$qkVihXeX7E7ytPLF7LgoN.OhLpRJdUPvhTZaJINDqOWjElYPzhizS', 'TnWZMz4dHPiycnoGK77yGrJ01wq402IK8ks32uDt4lATI4WzvC72qX4h2rfH', '12112', 'SkyPark', 1, NULL, NULL, 1, 0, '2018-06-02 03:24:15', '2022-09-09 16:42:27'),
(26, 'dev', 'dev@dev.com', '$2y$10$cWSH/4BEqsNWPojt2812z.s24AAfQknKjHbHAeU1MISl3wKmIcJx2', 'ld6s4sDvDuxQ64yXfzoKlGhrNU5zqsil2KSI2AOkFKAajN7MPl37s0ph75qq', '12112', 'Motaweron', 1, NULL, NULL, 0, 1, '2018-06-02 03:24:15', '2022-08-07 15:06:46'),
(27, 'abdullah', 'admin@admin.com', '$2y$10$CNOa6PN5572cxW.70ViYS.e7eytBE7GE0U24WPhq4ijN4Sc/.G8rq', NULL, '0123456789', 'KidStation', 4, 8, 2, 1, 1, '2022-04-26 13:53:56', '2022-08-07 15:06:46'),
(28, 'Nader', 'nader@nader.com', '$2y$10$BLL1icSNdmGMIGzyjSTmy.ZfWfy2YgsweW.y2bRyGkpFI5UeLfXKS', NULL, '01234567891', '3 Companies', 4, 9, 2, 0, 1, '2022-05-25 14:52:12', '2022-08-07 15:06:46'),
(29, 'SkyPark', 'SkyPark@SkyPark.com', '$2y$10$HADFY6TQLT5PLs1uQm/Tp.W5v3MSkh5YODC2sLIquFO2ERvL8RAym', NULL, '01121411940', 'SkyPark', 7, 10, 3, 1, 0, '2022-09-01 18:15:33', '2022-09-16 11:57:08'),
(30, 'Cashier', 'Cashier@skypark.fun', '$2y$10$RCtfXbWdhggYDunNH.KbD.eT3Kqh/AJPNk/bIpeXLFpNSe79FlsSm', NULL, '01111111245', 'SkyPark', 4, 10, 3, 1, 0, '2022-09-16 11:50:19', '2023-01-20 13:36:47'),
(31, 'Treasury', 'treasury@skypark.fun', '$2y$10$o7l8otfimYcTzcFBJ2u./OI7b88iuXfiRVHxfC5/NLXXAdC2svr3C', NULL, '01156668599', 'SkyPark', 7, 10, 3, 1, 0, '2022-09-18 11:33:16', '2022-09-18 11:33:16');

-- --------------------------------------------------------

--
-- Table structure for table `variants`
--

DROP TABLE IF EXISTS `variants`;
CREATE TABLE IF NOT EXISTS `variants` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `warehouses`
--

DROP TABLE IF EXISTS `warehouses`;
CREATE TABLE IF NOT EXISTS `warehouses` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `warehouses`
--

INSERT INTO `warehouses` (`id`, `name`, `phone`, `email`, `address`, `is_active`, `created_at`, `updated_at`) VALUES
(3, 'Sky_ParkWH', '01156668599', NULL, 'Sodic-6th of October', 1, '2022-08-07 15:08:41', '2022-08-07 15:08:41');

--
-- Constraints for dumped tables
--

--
-- Constraints for table `role_has_permissions`
--
ALTER TABLE `role_has_permissions`
  ADD CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
