@extends('layout.main')
@section('content')
    @if($errors->has('name'))
        <div class="alert alert-danger alert-dismissible text-center">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>{{ $errors->first('name') }}</div>
    @endif
    @if(session()->has('message'))
        <div class="alert alert-success alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>{{ session()->get('message') }}</div>
    @endif
    @if(session()->has('not_permitted'))
        <div class="alert alert-danger alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>{{ session()->get('not_permitted') }}</div>
    @endif

    <section>
{{--        <div class="container-fluid">--}}
{{--            <a href="{{route('makeProduct.create')}}"  class="btn btn-info"><i class="dripicons-plus"></i> {{trans('file.Add production units')}}</a>--}}
{{--            --}}{{--            <a href="#" data-toggle="modal" data-target="#importbranch" class="btn btn-primary"><i class="dripicons-copy"></i> {{trans('file.Import branch')}}</a>--}}
{{--        </div>--}}
        <div class="container-fluid">
            <div class="card">

                {!! Form::open(['route' => 'productionLine.index', 'method' => 'get']) !!}
                <div class="row mb-3">
                    <div class="col-md-4 offset-md-2 mt-3">
                        <div class="form-group row">
                            <label class="d-tc mt-2"><strong>{{trans('file.Choose Your Date')}}</strong> &nbsp;</label>
                            <div class="d-tc">
                                <div class="input-group">
                                    <input type="text" class="daterangepicker-field form-control" value="{{$starting_date}} To {{$ending_date}}" required />
                                    <input type="hidden" name="starting_date" value="{{$starting_date}}" />
                                    <input type="hidden" name="ending_date" value="{{$ending_date}}" />
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 mt-3 @if(\Auth::user()->role_id > 2){{'d-none'}}@endif">
                        <div class="form-group row">
                            <label class="d-tc mt-2"><strong>{{trans('file.Choose Warehouse')}}</strong> &nbsp;</label>
                            <div class="d-tc">
                                <select id="warehouse_id" name="warehouse_id" class="selectpicker form-control" data-live-search="true" data-live-search-style="begins" >
                                    <option value="0">{{trans('file.All Warehouse')}}</option>
                                    @foreach($lims_warehouse_list as $warehouse)
                                        @if($warehouse->id == $warehouse_id)
                                            <option selected value="{{$warehouse->id}}">{{$warehouse->name}}</option>
                                        @else
                                            <option value="{{$warehouse->id}}">{{$warehouse->name}}</option>
                                        @endif
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-2 mt-3">
                        <div class="form-group">
                            <button class="btn btn-primary" id="filter-btn" type="submit">{{trans('file.submit')}}</button>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            </div>
        </div>
        <div class="table-responsive">
            <table id="branch-table" class="table">
                <thead>
                <tr>
                    <th class="not-exported"></th>
                    <th>{{trans('file.product')}}</th>
                    <th >{{trans('file.Warehouse')}}</th>
                    <th >{{trans('file.amount')}}</th>
                    <th >{{trans('file.waste')}}</th>
                    <th >{{trans('file.notes')}}</th>
                </tr>
                </thead>
                <tbody>
                @foreach($lims_productionUnit_data as $key=>$productionUnit)

                    <tr data-id="{{$productionUnit->id}}">
                        <td>{{$key}}</td>
                        <td>{{ $productionUnit->product->name??''}}</td>
                        <td>{{ $productionUnit->warehouse->name??''}}</td>
                        <td>{{ $productionUnit->amount??''}}</td>
                        <td>{{ $productionUnit->waste??''}}</td>
                        <td>{{ $productionUnit->notes??''}}</td>
                        {{--                        <td>{{$number_of_product}}</td>--}}
                        {{--                        <td>{{$stock_qty}}</td>--}}
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </section>


    {{--    <div id="importbranch" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" class="modal fade text-left">--}}
    {{--        <div role="document" class="modal-dialog">--}}
    {{--            <div class="modal-content">--}}
    {{--                {!! Form::open(['route' => 'branch.import', 'method' => 'post', 'files' => true]) !!}--}}
    {{--                <div class="modal-header">--}}
    {{--                    <h5 id="exampleModalLabel" class="modal-title">{{trans('file.Import branch')}}</h5>--}}
    {{--                    <button type="button" data-dismiss="modal" aria-label="Close" class="close"><span aria-hidden="true"><i class="dripicons-cross"></i></span></button>--}}
    {{--                </div>--}}
    {{--                <div class="modal-body">--}}
    {{--                    <p class="italic"><small>{{trans('file.The field labels marked with * are required input fields')}}.</small></p>--}}
    {{--                    <p>{{trans('file.The correct column order is')}} (name*, phone, email, address*) {{trans('file.and you must follow this')}}.</p>--}}
    {{--                    <div class="row">--}}
    {{--                        <div class="col-md-6">--}}
    {{--                            <div class="form-group">--}}
    {{--                                <label>{{trans('file.Upload CSV File')}} *</label>--}}
    {{--                                {{Form::file('file', array('class' => 'form-control','required'))}}--}}
    {{--                            </div>--}}
    {{--                        </div>--}}
    {{--                        <div class="col-md-6">--}}
    {{--                            <div class="form-group">--}}
    {{--                                <label> {{trans('file.Sample File')}}</label>--}}
    {{--                                <a href="public/sample_file/sample_branch.csv" class="btn btn-info btn-block btn-md"><i class="dripicons-download"></i>  {{trans('file.Download')}}</a>--}}
    {{--                            </div>--}}
    {{--                        </div>--}}
    {{--                    </div>--}}
    {{--                    <input type="submit" value="{{trans('file.submit')}}" class="btn btn-primary">--}}
    {{--                </div>--}}
    {{--                {{ Form::close() }}--}}
    {{--            </div>--}}
    {{--        </div>--}}
    {{--    </div>--}}

    <script type="text/javascript">

        $("ul#MakeProduct").siblings('a').attr('aria-expanded','true');
        $("ul#MakeProduct").addClass("show");
        $("ul#MakeProduct #productionLine-menu").addClass("active");

        var make_product_id = [];
        var user_verified = <?php echo json_encode(env('USER_VERIFIED')) ?>;

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        function confirmDelete() {
            if (confirm("Are you sure want to delete?")) {
                return true;
            }
            return false;
        }

        $(document).ready(function() {

            $(document).on('click', '.open-EditbranchDialog', function() {
                var url = "branch/"
                var id = $(this).data('id').toString();
                url = url.concat(id).concat("/edit");

                $.get(url, function(data) {
                    $("#editModal input[name='name']").val(data['name']);
                    $("#editModal input[name='phone']").val(data['phone']);
                    $("#editModal input[name='email']").val(data['email']);
                    $("#editModal textarea[name='address']").val(data['address']);
                    $("#editModal input[name='make_product_id']").val(data['id']);

                    // companySelect
                    $('#companySelect').html(data['html'])
                    $('#companySelect').selectpicker('refresh')

                });
            });
        });

        $('#branch-table').DataTable( {
            "order": [],
            'language': {
                'lengthMenu': '_MENU_ {{trans("file.records per page")}}',
                "info":      '<small>{{trans("file.Showing")}} _START_ - _END_ (_TOTAL_)</small>',
                "search":  '{{trans("file.Search")}}',
                'paginate': {
                    'previous': '<i class="dripicons-chevron-left"></i>',
                    'next': '<i class="dripicons-chevron-right"></i>'
                }
            },
            'columnDefs': [
                {
                    "orderable": false,
                    // 'targets': [0, 6]
                },  {
                    'render': function(data, type, row, meta){
                        if(type === 'display'){
                            data = '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>';
                        }

                        return data;
                    },
                    'checkboxes': {
                        'selectRow': true,
                        'selectAllRender': '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>'
                    },
                    'targets': [0]
                }
            ],
            'select': { style: 'multi',  selector: 'td:first-child'},
            'lengthMenu': [[10, 25, 50, -1], [10, 25, 50, "All"]],
            dom: '<"row"lfB>rtip',
            buttons: [
                {
                    extend: 'pdf',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible'
                    },
                },
                {
                    extend: 'csv',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible'
                    },
                },
                {
                    extend: 'print',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible'
                    },
                },
                {
                    text: '{{trans("file.delete")}}',
                    className: 'buttons-delete',
                    action: function ( e, dt, node, config ) {
                        if(user_verified == '1') {
                            make_product_id.length = 0;
                            $(':checkbox:checked').each(function(i){
                                if(i){
                                    make_product_id[i-1] = $(this).closest('tr').data('id');
                                }
                            });
                            if(make_product_id.length && confirm("Are you sure want to delete?")) {
                                $.ajax({
                                    type:'POST',
                                    url:'makeProduct/deletebyselection',
                                    data:{
                                        makeProductIdArray: make_product_id
                                    },
                                    success:function(data){
                                        alert(data);
                                    }
                                });
                                dt.rows({ page: 'current', selected: true }).remove().draw(false);
                            }
                            else if(!make_product_id.length)
                                alert('No row is selected!');
                        }
                        else
                            alert('This feature is disable for demo!');
                    }
                },
                {
                    extend: 'colvis',
                    columns: ':gt(0)'
                },
            ],
        } );

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $( "#select_all" ).on( "change", function() {
            if ($(this).is(':checked')) {
                $("tbody input[type='checkbox']").prop('checked', true);
            }
            else {
                $("tbody input[type='checkbox']").prop('checked', false);
            }
        });

        $("#export").on("click", function(e){
            e.preventDefault();
            var branch = [];
            $(':checkbox:checked').each(function(i){
                branch[i] = $(this).val();
            });
            $.ajax({
                type:'POST',
                url:'/exportbranch',
                data:{

                    branchArray: branch
                },
                success:function(data){
                    alert('Exported to CSV file successfully! Click Ok to download file');
                    window.location.href = data;
                }
            });
        });
        $('.selectpicker').selectpicker('refresh');
        $(".daterangepicker-field").daterangepicker({
            callback: function(startDate, endDate, period){
                var starting_date = startDate.format('YYYY-MM-DD');
                var ending_date = endDate.format('YYYY-MM-DD');
                var title = starting_date + ' To ' + ending_date;
                $(this).val(title);
                $('input[name="starting_date"]').val(starting_date);
                $('input[name="ending_date"]').val(ending_date);
            }
        });

    </script>
@endsection
