@extends('layout.main')
@section('content')

    @if(session()->has('message'))
        <div class="alert alert-success alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>{{ session()->get('message') }}</div>
    @endif

    @if(session()->has('not_permitted'))
        <div class="alert alert-danger alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>{{ session()->get('not_permitted') }}</div>
    @endif
    <section class="forms">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header d-flex align-items-center">
                            <h4>{{trans('file.Add manufacturing order')}}</h4>
                        </div>
                        <div class="card-body">
                            <p class="italic"><small>{{trans('file.The field labels marked with * are required input fields')}}.</small></p>
                            {!! Form::open(['route' => 'manufacturingOrder.store', 'files' => true, 'method' => 'post']) !!}
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{trans('file.Select Product')}} *</label>

                                        <select required id="make_product_id" name="make_product_id" class="form-control" data-live-search="true" data-live-search-style="begins" title="{{trans('file.Select final Product')}}...">
                                            @foreach($lims_makeProduct_data as $makeProduct)
                                                <option value="{{$makeProduct->id}}">{{$makeProduct->product->name??'' }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{trans('file.amount')}} *</label>
                                        <input id="amount" name="amount" placeholder="{{trans('file.amount')}}" required class="form-control numbersOnly">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{trans('file.Warehouse')}} *</label>

                                        <select required id="warehouse_id" name="warehouse_id" class="form-control" data-live-search="true" data-live-search-style="begins" title="{{trans('file.Warehouse')}}...">
                                            @foreach($lims_warehouses_data as $warehouse)
                                                <option value="{{$warehouse->id}}">{{$warehouse->name??'' }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>





                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{trans('file.notes')}} </label>

                                        <input type="text" name="notes"  class="form-control"  placeholder="{{trans('file.notes')}}..." >
                                    </div>

                                <div class="form-group">
                                    <button type="button" id="searchInProducts" class="btn btn-primary">{{trans('file.Search in products')}}</button>
                                </div>
                            </div>
                                <div class="col-md-12">

                                    <div class="table-responsive-md col-sm-12" id="appendTo">
                                        <table class="table table-striped-table-bordered table-hover table-checkable table-" id="tbl_posts">
                                            <thead>
                                            <tr>

                                                <th>#</th>
                                                <th >{{trans('file.Select Product')}}</th>
                                                <th >{{trans('file.amount')}}</th>
                                                <th >{{trans('file.notes')}}</th>
                                            </tr>
                                            </thead>
                                            <tbody id="tbl_posts_body">

                                            </tbody>
                                        </table>
                                    </div>

                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input type="submit" value="{{trans('file.submit')}}" class="btn btn-primary">
                                    </div>
                                </div>
                            </div>
                            {!! Form::close() !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <script type="text/javascript">

        $("ul#MakeProduct").siblings('a').attr('aria-expanded','true');
        $("ul#MakeProduct").addClass("show");
        $("ul#MakeProduct #manufacturingOrder-menu").addClass("active");

        $('.selectpicker').selectpicker('refresh');

    </script>

    <script>
        $(document).on('keyup','.numbersOnly',function () {
            this.value = this.value.replace(/[^0-9\.]/g,'');
        });
        jQuery(document).delegate('a.add-record', 'click', function(e) {
            e.preventDefault();
            var  size = jQuery('#tbl_posts >tbody >tr').length + 1,
                content ,
                element = null,
                url = '{{route('makeProduct.show',":id")}}';
            url = url.replace(':id', size);
            $.get( url, function( data ) {
                $('#tbl_posts_body').append(data);
            });
            // element = content.clone();
            // element.attr('id', 'rec-'+size);
            // element.find('.delete-record').attr('data-id', size);
            // element.find('.sn').html(size);

        });
        jQuery(document).delegate('a.delete-record', 'click', function(e) {

            e.preventDefault();
            // var didConfirm = confirm("Are you sure You want to delete");
            // if (didConfirm == true) {


            var  countProducts = $('.MainMakeProduct').length

            console.log(countProducts)

            if (countProducts == 1){
                alert("{{trans('file.you can`t delete')}}")
                return true;
            }


            var id = jQuery(this).attr('data-id');
            var targetDiv = jQuery(this).attr('targetDiv');
            jQuery('#rec-' + id).remove();

            //regnerate index number on table
            $('#tbl_posts_body tr').each(function (index) {
                //alert(index);
                $(this).find('span.sn').html(index + 1);
            });
            return true;
            // } else {
            //   return false;
            // }
        });

        $('#searchInProducts').click(function (e){
            e.preventDefault()
            var make_product_id,amount,url;

            amount = $('#amount').val()

            make_product_id = $('#make_product_id').val()

            url = '{{route('manufacturingOrder.getProducts')}}?make_product_id='+make_product_id + '&amount='+amount;
            $.get( url, function( data ) {
                $('#tbl_posts_body').html(data)
                console.log(data)
            });

        })

    </script>
@endsection
