<?php

namespace App\Http\Controllers;

use App\Discount;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;

class DiscountController extends Controller
{
    public function index()
    {
        if(auth()->user()->role_id == 1){
            $discounts = Discount::latest()->get();
            return view('discount.index', compact('discounts'));
        } else {
            return redirect()->back()->with('not_permitted', 'Sorry! You are not allowed to access this module');
        }
    } // end of index

    public function store(Request $request)
    {

        $data = $request->all();
        //        dd($data);
        Discount::create($data);
        return redirect()->route('discounts.index')->with('message', 'Discounts created successfully');
    } // end of store

    public function edit($id)
    {
        return Discount::findOrFail($id);
    }


    public function update(Request $request)
    {
        $data = $request->except(['id']);

        $discount = Discount::findOrFail($request->id);

        $discount->update($data);

        return redirect()->route('discounts.index')->with('message', 'Discounts updated successfully');
    }


    public function destroy($id)
    {
        $discounts = Discount::findOrFail($id);
        $discounts->delete();
        return redirect()->route('discounts.index')->with('message', 'Discounts Deleted successfully');
    }
}
